/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.search.assetconditionbuilder;

import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.tandbergtv.metadatamanager.search.assetconditionbuilder.AssetBooleanConditionBuilder;
import com.tandbergtv.metadatamanager.search.assetconditionbuilder.AssetNumberConditionBuilder;
import com.tandbergtv.metadatamanager.search.assetconditionbuilder.AssetStringConditionBuilder;
import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;
import java.util.List;

public class AssetConditionBuilder {
    protected Predicate predicate;
    protected static final String UNPARSABLE_PATH = "UnparsableFields/UnparsableField";
    protected static final String UNPARSABLE_ATTRIBUTE = "@xpath";

    protected AssetConditionBuilder(Predicate predicate) {
        this.predicate = predicate;
    }

    protected String getRhsValue() {
        PredicateRightValue prv = (PredicateRightValue)this.predicate;
        return (String)prv.getValue().get(0);
    }

    protected List<String> getValues() {
        PredicateRightValue prv = (PredicateRightValue)this.predicate;
        return prv.getValue();
    }

    protected String getXpath() {
        String field = this.predicate.getFieldLeft();
        if (field.startsWith("/")) {
            return field.substring(1);
        }
        return field;
    }

    protected String isEmpty() {
        StringBuffer condition = new StringBuffer();
        condition.append("not(");
        condition.append(this.getXpath());
        condition.append(")");
        if (this.predicate.getFieldLeft().startsWith("/Fields")) {
            condition.insert(0, "(");
            condition.append(" and  not(");
            condition.append(UNPARSABLE_PATH);
            condition.append("[");
            condition.append("fn:starts-with");
            condition.append("(");
            condition.append(UNPARSABLE_ATTRIBUTE);
            condition.append(", \"");
            condition.append(this.predicate.getFieldLeft());
            condition.append("\")]");
            condition.append("))");
        }
        return condition.toString();
    }

    protected String isNotEmpty() {
        StringBuffer condition = new StringBuffer();
        condition.append(this.getXpath());
        if (this.predicate.getFieldLeft().startsWith("/Fields")) {
            condition.insert(0, "(");
            condition.append(" OR ");
            condition.append(UNPARSABLE_PATH);
            condition.append("[");
            condition.append("fn:starts-with");
            condition.append("(");
            condition.append(UNPARSABLE_ATTRIBUTE);
            condition.append(", \"");
            condition.append(this.predicate.getFieldLeft());
            condition.append("\")]");
            condition.append(")");
        }
        return condition.toString();
    }

    protected String contains() {
        throw new RuntimeException("OMG, Unsupported Operation");
    }

    protected String endsWith() {
        throw new RuntimeException("OMG, Unsupported Operation");
    }

    protected String equal() {
        throw new RuntimeException("OMG, Unsupported Operation");
    }

    protected String greaterThan() {
        throw new RuntimeException("OMG, Unsupported Operation");
    }

    protected String greaterThanEqual() {
        throw new RuntimeException("OMG, Unsupported Operation");
    }

    protected String greaterThanToday() {
        throw new RuntimeException("OMG, Unsupported Operation");
    }

    protected String in() {
        throw new RuntimeException("OMG, Unsupported Operation");
    }

    protected String lessThan() {
        throw new RuntimeException("OMG, Unsupported Operation");
    }

    protected String lessThanEqual() {
        throw new RuntimeException("OMG, Unsupported Operation");
    }

    protected String lessThanToday() {
        throw new RuntimeException("OMG, Unsupported Operation");
    }

    protected String notContains() {
        throw new RuntimeException("OMG, Unsupported Operation");
    }

    protected String notEqual() {
        throw new RuntimeException("OMG, Unsupported Operation");
    }

    protected String startsWith() {
        throw new RuntimeException("OMG, Unsupported Operation");
    }

    protected String notIn() {
        throw new RuntimeException("OMG, Unsupported Operation");
    }

    protected String notLessThanToday() {
        throw new RuntimeException("OMG, Unsupported Operation");
    }

    protected String notGreaterThanToday() {
        throw new RuntimeException("OMG, Unsupported Operation");
    }

    protected String between() {
        throw new RuntimeException("OMG, Unsupported Operation");
    }

    protected String doesNotEndWith() {
        throw new RuntimeException("OMG, Unsupported Operation");
    }

    protected String doesNotStartWith() {
        throw new RuntimeException("OMG, Unsupported Operation");
    }

    private static AssetConditionBuilder getConditionBuilder(Predicate predicate) {
        DataTypeMappingReader dtr = DataTypeMappingReader.getInstance();
        String dataType = dtr.determineDataType(predicate.getFieldLeft());
        if (dataType == null) {
            return new AssetConditionBuilder(predicate);
        }
        if (dataType.equals("integer") || dataType.equals("float")) {
            return new AssetNumberConditionBuilder(predicate);
        }
        if (dataType.equals("string")) {
            return new AssetStringConditionBuilder(predicate);
        }
        if (dataType.equals("boolean")) {
            return new AssetBooleanConditionBuilder(predicate);
        }
        return new AssetConditionBuilder(predicate);
    }

    private String getCondition() {
        switch (this.predicate.getSearchComplientOperator()) {
            case EQUAL: {
                return this.equal();
            }
            case NOTEQUAL: {
                return this.notEqual();
            }
            case LESSTHAN: {
                return this.lessThan();
            }
            case GREATERTHAN: {
                return this.greaterThan();
            }
            case LESSTHANEQUAL: {
                return this.lessThanEqual();
            }
            case GREATERTHANEQUAL: {
                return this.greaterThanEqual();
            }
            case ISNULL: {
                return this.isEmpty();
            }
            case ISNOTNULL: {
                return this.isNotEmpty();
            }
            case ISEMPTY: {
                return this.isEmpty();
            }
            case ISNOTEMPTY: {
                return this.isNotEmpty();
            }
            case CONTAINS: {
                return this.contains();
            }
            case DOESNOTCONTAIN: {
                return this.notContains();
            }
            case IN: {
                return this.in();
            }
            case NOTIN: {
                return this.notIn();
            }
            case STARTSWITH: {
                return this.startsWith();
            }
            case ENDSWITH: {
                return this.endsWith();
            }
            case DOESNOTSTARTWITH: {
                return this.doesNotStartWith();
            }
            case DOESNOTENDWITH: {
                return this.doesNotEndWith();
            }
            case GREATERTHANTODAY: {
                return this.greaterThanToday();
            }
            case LESSTHANTODAY: {
                return this.lessThanToday();
            }
            case NOTGREATERTHANTODAY: {
                return this.notGreaterThanToday();
            }
            case NOTLESSTHANTODAY: {
                return this.notLessThanToday();
            }
            case BETWEEN: {
                return this.between();
            }
        }
        throw new RuntimeException("OMG, Encountered the unsupported operator " + this.predicate.getSearchComplientOperator());
    }

    public static String getCondition(Predicate predicate) {
        AssetConditionBuilder conditionBuilder = AssetConditionBuilder.getConditionBuilder(predicate);
        return conditionBuilder.getCondition();
    }
}

