/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.search.assetconditionbuilder;

import com.ericsson.cms.criteria.Predicate;
import com.tandbergtv.metadatamanager.search.assetconditionbuilder.AssetConditionBuilder;
import java.util.List;

public class AssetNumberConditionBuilder
extends AssetConditionBuilder {
    public AssetNumberConditionBuilder(Predicate predicate) {
        super(predicate);
    }

    @Override
    protected String equal() {
        return this.buildSimpleCondition("=");
    }

    @Override
    protected String notEqual() {
        String rhsValue = this.getRhsValue();
        StringBuffer condition = new StringBuffer();
        String xpath = this.getXpath();
        condition.append("(");
        condition.append("not(");
        condition.append(xpath);
        condition.append(") or ");
        condition.append(xpath);
        condition.append("!=");
        condition.append(rhsValue);
        condition.append(")");
        return condition.toString();
    }

    @Override
    protected String greaterThan() {
        return this.buildSimpleCondition(">");
    }

    @Override
    protected String greaterThanEqual() {
        return this.buildSimpleCondition(">=");
    }

    @Override
    protected String lessThan() {
        return this.buildSimpleCondition("<");
    }

    @Override
    protected String lessThanEqual() {
        return this.buildSimpleCondition("<=");
    }

    @Override
    protected String in() {
        List<String> values = this.getValues();
        if (values.size() == 0) {
            return "";
        }
        StringBuffer condition = new StringBuffer();
        String xpath = this.getXpath();
        condition.append("(");
        for (int i = 0; i < values.size(); ++i) {
            String rhsValue = values.get(i);
            if (i > 0) {
                condition.append(" or ");
            }
            condition.append(xpath);
            condition.append("=");
            condition.append(rhsValue);
        }
        condition.append(")");
        return condition.toString();
    }

    @Override
    protected String notIn() {
        List<String> values = this.getValues();
        if (values.size() == 0) {
            return "";
        }
        StringBuffer condition = new StringBuffer();
        String xpath = this.getXpath();
        condition.append("(");
        for (int i = 0; i < values.size(); ++i) {
            String rhsValue = values.get(i);
            if (i > 0) {
                condition.append(" and ");
            }
            condition.append(xpath);
            condition.append("!=");
            condition.append(rhsValue);
        }
        condition.append(")");
        return condition.toString();
    }

    private String buildSimpleCondition(String operator) {
        String rhsValue = this.getRhsValue();
        StringBuffer condition = new StringBuffer();
        String xpath = this.getXpath();
        condition.append(xpath);
        condition.append(operator);
        condition.append(rhsValue);
        return condition.toString();
    }
}

