/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.search.assetconditionbuilder;

import com.ericsson.cms.criteria.Predicate;
import com.tandbergtv.metadatamanager.search.assetconditionbuilder.AssetConditionBuilder;
import java.util.List;

public class AssetStringConditionBuilder
extends AssetConditionBuilder {
    public AssetStringConditionBuilder(Predicate predicate) {
        super(predicate);
    }

    @Override
    protected String equal() {
        return this.simpleConditionHelper(" = ");
    }

    @Override
    protected String notEqual() {
        StringBuffer condition = new StringBuffer();
        condition.append("(");
        condition.append("not(");
        condition.append(this.getXpath());
        condition.append(") or ");
        condition.append(this.getICCXpath());
        condition.append(" != ");
        condition.append(this.getICCRhsValue());
        condition.append(")");
        return condition.toString();
    }

    protected String simpleConditionHelper(String operator) {
        StringBuffer condition = new StringBuffer();
        condition.append(this.getICCXpath());
        condition.append(operator);
        condition.append(this.getICCRhsValue());
        return condition.toString();
    }

    private String getICCXpath() {
        if (this.predicate.getIgnoreCase()) {
            return "fn:upper-case(" + this.getXpath() + ")";
        }
        return this.getXpath();
    }

    private String getICCRhsValue() {
        StringBuffer sb = new StringBuffer("\"");
        if (this.predicate.getIgnoreCase()) {
            sb.append(this.getRhsValue().toUpperCase());
        } else {
            sb.append(this.getRhsValue());
        }
        sb.append("\"");
        return sb.toString();
    }

    @Override
    protected String in() {
        List<String> values = this.getValues();
        if (values.size() == 0) {
            return "";
        }
        StringBuffer condition = new StringBuffer();
        String xpath = this.getICCXpath();
        condition.append("(");
        for (int i = 0; i < values.size(); ++i) {
            if (i > 0) {
                condition.append(" or ");
            }
            condition.append(xpath);
            condition.append("=");
            condition.append(this.getICCRhsValue());
        }
        condition.append(")");
        return condition.toString();
    }

    @Override
    protected String notIn() {
        List<String> values = this.getValues();
        if (values.size() == 0) {
            return "";
        }
        StringBuffer condition = new StringBuffer();
        String xpath = this.getICCXpath();
        condition.append("(");
        for (int i = 0; i < values.size(); ++i) {
            if (i > 0) {
                condition.append(" and ");
            }
            condition.append(xpath);
            condition.append("!=");
            condition.append(this.getICCRhsValue());
        }
        condition.append(")");
        return condition.toString();
    }

    @Override
    protected String contains() {
        StringBuffer condition = new StringBuffer();
        condition.append("ora:contains(");
        condition.append(this.getXpath());
        condition.append("/text()");
        condition.append(", \"");
        condition.append(this.getRhsValue());
        condition.append("\") > 0]");
        return condition.toString();
    }

    @Override
    protected String notContains() {
        StringBuffer condition = new StringBuffer();
        condition.append("ora:contains(");
        condition.append(this.getXpath());
        condition.append("/text()");
        condition.append(", \"");
        condition.append(this.getRhsValue());
        condition.append("\") = 0]");
        return condition.toString();
    }

    @Override
    protected String startsWith() {
        return this.getFuncCondition("fn:starts-with");
    }

    private String getFuncCondition(String function) {
        StringBuffer condition = new StringBuffer();
        condition.append(function);
        condition.append("(");
        condition.append(this.getICCXpath());
        condition.append(", ");
        condition.append(this.getICCRhsValue());
        condition.append(")");
        return condition.toString();
    }

    @Override
    protected String doesNotStartWith() {
        return "not(" + this.startsWith() + ")";
    }

    @Override
    protected String endsWith() {
        return this.getFuncCondition("fn:starts-with");
    }

    @Override
    protected String doesNotEndWith() {
        return "not(" + this.endsWith() + ")";
    }
}

