/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.specimpl;

import com.ericsson.cms.criteria.ExpList;
import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.ExpValue;
import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.LogicalOperator;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.factoryImpl.SpecHandlerFactory;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.metadatamanager.model.SearchCriteria;
import com.tandbergtv.metadatamanager.search.AssetSearchKey;
import com.tandbergtv.metadatamanager.search.AssetSearchService;
import com.tandbergtv.metadatamanager.search.SearchFieldBuilder;
import com.tandbergtv.metadatamanager.spec.IIdentifier;
import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import com.tandbergtv.metadatamanager.specimpl.SpecHandlerBase;
import com.tandbergtv.metadatamanager.specimpl.ttv.TTVId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class AssetValidator {
    private SpecHandlerBase parentHandler;

    public AssetValidator(SpecHandlerBase specificationHandler) {
        this.parentHandler = specificationHandler;
    }

    public void validate(Asset rootAsset) throws MetadataException {
        Collection<ISpecHandler> handlers = this.getSpecificationHandlersForValidation();
        for (ISpecHandler handler : handlers) {
            this.validateAssetTree(rootAsset, handler, false);
        }
    }

    public void validateWithCurrentSpecification(Asset rootAsset) throws MetadataException {
        this.validateAssetTree(rootAsset, this.parentHandler, false);
    }

    public void validateForPersistence(Asset rootAsset) throws MetadataException {
        Collection<ISpecHandler> handlers = this.getSpecificationHandlersForValidation();
        for (ISpecHandler handler : handlers) {
            this.validateAssetTree(rootAsset, handler, true);
        }
    }

    private void validateAssetTree(Asset rootAsset, ISpecHandler handler, boolean usePersistenceStore) throws MetadataException {
        List<Asset> assets = this.getAssetsInTree(rootAsset);
        ArrayList<SearchCriteria> assetKeys = new ArrayList<SearchCriteria>();
        for (Asset currentAsset : assets) {
            if (!usePersistenceStore) {
                this.validateAssetInTree(currentAsset, handler, assetKeys);
                continue;
            }
            this.doValidateForPersistence(currentAsset);
        }
    }

    private List<Asset> getAssetsInTree(Asset asset) {
        ArrayList<Asset> assets = new ArrayList<Asset>();
        this.getAssetsInTree(asset, assets);
        return assets;
    }

    private void getAssetsInTree(Asset asset, List<Asset> assets) {
        assets.add(asset);
        int currentIndex = 0;
        while (currentIndex < assets.size()) {
            Asset currentAsset;
            if ((currentAsset = assets.get(currentIndex++)).getRelations() == null) continue;
            for (Relation relation : asset.getRelations()) {
                Asset target = relation.getTargetAsset();
                if (assets.contains(target)) continue;
                assets.add(target);
            }
        }
    }

    private void validateAssetInTree(Asset asset, ISpecHandler hander, Collection<SearchCriteria> assetKeys) throws MetadataException {
        SearchCriteria assetKey = this.getAssetSpecificationKey(asset, hander);
        if (assetKey == null || assetKey.isEmptyCriteria()) {
            return;
        }
        if (this.hasAssetKey(assetKeys, assetKey)) {
            String specificationName = hander.getSpecName();
            String msg = "Found multiple assets in asset tree with key " + assetKey.toString() + " for specification " + specificationName + ".";
            throw new MetadataException(msg);
        }
        assetKeys.add(assetKey);
    }

    private void validateAssetForPersistence(Asset asset, ISpecHandler handler) throws MetadataException {
        AssetSearchService service;
        Collection<Long> docIDs;
        TTVId assetID = asset.getTTVId();
        ExpList searchFields = handler.getSearchFieldsToValidatePersistedCopies(asset);
        if (searchFields == null || searchFields.isEmpty()) {
            return;
        }
        if (assetID.isValidIdentifier()) {
            ArrayList<String> values = new ArrayList<String>();
            values.add(String.valueOf(asset.getId()));
            PredicateRightValue checkAssetId = new PredicateRightValue("/@assetId", "", FieldType.ASSET, values, LogicalOperator.NOTEQUAL, Boolean.valueOf(false));
            searchFields.addItem((ExpNode)new ExpValue((Predicate)checkAssetId));
            PredicateRightValue checkOriginal = new PredicateRightValue("/@originalAssetId", "", FieldType.ASSET, values, LogicalOperator.NOTEQUAL, Boolean.valueOf(false));
            searchFields.addItem((ExpNode)new ExpValue((Predicate)checkOriginal));
        }
        int matchingAssetCount = (docIDs = (service = this.parentHandler.searchService).searchForDocId((ExpNode)searchFields)) != null ? docIDs.size() : 0;
        Long originalAssetID = asset.getOriginalAssetID();
        if (matchingAssetCount > 0 && !docIDs.contains(originalAssetID)) {
            String specificationName = handler.getSpecName();
            String assetName = "Asset[";
            assetName = assetName + (assetID.isValidIdentifier() ? Long.valueOf(asset.getId()) : asset.getAssetType());
            assetName = assetName + "]";
            SearchCriteria assetKey = this.getAssetSpecificationKey(asset, handler);
            String msg = assetName + " has key " + assetKey.toString() + " in specification " + specificationName + " which is not unique in the system.";
            throw new MetadataException(msg);
        }
    }

    private SearchCriteria getAssetSpecificationKey(Asset asset, ISpecHandler handler) {
        IIdentifier identifier = handler.extractId(asset);
        if (!identifier.isValidIdentifier()) {
            return null;
        }
        Map<String, String> idPaths = identifier.getTTVPaths();
        Map<String, String> identifiers = identifier.getSpecIdentifiers();
        SearchCriteria criteria = new SearchCriteria();
        for (String specificationIDXPath : idPaths.keySet()) {
            String ttvIDXPath = idPaths.get(specificationIDXPath);
            String value = identifiers.get(specificationIDXPath);
            if (AssetSearchKey.ASSET_ID.toString().equals(ttvIDXPath)) {
                return null;
            }
            if (value != null && value.equals("")) {
                value = null;
            }
            criteria.put(ttvIDXPath, value);
        }
        return criteria;
    }

    private boolean hasAssetKey(Collection<SearchCriteria> assetKeys, SearchCriteria assetKey) {
        for (SearchCriteria currentAssetKey : assetKeys) {
            if (!assetKey.hasSameCriteria(currentAssetKey)) continue;
            return true;
        }
        return false;
    }

    private Collection<ISpecHandler> getSpecificationHandlersForValidation() {
        LinkedHashSet<ISpecHandler> handlers = new LinkedHashSet<ISpecHandler>();
        Map<String, ISpecHandler> specHandlerMap = SpecHandlerFactory.getHandlers();
        HashSet<Set<String>> allTTVIdentifiers = new HashSet<Set<String>>();
        for (ISpecHandler handler : specHandlerMap.values()) {
            Set<String> ttvIdentifier;
            if (handler.getSpecName().equals("TTV") || (ttvIdentifier = this.getTTVIdentifiers(handler)) == null || ttvIdentifier.size() == 0 || allTTVIdentifiers.contains(ttvIdentifier)) continue;
            allTTVIdentifiers.add(ttvIdentifier);
            handlers.add(handler);
        }
        return handlers;
    }

    private Set<String> getTTVIdentifiers(ISpecHandler handler) {
        HashSet<String> ttvXPaths = new HashSet<String>();
        Map<String, String> identifiers = handler.getIdentifier().getTTVPaths();
        boolean hasPersistenceKey = false;
        for (String ttvPath : identifiers.values()) {
            if (AssetSearchKey.ASSET_ID.toString().equals(ttvPath)) {
                hasPersistenceKey = true;
                break;
            }
            ttvXPaths.add(ttvPath);
        }
        if (hasPersistenceKey) {
            return null;
        }
        return ttvXPaths;
    }

    private void doValidateForPersistence(Asset asset) throws MetadataException {
        int matchingAssetCount;
        Collection<Long> docIDs;
        TTVId assetID = asset.getTTVId();
        Collection<ISpecHandler> handlers = this.getSpecificationHandlersForValidation();
        ExpList specExpList = new ExpList();
        specExpList.setOperator("OR");
        StringBuilder searchAssetSpecKeys = new StringBuilder();
        for (ISpecHandler handler : handlers) {
            ExpList searchFields;
            SearchCriteria assetKey = this.getAssetSpecificationKey(asset, handler);
            if (assetKey == null || assetKey.isEmptyCriteria() || (searchFields = new SearchFieldBuilder().getAssetSearchFields(assetKey, false, false)) == null || searchFields.isEmpty()) continue;
            searchAssetSpecKeys.append(handler.getSpecName() + ".assetKey=" + assetKey.toString() + ":");
            specExpList.addItem((ExpNode)searchFields);
        }
        if (specExpList.isEmpty()) {
            return;
        }
        ExpList assetIdExpList = new ExpList();
        if (assetID.isValidIdentifier()) {
            ExpList copiesExpList = new ExpList();
            ArrayList<String> values = new ArrayList<String>();
            values.add(String.valueOf(asset.getId()));
            PredicateRightValue checkAssetId = new PredicateRightValue("/@assetId", "", FieldType.ASSET, values, LogicalOperator.NOTEQUAL, Boolean.valueOf(false));
            copiesExpList.addItem((ExpNode)new ExpValue((Predicate)checkAssetId));
            PredicateRightValue checkOriginal = new PredicateRightValue("/@originalAssetId", "", FieldType.ASSET, values, LogicalOperator.NOTEQUAL, Boolean.valueOf(false));
            copiesExpList.addItem((ExpNode)new ExpValue((Predicate)checkOriginal));
            Long originalAssetID = asset.getOriginalAssetID();
            if (originalAssetID != null) {
                ExpList origExpList = new ExpList();
                ArrayList<String> oaValues = new ArrayList<String>();
                oaValues.add(String.valueOf(originalAssetID));
                PredicateRightValue checkIfAssetIsOriginal = new PredicateRightValue("/@assetId", "", FieldType.ASSET, values, LogicalOperator.NOTEQUAL, Boolean.valueOf(false));
                origExpList.addItem((ExpNode)new ExpValue((Predicate)checkIfAssetIsOriginal));
                assetIdExpList.setOperator("OR");
                assetIdExpList.addItem((ExpNode)copiesExpList);
                assetIdExpList.addItem((ExpNode)origExpList);
            } else {
                assetIdExpList = copiesExpList;
            }
        }
        AssetSearchService service = this.parentHandler.searchService;
        if (assetIdExpList.isEmpty()) {
            docIDs = service.searchForDocId((ExpNode)specExpList);
        } else {
            ExpList finalExpList = new ExpList();
            finalExpList.addItem((ExpNode)specExpList);
            finalExpList.addItem((ExpNode)assetIdExpList);
            docIDs = service.searchForDocId((ExpNode)finalExpList);
        }
        int n = matchingAssetCount = docIDs != null ? docIDs.size() : 0;
        if (matchingAssetCount > 0) {
            String assetName = "Asset[";
            assetName = assetName + (assetID.isValidIdentifier() ? Long.valueOf(asset.getId()) : asset.getAssetType());
            assetName = assetName + "]";
            String msg = assetName + " has key(s) which is/are not unique in the system. ";
            msg = msg + searchAssetSpecKeys.toString();
            throw new MetadataException(msg);
        }
    }
}

