/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.util.binder;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.File;
import com.tandbergtv.metadatamanager.model.FileType;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.metadatamanager.model.Item;
import com.tandbergtv.metadatamanager.specimpl.ttv.TTVId;
import com.tandbergtv.metadatamanager.util.XmlUtil;
import com.tandbergtv.metadatamanager.util.binder.AssetType;
import com.tandbergtv.metadatamanager.util.binder.ECMFFieldBinder;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ECMFDocToAssetConverter {
    private DocumentBuilder builder;
    private int revisionNumber;
    private int originalRevisionNumber = -1;
    private static final Logger logger = Logger.getLogger(ECMFDocToAssetConverter.class);

    public ECMFDocToAssetConverter() {
        try {
            this.builder = XmlUtil.createDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            this.builder = null;
        }
    }

    public List<Asset> convert(Document doc) {
        ArrayList<Asset> assetList = new ArrayList<Asset>();
        this.revisionNumber = Integer.valueOf(doc.getDocumentElement().getAttribute("revision"));
        String orgDocVersion = doc.getDocumentElement().getAttribute("originalDocumentRevision");
        if (orgDocVersion != null && !orgDocVersion.isEmpty()) {
            this.originalRevisionNumber = Integer.valueOf(orgDocVersion);
        }
        NodeList nodeList = doc.getDocumentElement().getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node packageNode = nodeList.item(i);
            if (packageNode.getNodeType() != 1) continue;
            Element packageElement = (Element)packageNode;
            Group packageAsset = null;
            if (!packageElement.getNodeName().equalsIgnoreCase(Group.GroupType.PACKAGE.name())) continue;
            packageAsset = new Group();
            packageAsset.setType(Group.GroupType.PACKAGE.name());
            this.prepAsset(packageAsset, packageElement, true);
            for (int j = 0; j < packageNode.getChildNodes().getLength(); ++j) {
                Node packageChild = packageNode.getChildNodes().item(j);
                if (!(packageChild instanceof Element)) continue;
                Asset childAsset = this.getAsset((Element)packageChild);
                if (childAsset != null) {
                    packageAsset.addChild(childAsset);
                    continue;
                }
                logger.warn((Object)("Could not create asset for child: " + (Element)packageChild));
            }
            this.setAllDescFields(packageAsset);
            Asset.setPaths(packageAsset, null);
            assetList.add(packageAsset);
        }
        return assetList;
    }

    private void setAllDescFields(Asset packageAsset) {
        ArrayList<Field> allFields = new ArrayList<Field>();
        List<Asset> allChildAssets = packageAsset.getAllAssets(true);
        for (Asset a : allChildAssets) {
            allFields.addAll(a.getFields());
        }
        packageAsset.setAllDescendantAssetFields(allFields);
    }

    private Asset prepAsset(Asset asset, Element assetElement, boolean setOriginalRevisionNumber) {
        long id;
        Element upFields;
        StringBuilder assetLineage = new StringBuilder();
        this.getAssetLineage(assetElement, assetLineage);
        Document fieldDoc = this.getFieldsDoc(assetElement);
        List<Field> parsableFields = new ECMFFieldBinder().extractXPaths(fieldDoc);
        for (Field f : parsableFields) {
            f.setParentAsset(asset);
        }
        asset.setFields(parsableFields);
        if (this.getNamedChildren(assetElement, "UnparsableFields").size() == 1 && (upFields = this.getNamedChildren(assetElement, "UnparsableFields").get(0)) != null) {
            List<Field> up = new ECMFFieldBinder().getUnParsableFields(upFields);
            for (Field f : up) {
                asset.addField(f);
                f.setParentAsset(asset);
            }
        }
        id = (id = Long.valueOf(assetElement.getAttribute("assetId")).longValue()) == -1L ? 0L : id;
        asset.setTTVId(new TTVId(id));
        asset.setLatestRevisionNumber(this.revisionNumber);
        String orgAssetId = assetElement.getAttribute("originalAssetId");
        if (orgAssetId != null && !orgAssetId.isEmpty()) {
            asset.setOriginalAssetID(Long.valueOf(orgAssetId));
        }
        if (setOriginalRevisionNumber && this.originalRevisionNumber != -1) {
            asset.setOriginalRevisionNumber(this.originalRevisionNumber);
        }
        return asset;
    }

    private void getAssetLineage(Element assetElement, StringBuilder assetLineage) {
        if (assetElement == null) {
            return;
        }
        if (assetElement.getParentNode() != null && !assetElement.getParentNode().getNodeName().equalsIgnoreCase("ECMFSpec")) {
            this.getAssetLineage((Element)assetElement.getParentNode(), assetLineage);
        }
        if (assetLineage.length() > 0) {
            assetLineage.append("/");
        }
        assetLineage.append(assetElement.getNodeName());
    }

    private Document getFieldsDoc(Element assetElement) {
        Element fields = this.getNamedChildren(assetElement, "Fields").get(0);
        Document fieldDoc = this.builder.newDocument();
        Element fieldsCopy = (Element)fieldDoc.importNode(fields, true);
        fieldDoc.appendChild(fieldsCopy);
        return fieldDoc;
    }

    private Asset getAsset(Element assetElement) {
        if (assetElement.getNodeName().equalsIgnoreCase(Item.ItemType.FILE.name())) {
            File fileAsset = new File();
            this.prepFile(fileAsset, assetElement);
            return fileAsset;
        }
        if (assetElement.getNodeName().equalsIgnoreCase(Item.ItemType.TITLE.name())) {
            Item titleAsset = new Item();
            titleAsset.setType(Item.ItemType.TITLE);
            this.prepAsset(titleAsset, assetElement, true);
            return titleAsset;
        }
        if (assetElement.getNodeName().equalsIgnoreCase(Group.GroupType.MOVIE.name()) || assetElement.getNodeName().equalsIgnoreCase(Group.GroupType.PREVIEW.name())) {
            Group groupAsset = new Group();
            groupAsset.setType(assetElement.getNodeName().toUpperCase());
            this.prepAsset(groupAsset, assetElement, true);
            List<Element> fileElements = this.getNamedChildren(assetElement, AssetType.FILE.toString());
            for (int i = 0; i < fileElements.size(); ++i) {
                File fileAsset = new File();
                this.prepFile(fileAsset, fileElements.get(i));
                groupAsset.addChild(fileAsset);
            }
            this.prepLogicalClip(groupAsset, assetElement);
            return groupAsset;
        }
        if (assetElement.getNodeName().equalsIgnoreCase(Item.ItemType.POSTER.name()) || assetElement.getNodeName().equalsIgnoreCase(Item.ItemType.BOXCOVER.name()) || assetElement.getNodeName().equalsIgnoreCase(Item.ItemType.TRICK.name()) || assetElement.getNodeName().equalsIgnoreCase(Item.ItemType.BARKER.name()) || assetElement.getNodeName().equalsIgnoreCase(Item.ItemType.ENCRYPTED.name()) || assetElement.getNodeName().equalsIgnoreCase(Item.ItemType.MOVIESEGMENTGROUP.name()) || assetElement.getNodeName().equalsIgnoreCase(Item.ItemType.PREVIEWSEGMENTGROUP.name()) || assetElement.getNodeName().equalsIgnoreCase(Item.ItemType.DISPLAY.name()) || assetElement.getNodeName().equalsIgnoreCase(Item.ItemType.GAME.name())) {
            Item itemAsset = new Item();
            itemAsset.setType(assetElement.getNodeName().toUpperCase());
            this.prepAsset(itemAsset, assetElement, true);
            List<Element> fileElements = this.getNamedChildren(assetElement, AssetType.FILE.toString());
            for (int i = 0; i < fileElements.size(); ++i) {
                File fileAsset = new File();
                this.prepFile(fileAsset, fileElements.get(i));
                itemAsset.addChild(fileAsset);
            }
            return itemAsset;
        }
        return null;
    }

    private void prepLogicalClip(Group groupAsset, Element groupAssetElement) {
        List<Element> lcElements = this.getNamedChildren(groupAssetElement, AssetType.LOGICALCLIP.toString());
        for (int i = 0; i < lcElements.size(); ++i) {
            Item lcAsset = new Item();
            lcAsset.setType(Item.ItemType.LOGICALCLIP);
            List<Element> lcFileElements = this.getNamedChildren(lcElements.get(i), AssetType.FILE.toString());
            if (lcFileElements != null && lcFileElements.size() > 0) {
                for (Element f : lcFileElements) {
                    File lcFileAsset = new File();
                    this.prepFile(lcFileAsset, f);
                    lcAsset.addChild(lcFileAsset);
                }
            }
            this.prepAsset(lcAsset, lcElements.get(i), false);
            groupAsset.addChild(lcAsset);
        }
    }

    private void prepFile(File fileAsset, Element fileElement) {
        NodeList fieldNodeList = fileElement.getElementsByTagName("Fields");
        if (fieldNodeList.getLength() == 1) {
            String fileType = this.getFileType(fieldNodeList.item(0));
            fileAsset.setFileType(FileType.valueOf(fileType));
        }
        this.prepAsset(fileAsset, fileElement, false);
        List<Element> fileElements = this.getNamedChildren(fileElement, AssetType.FILE.toString());
        for (Element f : fileElements) {
            File childFileAsset = new File();
            this.prepFile(childFileAsset, f);
            fileAsset.addChild(childFileAsset);
        }
    }

    private String getFileType(Node item) {
        if (item.getNodeType() != 1) {
            return "";
        }
        NodeList matchingFields = ((Element)item).getElementsByTagName("Text");
        if (matchingFields.getLength() == 1) {
            return matchingFields.item(0).getTextContent();
        }
        return null;
    }

    private List<Element> getNamedChildren(Element element, String name) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node elementChild = children.item(i);
            if (elementChild == null || !elementChild.getNodeName().equals(name)) continue;
            result.add((Element)elementChild);
        }
        return result;
    }
}

