/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.util.binder;

import com.sun.org.apache.xpath.internal.XPathAPI;
import com.tandbergtv.metadatamanager.model.CustomField;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.util.ResourceResolver;
import com.tandbergtv.metadatamanager.util.XmlUtil;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ECMFFieldBinder {
    public static final String _CUSTOMFIELD_NAME = "CustomField[@name=";
    private DocumentBuilder builder;
    private Transformer transformer;
    public static final String XSLT = "com/tandbergtv/metadatamanager/util/binder/xpath.xsl";
    private static final String CUSTOMFIELD = "CustomField";
    private static final String CUSTOMFIELDS = "CustomFields";

    public ECMFFieldBinder() {
        try {
            this.builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            this.builder = null;
        }
        InputStream is = ECMFFieldBinder.class.getClassLoader().getResourceAsStream(XSLT);
        try {
            TransformerFactory tf = XmlUtil.createTransformerFactory(this.getClass().getClassLoader());
            tf.setURIResolver(new ResourceResolver());
            this.transformer = tf.newTransformer(new StreamSource(is));
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
    }

    public Document buildXml(List<Field> fields) {
        Document doc = this.builder.newDocument();
        Element root = doc.createElement("Fields");
        root.setAttribute("xmlns", "http://www.w3.org/2000/xmlns/");
        root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:noNamespaceSchemaLocation", "ECMFSpec.xsd");
        doc.appendChild(root);
        for (Field field : fields) {
            String xpath = field.getTtvXPath();
            String attribute = "";
            if (xpath.indexOf("/@") > -1) {
                attribute = xpath.replaceFirst(".*/@", "");
                xpath = xpath.replaceFirst("/@.*", "");
            }
            String[] xpathSplit = xpath.split("/");
            List<Integer> indices = field.getIndices();
            String value = field.getValue();
            String xpathPart = "";
            Node node = null;
            for (int i = 0; i < indices.size(); ++i) {
                String xpathChild = xpathSplit[i + 1];
                int index = indices.get(i);
                try {
                    if (xpathChild.contains(_CUSTOMFIELD_NAME)) {
                        node = XPathAPI.selectSingleNode(root, xpathPart, root);
                        node = node.appendChild(doc.createElement(CUSTOMFIELD));
                        String cfName = this.extractCustomFieldName(xpathChild);
                        ((Element)node).setAttribute("name", cfName);
                    } else {
                        NodeList nl = XPathAPI.selectNodeList(root, xpathPart + "/" + xpathChild, root);
                        int numNodes = nl.getLength();
                        if (numNodes >= index) {
                            node = nl.item(index - 1);
                        } else {
                            for (int j = 0; j < index - numNodes; ++j) {
                                Node parent = XPathAPI.selectSingleNode(root, xpathPart, root);
                                node = parent.appendChild(doc.createElement(xpathChild));
                            }
                        }
                    }
                }
                catch (TransformerException e) {
                    e.printStackTrace();
                }
                xpathPart = xpathPart + "/" + xpathChild + "[" + index + "]";
            }
            if (!attribute.equals("")) {
                ((Element)node).setAttribute(attribute, value);
                continue;
            }
            ((Element)node).setTextContent(value);
        }
        return doc;
    }

    public List<Field> extractXPaths(Document doc) {
        ArrayList<Field> fields = new ArrayList<Field>();
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        try {
            this.transformer.transform(new DOMSource(doc), result);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
        String[] xpaths = sw.toString().split("#ttv#ttv#ttv#ttv#\n");
        for (String xpath : xpaths = this.handleCustomFieldXpaths(xpaths)) {
            String[] indexSplit;
            if (xpath.matches("/Fields\\{[0-9]*\\}/@.*")) continue;
            Field field = new Field();
            int equalSign = xpath.indexOf("==");
            String indexedXPath = xpath.substring(0, equalSign);
            field.setTtvXPath(indexedXPath.replaceAll("\\{[0-9]*\\}", ""));
            field.setValue(xpath.substring(equalSign + 2));
            ArrayList<Integer> indices = new ArrayList<Integer>();
            for (String indexStr : indexSplit = indexedXPath.split("\\{")) {
                int bracket = indexStr.indexOf("}");
                if (bracket <= -1) continue;
                indices.add(Integer.parseInt(indexStr.substring(0, bracket)));
            }
            field.setIndices(indices);
            fields.add(field);
        }
        return fields;
    }

    public List<Field> getUnParsableFields(Element upFields) {
        ArrayList<Field> fields = new ArrayList<Field>();
        if (upFields == null) {
            return fields;
        }
        NodeList upFieldList = upFields.getElementsByTagName("UnparsableField");
        for (int i = 0; i < upFieldList.getLength(); ++i) {
            String value;
            String indicesStr;
            Element upf = (Element)upFieldList.item(i);
            Field f = new Field();
            f.setParsable(false);
            String xpath = upf.getAttribute("xpath");
            if (xpath != null) {
                f.setTtvXPath(xpath);
            }
            if ((indicesStr = upf.getAttribute("indices")) != null) {
                ArrayList<Integer> indices = new ArrayList<Integer>();
                String[] ind = indicesStr.split(",");
                for (int j = 0; j < ind.length; ++j) {
                    indices.add(Integer.valueOf(ind[j].trim()));
                }
                f.setIndices(indices);
            }
            if ((value = upf.getAttribute("value")) != null) {
                f.setValue(value);
            }
            fields.add(f);
        }
        return fields;
    }

    private String[] handleCustomFieldXpaths(String[] xpaths) {
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<String> cfList = new ArrayList<String>();
        for (String xpath : xpaths) {
            if (xpath.contains(CUSTOMFIELDS)) {
                cfList.add(xpath);
                continue;
            }
            list.add(xpath);
        }
        Collection<CustomField> customFields = this.getCustomFields(cfList);
        for (CustomField customField : customFields) {
            list.add(customField.constructTTVString());
        }
        return list.toArray(new String[0]);
    }

    public Collection<CustomField> getCustomFields(List<String> customFieldsXPaths) {
        HashMap<String, CustomField> customFields = new HashMap<String, CustomField>();
        for (String xpath : customFieldsXPaths) {
            CustomField customField;
            if (!xpath.contains("CustomField{")) continue;
            String[] xpathSplit = xpath.split("==");
            if (xpathSplit[0].endsWith("/@value")) {
                customField = this.getCustomField(customFields, xpathSplit[0], "@value");
                String customFieldValue = xpathSplit.length != 2 ? "" : xpathSplit[1];
                customField.setValue(customFieldValue);
                continue;
            }
            if (!xpathSplit[0].endsWith("/@name")) continue;
            customField = this.getCustomField(customFields, xpathSplit[0], "@name");
            customField.setName(xpathSplit[1]);
        }
        return customFields.values();
    }

    private CustomField getCustomField(Map<String, CustomField> customFields, String xPath, String attributeKey) {
        String xPathWithoutAttribute = xPath.substring(0, xPath.lastIndexOf("/" + attributeKey));
        CustomField customField = customFields.get(xPathWithoutAttribute);
        if (customField == null) {
            customField = new CustomField(xPathWithoutAttribute);
            customFields.put(xPathWithoutAttribute, customField);
        }
        return customField;
    }

    private String extractCustomFieldName(String xpathChild) {
        String cfName = "";
        String[] o = xpathChild.split("=");
        if (o.length == 2) {
            cfName = o[1];
            cfName = cfName.replaceAll("\\]", "");
        }
        return cfName;
    }

    public Document buildUnparsableFields(List<Field> upFields) {
        if (upFields.size() == 0) {
            return null;
        }
        Document doc = this.builder.newDocument();
        Element root = doc.createElement("UnparsableFields");
        root.setAttribute("xmlns", "http://www.w3.org/2000/xmlns/");
        root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:noNamespaceSchemaLocation", "ECMFSpec.xsd");
        doc.appendChild(root);
        for (Field f : upFields) {
            Element upFieldElement = doc.createElement("UnparsableField");
            upFieldElement.setAttribute("xpath", f.getTtvXPath());
            upFieldElement.setAttribute("value", f.getValue());
            StringBuilder sbIndices = new StringBuilder();
            for (Integer ind : f.getIndices()) {
                if (sbIndices.length() > 0) {
                    sbIndices.append(",");
                }
                sbIndices.append(ind);
            }
            upFieldElement.setAttribute("indices", sbIndices.toString());
            root.appendChild(upFieldElement);
        }
        return doc;
    }
}

