/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.http;

import java.util.Collection;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.vfs.Capability;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.provider.AbstractFileSystem;
import org.apache.commons.vfs.provider.GenericFileName;
import org.apache.commons.vfs.provider.http.HttpFileObject;

public class HttpFileSystem
extends AbstractFileSystem
implements FileSystem {
    private HttpClient client;

    public HttpFileSystem(GenericFileName rootName) {
        super(rootName, null);
    }

    protected void addCapabilities(Collection caps) {
        caps.add(Capability.READ_CONTENT);
        caps.add(Capability.URI);
        caps.add(Capability.GET_LAST_MODIFIED);
        caps.add(Capability.ATTRIBUTES);
    }

    protected HttpClient getClient() throws FileSystemException {
        if (this.client == null) {
            GenericFileName rootName = (GenericFileName)this.getRootName();
            this.client = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
            HostConfiguration config = new HostConfiguration();
            config.setHost(rootName.getHostName(), rootName.getPort());
            this.client.setHostConfiguration(config);
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials(rootName.getUserName(), rootName.getPassword());
            this.client.getState().setCredentials(null, rootName.getHostName(), (Credentials)creds);
        }
        return this.client;
    }

    protected FileObject createFile(FileName name) throws Exception {
        return new HttpFileObject(name, this);
    }
}

