/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.local;

import java.io.File;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.provider.AbstractOriginatingFileProvider;
import org.apache.commons.vfs.provider.LocalFileProvider;
import org.apache.commons.vfs.provider.local.GenericFileNameParser;
import org.apache.commons.vfs.provider.local.LocalFileName;
import org.apache.commons.vfs.provider.local.LocalFileNameParser;
import org.apache.commons.vfs.provider.local.LocalFileSystem;
import org.apache.commons.vfs.provider.local.WindowsFileNameParser;
import org.apache.commons.vfs.util.Os;

public final class DefaultLocalFileProvider
extends AbstractOriginatingFileProvider
implements LocalFileProvider {
    private final LocalFileNameParser parser = Os.isFamily(Os.OS_FAMILY_WINDOWS) ? new WindowsFileNameParser() : new GenericFileNameParser();

    public boolean isAbsoluteLocalName(String name) {
        return this.parser.isAbsoluteName(name);
    }

    public FileObject findLocalFile(String name) throws FileSystemException {
        return this.findFile(null, "file:" + name);
    }

    public FileObject findLocalFile(File file) throws FileSystemException {
        return this.findFile(null, "file:" + file.getAbsolutePath());
    }

    protected FileName parseUri(String uri) throws FileSystemException {
        return LocalFileName.parseUri(uri, this.parser);
    }

    protected FileSystem doCreateFileSystem(FileName name) throws FileSystemException {
        LocalFileName rootName = (LocalFileName)name;
        return new LocalFileSystem((FileName)rootName, rootName.getRootFile());
    }
}

