/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.vfs.Capability;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.provider.AbstractFileSystem;
import org.apache.commons.vfs.provider.GenericFileName;
import org.apache.commons.vfs.provider.sftp.SftpFileObject;

class SftpFileSystem
extends AbstractFileSystem
implements FileSystem {
    private Session session;
    private final JSch jSch;
    private ChannelSftp idleChannel;

    public SftpFileSystem(GenericFileName rootName, JSch jSch) {
        super(rootName, null);
        this.jSch = jSch;
    }

    public void close() {
        if (this.session != null) {
            this.session.disconnect();
        }
        super.close();
    }

    protected ChannelSftp getChannel() throws IOException {
        try {
            ChannelSftp channel;
            if (this.session == null) {
                GenericFileName rootName = (GenericFileName)this.getRootName();
                this.session = this.jSch.getSession(rootName.getUserName(), rootName.getHostName(), rootName.getPort());
                this.session.setPassword(rootName.getPassword());
                this.session.connect();
            }
            if (this.idleChannel != null) {
                channel = this.idleChannel;
                this.idleChannel = null;
            } else {
                channel = (ChannelSftp)this.session.openChannel("sftp");
                channel.connect();
            }
            return channel;
        }
        catch (JSchException e) {
            throw new FileSystemException("vfs.provider.sftp/connect.error", this.getRootName(), (Throwable)e);
        }
    }

    protected void putChannel(ChannelSftp channel) {
        if (this.idleChannel == null) {
            this.idleChannel = channel;
        } else {
            channel.disconnect();
        }
    }

    protected void addCapabilities(Collection caps) {
        caps.add(Capability.CREATE);
        caps.add(Capability.DELETE);
        caps.add(Capability.GET_TYPE);
        caps.add(Capability.LIST_CHILDREN);
        caps.add(Capability.READ_CONTENT);
        caps.add(Capability.URI);
        caps.add(Capability.WRITE_CONTENT);
    }

    protected FileObject createFile(FileName name) throws FileSystemException {
        return new SftpFileObject(name, this);
    }
}

