/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.smb;

import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.provider.GenericFileName;
import org.apache.commons.vfs.provider.UriParser;

public class SmbFileName
extends GenericFileName {
    private static final int DEFAULT_PORT = 139;
    private final String share;

    private SmbFileName(String scheme, String hostName, int port, String userName, String password, String share, String path) {
        super(scheme, hostName, port, 139, userName, password, path);
        this.share = share;
    }

    public static SmbFileName parseUri(String uri) throws FileSystemException {
        StringBuffer name = new StringBuffer();
        GenericFileName.Authority auth = GenericFileName.extractToPath(uri, name);
        UriParser.decode(name, 0, name.length());
        UriParser.fixSeparators(name);
        String share = UriParser.extractFirstElement(name);
        if (share == null || share.length() == 0) {
            throw new FileSystemException("vfs.provider.smb/missing-share-name.error", uri);
        }
        UriParser.normalisePath(name);
        String path = name.toString();
        return new SmbFileName(auth.scheme, auth.hostName, auth.port, auth.userName, auth.password, share, path);
    }

    public String getShare() {
        return this.share;
    }

    protected void appendRootUri(StringBuffer buffer) {
        super.appendRootUri(buffer);
        buffer.append('/');
        buffer.append(this.share);
    }

    protected FileName createName(String path) {
        return new SmbFileName(this.getScheme(), this.getHostName(), this.getPort(), this.getUserName(), this.getPassword(), this.share, path);
    }
}

