/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.zip;

import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.provider.LayeredFileName;
import org.apache.commons.vfs.provider.UriParser;

public class ZipFileName
extends LayeredFileName {
    private static final char[] ZIP_URL_RESERVED_CHARS = new char[]{'!'};

    public ZipFileName(String scheme, String zipFileUri, String path) {
        super(scheme, zipFileUri, path);
    }

    protected void appendRootUri(StringBuffer buffer) {
        buffer.append(this.getScheme());
        buffer.append(":");
        UriParser.appendEncoded(buffer, this.getOuterUri(), ZIP_URL_RESERVED_CHARS);
        buffer.append("!");
    }

    protected FileName createName(String path) {
        return new ZipFileName(this.getScheme(), this.getOuterUri(), path);
    }

    public static ZipFileName parseUri(String uri) throws FileSystemException {
        StringBuffer name = new StringBuffer();
        String scheme = UriParser.extractScheme(uri, name);
        String zipUri = ZipFileName.extractZipName(name);
        UriParser.decode(name, 0, name.length());
        UriParser.normalisePath(name);
        String path = name.toString();
        return new ZipFileName(scheme, zipUri, path);
    }

    private static String extractZipName(StringBuffer uri) throws FileSystemException {
        int maxlen = uri.length();
        int pos = 0;
        while (pos < maxlen && uri.charAt(pos) != '!') {
            ++pos;
        }
        String prefix = uri.substring(0, pos);
        if (pos < maxlen) {
            uri.delete(0, pos + 1);
        } else {
            uri.setLength(0);
        }
        return UriParser.decode(prefix);
    }
}

