/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.pool.OracleConnectionCache;
import oracle.jdbc.pool.OracleConnectionCacheTimeOutThread;
import oracle.jdbc.pool.OracleConnectionEventListener;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.pool.OraclePooledConnection;

public class OracleConnectionCacheImpl
extends OracleDataSource
implements OracleConnectionCache,
Serializable,
Referenceable {
    protected ConnectionPoolDataSource m_cpds = null;
    protected static int _DEFAULT_MIN_LIMIT = 0;
    protected static int _DEFAULT_MAX_LIMIT = 10;
    protected int _MIN_LIMIT = _DEFAULT_MIN_LIMIT;
    protected int _MAX_LIMIT = _DEFAULT_MAX_LIMIT;
    protected static final int DEFAULT_CACHE_TIMEOUT = -1;
    protected static final int DEFAULT_THREAD_INTERVAL = 900;
    protected long m_cacheTTLTimeOut = -1L;
    protected long m_cacheInactivityTimeOut = -1L;
    protected long m_cacheFixedWaitTimeOut = -1L;
    protected long m_threadInterval = 900L;
    Stack m_cache = new Stack();
    Hashtable m_activeCache = new Hashtable();
    protected int m_cacheSize = 0;
    protected int m_activeSize = 0;
    protected int m_cacheScheme = 1;
    public static final long DEFAULT_FIXED_WAIT_IDLE_TIME = 30L;
    protected long m_fixedWaitIdleTime = -1L;
    public static final int DYNAMIC_SCHEME = 1;
    public static final int FIXED_WAIT_SCHEME = 2;
    public static final int FIXED_RETURN_NULL_SCHEME = 3;
    protected OracleConnectionEventListener m_ocel = null;
    protected int m_stmtCacheSize = 0;
    protected boolean m_stmtClearMetaData = false;
    protected OracleConnectionCacheTimeOutThread m_timeOutThread = null;
    SQLWarning m_warning = null;

    public OracleConnectionCacheImpl() throws SQLException {
        this(null);
    }

    public OracleConnectionCacheImpl(ConnectionPoolDataSource connectionPoolDataSource) throws SQLException {
        this.m_cpds = connectionPoolDataSource;
        this.m_ocel = new OracleConnectionEventListener(this);
        this.m_dataSourceName = "OracleConnectionCacheImpl";
    }

    private void checkAndStartTimeOutThread() throws SQLException {
        try {
            if (!this.m_timeOutThread.isAlive()) {
                this.m_timeOutThread.start();
            }
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
    }

    private void checkCredentials(String string, String string2) throws SQLException {
        String string3 = null;
        String string4 = null;
        if (this.m_cpds != null) {
            string3 = ((OracleConnectionPoolDataSource)this.m_cpds).getUser();
            string4 = ((OracleConnectionPoolDataSource)this.m_cpds).getPassword();
        }
        if (string != null && !string.equals(string3) || string2 != null && !string2.equals(string4)) {
            DBError.throwSqlException(79);
        }
    }

    public void clearWarnings() throws SQLException {
        this.m_warning = null;
    }

    public void close() throws SQLException {
        Enumeration enumeration = this.m_activeCache.keys();
        while (enumeration.hasMoreElements()) {
            PooledConnection pooledConnection = (PooledConnection)enumeration.nextElement();
            PooledConnection pooledConnection2 = (PooledConnection)this.m_activeCache.get(pooledConnection);
            this.reusePooledConnection(pooledConnection2);
        }
        while (!this.m_cache.empty()) {
            this.closeSingleConnection((PooledConnection)this.m_cache.peek());
        }
        this.m_cache = null;
        this.m_activeCache = null;
        this.m_ocel = null;
        this.m_cpds = null;
        this.m_timeOutThread = null;
        this.clearWarnings();
    }

    public void closePooledConnection(PooledConnection pooledConnection) throws SQLException {
        this.detachSingleConnection(pooledConnection);
        this.closeSingleConnection(pooledConnection);
    }

    public synchronized void closeSingleConnection(PooledConnection pooledConnection) throws SQLException {
        --this.m_cacheSize;
        pooledConnection.close();
        this.removeConnectionFromCache(pooledConnection);
    }

    private void detachSingleConnection(PooledConnection pooledConnection) {
        --this.m_activeSize;
        pooledConnection.removeConnectionEventListener(this.m_ocel);
        this.m_activeCache.remove(pooledConnection);
    }

    public synchronized int getActiveSize() {
        return this.m_activeSize;
    }

    public long getCacheFixedWaitIdleTime() throws SQLException {
        return this.m_fixedWaitIdleTime == -1L ? 30L : this.m_fixedWaitIdleTime;
    }

    public long getCacheFixedWaitTimeout() throws SQLException {
        return this.m_cacheFixedWaitTimeOut;
    }

    public long getCacheInactivityTimeout() throws SQLException {
        return this.m_cacheInactivityTimeOut;
    }

    public synchronized int getCacheScheme() {
        return this.m_cacheScheme;
    }

    public synchronized int getCacheSize() {
        return this.m_cacheSize;
    }

    public long getCacheTimeToLiveTimeout() throws SQLException {
        return this.m_cacheTTLTimeOut;
    }

    public synchronized Connection getConnection() throws SQLException {
        return this.getConnection(this.m_user, this.m_password);
    }

    public synchronized Connection getConnection(String string, String string2) throws SQLException {
        PooledConnection pooledConnection = this.getPooledConnection(string, string2);
        if (pooledConnection != null) {
            Connection connection = pooledConnection.getConnection();
            if (connection != null) {
                ((OracleConnection)connection).setStartTime(System.currentTimeMillis());
            }
            return connection;
        }
        return null;
    }

    public synchronized int getMaxLimit() {
        return this._MAX_LIMIT;
    }

    public synchronized int getMinLimit() {
        return this._MIN_LIMIT;
    }

    PooledConnection getNewPoolOrXAConnection() throws SQLException {
        if (this.m_cpds == null) {
            if (this.m_user == null || this.m_password == null) {
                DBError.throwSqlException(79);
            }
            this.m_cpds = new OracleConnectionPoolDataSource();
            this.copy((OracleDataSource)((Object)this.m_cpds));
        }
        PooledConnection pooledConnection = this.m_cpds.getPooledConnection();
        ((OraclePooledConnection)pooledConnection).setStmtCacheSize(this.m_stmtCacheSize, this.m_stmtClearMetaData);
        return pooledConnection;
    }

    protected PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        PooledConnection pooledConnection = null;
        if (!this.m_cache.empty()) {
            this.checkCredentials(string, string2);
            pooledConnection = this.removeConnectionFromCache();
        } else if (this.m_cacheSize < this._MAX_LIMIT || this.m_cacheScheme == 1) {
            String string3 = null;
            String string4 = null;
            if (this.m_cpds != null) {
                string3 = ((OracleConnectionPoolDataSource)this.m_cpds).getUser();
                string4 = ((OracleConnectionPoolDataSource)this.m_cpds).getPassword();
            }
            if (this.m_cacheSize > 0 && string != null && !string.equalsIgnoreCase(string3)) {
                DBError.throwSqlException(79);
            } else if (string != null) {
                this.m_user = string;
                if (this.m_cpds != null) {
                    ((OracleConnectionPoolDataSource)this.m_cpds).setUser(string);
                }
            }
            if (this.m_cacheSize > 0 && string2 != null && !string2.equalsIgnoreCase(string4)) {
                DBError.throwSqlException(79);
            } else if (string2 != null) {
                this.m_password = string2;
                if (this.m_cpds != null) {
                    ((OracleConnectionPoolDataSource)this.m_cpds).setPassword(string2);
                }
            }
            pooledConnection = this.getNewPoolOrXAConnection();
            ++this.m_cacheSize;
        } else {
            if (this.m_cacheScheme == 3) {
                return null;
            }
            this.checkCredentials(string, string2);
            long l = System.currentTimeMillis();
            while (this.m_cache.empty()) {
                if (this.m_cacheFixedWaitTimeOut > 0L && System.currentTimeMillis() - l > this.m_cacheFixedWaitTimeOut * 1000L) {
                    DBError.throwSqlException(126);
                }
                Stack stack = this.m_cache;
                synchronized (stack) {
                    try {
                        this.m_cache.wait((this.m_fixedWaitIdleTime == -1L ? 30L : this.m_fixedWaitIdleTime) * 1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            pooledConnection = this.removeConnectionFromCache();
        }
        if (pooledConnection != null) {
            pooledConnection.addConnectionEventListener(this.m_ocel);
            this.m_activeCache.put(pooledConnection, pooledConnection);
            ++this.m_activeSize;
            ((OraclePooledConnection)pooledConnection).setStmtCacheSize(this.m_stmtCacheSize, this.m_stmtClearMetaData);
        }
        return pooledConnection;
    }

    public synchronized Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), "oracle.jdbc.pool.OracleDataSourceFactory", null);
        super.addRefProperties(reference);
        if (this._MIN_LIMIT != _DEFAULT_MIN_LIMIT) {
            reference.add(new StringRefAddr("minLimit", Integer.toString(this._MIN_LIMIT)));
        }
        if (this._MAX_LIMIT != _DEFAULT_MAX_LIMIT) {
            reference.add(new StringRefAddr("maxLimit", Integer.toString(this._MAX_LIMIT)));
        }
        if (this.m_cacheScheme != 1) {
            reference.add(new StringRefAddr("cacheScheme", Integer.toString(this.m_cacheScheme)));
        }
        return reference;
    }

    public synchronized int getStmtCacheSize() {
        return this.m_stmtCacheSize;
    }

    public long getThreadWakeUpInterval() throws SQLException {
        return this.m_threadInterval;
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.m_warning;
    }

    synchronized boolean isStmtCacheEnabled() {
        return this.m_stmtCacheSize > 0;
    }

    private void putConnectionToCache(PooledConnection pooledConnection) throws SQLException {
        ((OraclePooledConnection)pooledConnection).setLastAccessedTime(System.currentTimeMillis());
        this.m_cache.push(pooledConnection);
        Stack stack = this.m_cache;
        synchronized (stack) {
            this.m_cache.notify();
        }
    }

    private PooledConnection removeConnectionFromCache() throws SQLException {
        return (PooledConnection)this.m_cache.pop();
    }

    private void removeConnectionFromCache(PooledConnection pooledConnection) throws SQLException {
        this.m_cache.removeElement(pooledConnection);
    }

    public void reusePooledConnection(PooledConnection pooledConnection) throws SQLException {
        this.detachSingleConnection(pooledConnection);
        if (this.m_cacheSize > this._MAX_LIMIT && this.m_cacheScheme == 1) {
            this.closeSingleConnection(pooledConnection);
        } else {
            this.putConnectionToCache(pooledConnection);
        }
    }

    public synchronized void setCacheFixedWaitIdleTime(long l) throws SQLException {
        if (this.m_cacheScheme == 2) {
            if (l <= 0L) {
                DBError.addSqlWarning(this.m_warning, 68);
                this.m_fixedWaitIdleTime = 30L;
            } else {
                this.m_fixedWaitIdleTime = l;
            }
        } else {
            DBError.addSqlWarning(this.m_warning, new SQLWarning("Caching scheme is not FIXED_WAIT_SCHEME"));
        }
    }

    public synchronized void setCacheFixedWaitTimeout(long l) throws SQLException {
        if (l <= 0L) {
            this.m_cacheFixedWaitTimeOut = -1L;
            this.m_warning = DBError.addSqlWarning(this.m_warning, 127);
        } else {
            this.m_cacheFixedWaitTimeOut = l;
        }
    }

    public synchronized void setCacheInactivityTimeout(long l) throws SQLException {
        if (this.m_timeOutThread == null) {
            this.m_timeOutThread = new OracleConnectionCacheTimeOutThread(this);
        }
        if (l <= 0L) {
            this.m_cacheInactivityTimeOut = -1L;
            this.m_warning = DBError.addSqlWarning(this.m_warning, 124);
        } else {
            this.m_cacheInactivityTimeOut = l;
            this.checkAndStartTimeOutThread();
        }
    }

    public synchronized void setCacheScheme(int n) throws SQLException {
        if (n == 1 || n == 3 || n == 2) {
            this.m_cacheScheme = n;
            return;
        }
        DBError.throwSqlException(68);
    }

    public synchronized void setCacheScheme(String string) throws SQLException {
        if (string.equalsIgnoreCase("DYNAMIC_SCHEME")) {
            this.m_cacheScheme = 1;
        } else if (string.equalsIgnoreCase("FIXED_RETURN_NULL_SCHEME")) {
            this.m_cacheScheme = 3;
        } else if (string.equalsIgnoreCase("FIXED_WAIT_SCHEME")) {
            this.m_cacheScheme = 2;
        } else {
            DBError.throwSqlException(68);
        }
    }

    public synchronized void setCacheTimeToLiveTimeout(long l) throws SQLException {
        if (this.m_timeOutThread == null) {
            this.m_timeOutThread = new OracleConnectionCacheTimeOutThread(this);
        }
        if (l <= 0L) {
            this.m_cacheTTLTimeOut = -1L;
            this.m_warning = DBError.addSqlWarning(this.m_warning, 111);
        } else {
            this.m_cacheTTLTimeOut = l;
            this.checkAndStartTimeOutThread();
        }
    }

    public synchronized void setConnectionPoolDataSource(ConnectionPoolDataSource connectionPoolDataSource) throws SQLException {
        if (this.m_cacheSize > 0) {
            DBError.throwSqlException(78);
        }
        this.m_cpds = connectionPoolDataSource;
    }

    public synchronized void setMaxLimit(int n) throws SQLException {
        if (n < 0 || n < this._MIN_LIMIT) {
            DBError.throwSqlException(68);
        }
        this._MAX_LIMIT = n;
        if (this.m_cacheSize > this._MAX_LIMIT && this.m_cacheScheme != 1) {
            int n2 = this._MAX_LIMIT;
            while (n2 < this.m_cacheSize) {
                if (this.m_cache.empty()) {
                    DBError.throwSqlException(78);
                } else {
                    this.removeConnectionFromCache().close();
                }
                ++n2;
            }
            this.m_cacheSize = this._MAX_LIMIT;
        }
    }

    public synchronized void setMinLimit(int n) throws SQLException {
        if (n < 0 || n > this._MAX_LIMIT) {
            DBError.throwSqlException(68);
        }
        this._MIN_LIMIT = n;
        if (this.m_cacheSize < this._MIN_LIMIT) {
            int n2 = this.m_cacheSize;
            while (n2 < this._MIN_LIMIT) {
                PooledConnection pooledConnection = this.getNewPoolOrXAConnection();
                this.putConnectionToCache(pooledConnection);
                ++n2;
            }
            this.m_cacheSize = this._MIN_LIMIT;
        }
    }

    public synchronized void setStmtCacheSize(int n) throws SQLException {
        this.setStmtCacheSize(n, false);
    }

    public synchronized void setStmtCacheSize(int n, boolean bl) throws SQLException {
        if (n < 0) {
            DBError.throwSqlException(68);
        }
        this.m_stmtCacheSize = n;
        this.m_stmtClearMetaData = bl;
    }

    public synchronized void setThreadWakeUpInterval(long l) throws SQLException {
        if (l <= 0L) {
            this.m_threadInterval = 900L;
            this.m_warning = DBError.addSqlWarning(this.m_warning, 112);
        } else {
            this.m_threadInterval = l;
        }
        if (this.m_cacheTTLTimeOut > 0L && this.m_threadInterval > this.m_cacheTTLTimeOut || this.m_cacheInactivityTimeOut > 0L && this.m_threadInterval > this.m_cacheInactivityTimeOut) {
            this.m_warning = DBError.addSqlWarning(this.m_warning, 113);
        }
    }
}

