/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleCloseCallback;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleDriver;

public class OraclePooledConnection
implements PooledConnection {
    private Hashtable m_eventListeners = null;
    private SQLException m_sqlException = null;
    private boolean m_autoCommit = true;
    protected Connection m_logicalHandle = null;
    protected Connection m_physicalConn = null;
    private OracleCloseCallback m_occ = null;
    private Object m_privData = null;
    private long m_lastAccessedTime = 0L;

    public OraclePooledConnection() {
        this((Connection)null);
    }

    public OraclePooledConnection(String string) throws SQLException {
        DriverManager.registerDriver(new OracleDriver());
        Connection connection = DriverManager.getConnection(string);
        this.initialize(connection);
    }

    public OraclePooledConnection(String string, String string2, String string3) throws SQLException {
        DriverManager.registerDriver(new OracleDriver());
        Connection connection = DriverManager.getConnection(string, string2, string3);
        this.initialize(connection);
    }

    public OraclePooledConnection(Connection connection) {
        this.initialize(connection);
    }

    public OraclePooledConnection(Connection connection, boolean bl) {
        this(connection);
        this.m_autoCommit = bl;
    }

    public synchronized void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (this.m_eventListeners == null) {
            this.m_sqlException = new SQLException("Listener Hashtable Null");
        } else {
            this.m_eventListeners.put(connectionEventListener, connectionEventListener);
        }
    }

    private void callListener(int n) {
        if (this.m_eventListeners == null) {
            return;
        }
        Enumeration enumeration = this.m_eventListeners.keys();
        ConnectionEvent connectionEvent = new ConnectionEvent(this, this.m_sqlException);
        while (enumeration.hasMoreElements()) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)enumeration.nextElement();
            ConnectionEventListener connectionEventListener2 = (ConnectionEventListener)this.m_eventListeners.get(connectionEventListener);
            if (n == 1) {
                connectionEventListener2.connectionClosed(connectionEvent);
                continue;
            }
            if (n != 2) continue;
            connectionEventListener2.connectionErrorOccurred(connectionEvent);
        }
    }

    public synchronized void close() throws SQLException {
        if (this.m_occ != null) {
            this.m_occ.beforeClose((OracleConnection)this.m_physicalConn, this.m_privData);
        }
        if (this.m_physicalConn != null) {
            this.m_physicalConn.close();
            this.m_physicalConn = null;
        }
        if (this.m_occ != null) {
            this.m_occ.afterClose(this.m_privData);
        }
        this.m_lastAccessedTime = 0L;
        this.callListener(2);
    }

    public CallableStatement getCallWithKey(String string) throws SQLException {
        if (this.m_physicalConn != null) {
            return ((OracleConnection)this.m_physicalConn).getCallWithKey(string);
        }
        return null;
    }

    public synchronized Connection getConnection() throws SQLException {
        if (this.m_physicalConn == null) {
            this.m_sqlException = new SQLException("Physical Connection doesn't exis");
            this.callListener(2);
            DBError.throwSqlException(8);
            return null;
        }
        try {
            if (this.m_logicalHandle != null) {
                ((OracleConnection)this.m_logicalHandle).setPhysicalStatus(false);
                this.m_logicalHandle.close();
            }
            this.m_logicalHandle = new OracleConnection(this, (OracleConnection)this.m_physicalConn, this.m_autoCommit);
        }
        catch (SQLException sQLException) {
            this.m_sqlException = sQLException;
            this.callListener(2);
            DBError.throwSqlException(8);
            return null;
        }
        return this.m_logicalHandle;
    }

    public boolean getExplicitCachingEnabled() throws SQLException {
        if (this.m_physicalConn != null) {
            return ((OracleConnection)this.m_physicalConn).getExplicitCachingEnabled();
        }
        return false;
    }

    public boolean getImplicitCachingEnabled() throws SQLException {
        if (this.m_physicalConn != null) {
            return ((OracleConnection)this.m_physicalConn).getImplicitCachingEnabled();
        }
        return false;
    }

    public long getLastAccessedTime() throws SQLException {
        return this.m_lastAccessedTime;
    }

    public synchronized Connection getLogicalHandle() throws SQLException {
        return this.m_logicalHandle;
    }

    public int getStatementCacheSize() throws SQLException {
        if (this.m_physicalConn != null) {
            return ((OracleConnection)this.m_physicalConn).getStatementCacheSize();
        }
        return 0;
    }

    public PreparedStatement getStatementWithKey(String string) throws SQLException {
        if (this.m_physicalConn != null) {
            return ((OracleConnection)this.m_physicalConn).getStatementWithKey(string);
        }
        return null;
    }

    public synchronized int getStmtCacheSize() {
        if (this.m_physicalConn != null) {
            return ((OracleConnection)this.m_physicalConn).getStmtCacheSize();
        }
        return 0;
    }

    private void initialize(Connection connection) {
        this.m_physicalConn = connection;
        this.m_eventListeners = new Hashtable(10);
        this.m_occ = null;
        this.m_privData = null;
        this.m_lastAccessedTime = 0L;
    }

    public boolean isStatementCacheInitialized() {
        if (this.m_physicalConn != null) {
            return ((OracleConnection)this.m_physicalConn).isStatementCacheInitialized();
        }
        return false;
    }

    public synchronized void logicalClose() {
        this.callListener(1);
    }

    public void purgeExplicitCache() throws SQLException {
        if (this.m_physicalConn != null) {
            ((OracleConnection)this.m_physicalConn).purgeExplicitCache();
        }
    }

    public void purgeImplicitCache() throws SQLException {
        if (this.m_physicalConn != null) {
            ((OracleConnection)this.m_physicalConn).purgeImplicitCache();
        }
    }

    public synchronized void registerCloseCallback(OracleCloseCallback oracleCloseCallback, Object object) {
        this.m_occ = oracleCloseCallback;
        this.m_privData = object;
    }

    public synchronized void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (this.m_eventListeners == null) {
            this.m_sqlException = new SQLException("Listener Hashtable Null");
        } else {
            this.m_eventListeners.remove(connectionEventListener);
        }
    }

    public void setExplicitCachingEnabled(boolean bl) throws SQLException {
        if (this.m_physicalConn != null) {
            ((OracleConnection)this.m_physicalConn).setExplicitCachingEnabled(bl);
        }
    }

    public void setImplicitCachingEnabled(boolean bl) throws SQLException {
        if (this.m_physicalConn != null) {
            ((OracleConnection)this.m_physicalConn).setImplicitCachingEnabled(bl);
        }
    }

    public synchronized void setLastAccessedTime(long l) throws SQLException {
        this.m_lastAccessedTime = l;
    }

    public void setStatementCacheSize(int n) throws SQLException {
        if (this.m_physicalConn != null) {
            ((OracleConnection)this.m_physicalConn).setStatementCacheSize(n);
        }
    }

    public synchronized void setStmtCacheSize(int n) throws SQLException {
        this.setStmtCacheSize(n, false);
    }

    public synchronized void setStmtCacheSize(int n, boolean bl) throws SQLException {
        if (n < 0) {
            DBError.throwSqlException(68);
        }
        if (this.m_physicalConn != null) {
            ((OracleConnection)this.m_physicalConn).setStmtCacheSize(n, bl);
        }
    }
}

