/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;

public class OracleSerialBlob
implements Blob,
Serializable,
Cloneable {
    private byte[] buffer;
    private long length;

    public OracleSerialBlob(Blob blob) throws SQLException {
        this.length = blob.length();
        this.buffer = new byte[(int)this.length];
        BufferedInputStream bufferedInputStream = new BufferedInputStream(blob.getBinaryStream());
        try {
            int n = 0;
            int n2 = 0;
            do {
                n = bufferedInputStream.read(this.buffer, n2, (int)(this.length - (long)n2));
                n2 += n;
            } while (n > 0);
        }
        catch (IOException iOException) {
            throw new SQLException("SerialBlob: " + iOException.getMessage());
        }
    }

    public InputStream getBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this.buffer);
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        if (l < 0L || (long)n > this.length || l + (long)n > this.length) {
            throw new SQLException("Invalid Arguments");
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.buffer, (int)l, byArray, 0, n);
        return byArray;
    }

    public long length() throws SQLException {
        return this.length;
    }

    public long position(Blob blob, long l) throws SQLException {
        return this.position(blob.getBytes(0L, (int)blob.length()), l);
    }

    /*
     * Unable to fully structure code
     */
    public long position(byte[] var1_1, long var2_2) throws SQLException {
        if (var2_2 < 0L || var2_2 > this.length || var2_2 + (long)var1_1.length > this.length) {
            throw new SQLException("Invalid Arguments");
        }
        var4_3 = (int)(var2_2 - 1L);
        var5_4 = false;
        var6_5 = var1_1.length;
        if (var2_2 >= 0L && var2_2 <= this.length) ** GOTO lbl13
        return -1L;
lbl-1000:
        // 1 sources

        {
            var8_6 = 0;
            var9_7 = var4_3 + 1;
            while (var1_1[var8_6++] == this.buffer[var4_3++]) {
                if ((long)var8_6 != var6_5) continue;
                return var9_7;
            }
lbl13:
            // 2 sources

            ** while ((long)var4_3 < this.length)
        }
lbl14:
        // 1 sources

        return -1L;
    }

    public OutputStream setBinaryStream(long l) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public int setBytes(long l, byte[] byArray) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return -1;
    }

    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return -1;
    }

    public void truncate(long l) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }
}

