/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.UndeclaredThrowableException;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.transaction.Transaction;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.InvocationContext;
import org.jboss.invocation.Invoker;
import org.jboss.invocation.MarshalledInvocation;
import org.jboss.invocation.MarshalledValue;
import org.jboss.proxy.ClientContainer;
import org.jboss.proxy.Interceptor;
import org.jboss.remoting.serialization.IMarshalledValue;
import org.jboss.remoting.serialization.SerializationStreamFactory;
import org.jboss.remoting.serialization.impl.jboss.JBossSerializationManager;
import org.jboss.remoting.serialization.impl.jboss.LocalMarshalledValue;
import org.jboss.serial.objectmetamodel.safecloning.SafeClone;
import org.jboss.serial.objectmetamodel.safecloning.SafeCloningRepository;
import org.jboss.system.Registry;
import org.jboss.util.id.GUID;

public class InvokerInterceptor
extends Interceptor
implements Externalizable {
    private static final long serialVersionUID = 2548120545997920357L;
    private GUID invokerID = Invoker.ID;
    protected Invoker remoteInvoker;
    protected static Invoker localInvoker;
    protected static Class invokerProxyHA;
    static final SafeClone safeToReuse;

    public static Invoker getLocal() {
        return localInvoker;
    }

    public static void setLocal(Invoker invoker) {
        localInvoker = invoker;
    }

    public boolean isLocal() {
        return this.invokerID.equals(Invoker.ID);
    }

    public boolean isLocal(Invocation invocation) {
        if (localInvoker == null) {
            return false;
        }
        if (!this.isLocal() && !this.isClustered(invocation)) {
            return false;
        }
        return this.hasLocalTarget(invocation);
    }

    public boolean isClustered(Invocation invocation) {
        if (invokerProxyHA == null) {
            return false;
        }
        InvocationContext ctx = invocation.getInvocationContext();
        Invoker invoker = ctx.getInvoker();
        return invoker != null && invokerProxyHA.isAssignableFrom(invoker.getClass());
    }

    public boolean hasLocalTarget(Invocation invocation) {
        return Registry.lookup(invocation.getObjectName()) != null;
    }

    public Object invoke(Invocation invocation) throws Exception {
        if (this.isLocal(invocation)) {
            return this.invokeLocal(invocation);
        }
        return this.invokeInvoker(invocation);
    }

    protected Object invokeLocal(Invocation invocation) throws Exception {
        return localInvoker.invoke(invocation);
    }

    protected Object invokeMarshalled(Invocation invocation) throws Exception {
        MarshalledInvocation mi = new MarshalledInvocation(invocation);
        MarshalledValue copy = new MarshalledValue(mi);
        Invocation invocationCopy = (Invocation)copy.get();
        Transaction tx = invocation.getTransaction();
        invocationCopy.setTransaction(tx);
        try {
            Object rtnValue = localInvoker.invoke(invocationCopy);
            MarshalledValue mv = new MarshalledValue(rtnValue);
            return mv.get();
        }
        catch (Throwable t) {
            MarshalledValue mv = new MarshalledValue(t);
            Throwable t2 = (Throwable)mv.get();
            if (t2 instanceof Exception) {
                throw (Exception)t2;
            }
            throw new UndeclaredThrowableException(t2);
        }
    }

    protected Object invokeLocalMarshalled(Invocation invocation) throws Exception {
        IMarshalledValue value = null;
        value = SerializationStreamFactory.getManagerInstance() instanceof JBossSerializationManager ? new LocalMarshalledValue(invocation.getArguments(), new SafeCloningRepository(safeToReuse)) : SerializationStreamFactory.getManagerInstance().createdMarshalledValue(invocation.getArguments());
        MarshalledInvocation invocationCopy = this.createInvocationCopy(invocation, value);
        Transaction tx = invocation.getTransaction();
        invocationCopy.setTransaction(tx);
        try {
            Object rtnValue = localInvoker.invoke(invocationCopy);
            IMarshalledValue mv = null;
            mv = SerializationStreamFactory.getManagerInstance() instanceof JBossSerializationManager ? new LocalMarshalledValue(rtnValue, new SafeCloningRepository(safeToReuse)) : SerializationStreamFactory.getManagerInstance().createdMarshalledValue(rtnValue);
            return mv.get();
        }
        catch (Throwable t) {
            IMarshalledValue mv = SerializationStreamFactory.getManagerInstance().createdMarshalledValue(t);
            Throwable t2 = (Throwable)mv.get();
            if (t2 instanceof Exception) {
                throw (Exception)t2;
            }
            throw new UndeclaredThrowableException(t2);
        }
    }

    private MarshalledInvocation createInvocationCopy(Invocation invocation, IMarshalledValue value) {
        MarshalledInvocation invocationCopy = new MarshalledInvocation(invocation);
        invocationCopy.setMethod(null);
        invocationCopy.setMethodHash(MarshalledInvocation.calculateHash(invocation.getMethod()));
        invocationCopy.setMarshalledArguments(value);
        invocationCopy.setArguments(null);
        return invocationCopy;
    }

    protected Object invokeInvoker(Invocation invocation) throws Exception {
        InvocationContext ctx = invocation.getInvocationContext();
        Invoker invoker = ctx.getInvoker();
        return invoker.invoke(invocation);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.invokerID);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.invokerID = (GUID)in.readObject();
    }

    static {
        try {
            invokerProxyHA = Class.forName("org.jboss.invocation.InvokerProxyHA");
        }
        catch (Throwable ignored) {
            // empty catch block
        }
        try {
            Class.forName("org.jboss.invocation.unified.interfaces.JavaSerializationManager");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        safeToReuse = new SafeClone(){

            public boolean isSafeToReuse(Object obj) {
                if (obj == null) {
                    return false;
                }
                return obj instanceof ClientContainer || obj instanceof String || obj instanceof Number || obj instanceof BigDecimal || obj instanceof BigInteger || obj instanceof Byte || obj instanceof Double || obj instanceof Float || obj instanceof Integer || obj instanceof Long || obj instanceof Short;
            }
        };
    }
}

