/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.pooled.interfaces;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class OptimizedObjectInputStream
extends ObjectInputStream {
    private static ConcurrentReaderHashMap classCache;
    private static ConcurrentReaderHashMap objectStreamClassCache;
    private static Method lookupStreamClass;

    public static void useClassCache(boolean flag) {
        if (flag) {
            classCache = new ConcurrentReaderHashMap();
            objectStreamClassCache = new ConcurrentReaderHashMap();
        } else {
            classCache = null;
            objectStreamClassCache = null;
        }
    }

    public static void flushClassCache() {
        classCache.clear();
        objectStreamClassCache.clear();
    }

    private static Class forName(String className) throws ClassNotFoundException {
        Class<?> clazz = null;
        if (classCache != null) {
            WeakReference ref = (WeakReference)classCache.get(className);
            if (ref != null) {
                clazz = (Class<?>)ref.get();
            }
            if (clazz == null) {
                if (ref != null) {
                    classCache.remove(className);
                }
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                try {
                    clazz = loader.loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    clazz = Class.forName(className, false, loader);
                }
                classCache.put(className, new WeakReference(clazz));
            }
        } else {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        return clazz;
    }

    public OptimizedObjectInputStream(InputStream is) throws IOException {
        super(is);
    }

    protected static ObjectStreamClass lookup(Class clazz) {
        Object[] args = new Object[]{clazz, Boolean.TRUE};
        try {
            return (ObjectStreamClass)lookupStreamClass.invoke(null, args);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        String className = this.readUTF();
        ObjectStreamClass osc = null;
        if (objectStreamClassCache != null) {
            osc = (ObjectStreamClass)objectStreamClassCache.get(className);
        }
        if (osc == null) {
            Class clazz = OptimizedObjectInputStream.forName(className);
            osc = ObjectStreamClass.lookup(clazz);
            if (osc == null) {
                osc = OptimizedObjectInputStream.lookup(clazz);
            }
            if (osc == null) {
                throw new IOException("Unable to readClassDescriptor for class " + className);
            }
            if (objectStreamClassCache != null) {
                objectStreamClassCache.put(className, osc);
            }
        }
        return osc;
    }

    protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
        String className = v.getName();
        return OptimizedObjectInputStream.forName(className);
    }

    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class[] ifaceClasses = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            Class iface;
            String className = interfaces[i];
            ifaceClasses[i] = iface = OptimizedObjectInputStream.forName(className);
        }
        return Proxy.getProxyClass(loader, ifaceClasses);
    }

    static {
        lookupStreamClass = null;
        OptimizedObjectInputStream.useClassCache(true);
        try {
            lookupStreamClass = ObjectStreamClass.class.getDeclaredMethod("lookup", Class.class, Boolean.TYPE);
            lookupStreamClass.setAccessible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

