/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.serial.classmetamodel;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.jboss.serial.classmetamodel.ClassMetadataField;
import org.jboss.serial.classmetamodel.ClassMetamodelFactory;
import org.jboss.serial.classmetamodel.ConstructorManager;
import org.jboss.serial.classmetamodel.DefaultConstructorManager;
import org.jboss.serial.classmetamodel.FieldsManager;
import org.jboss.serial.classmetamodel.SunConstructorManager;
import org.jboss.serial.exception.SerializationException;
import org.jboss.serial.util.ClassMetaConsts;

public class ClassMetaData
implements ClassMetaConsts {
    private static final Logger log = Logger.getLogger((Class)ClassMetaData.class);
    private static final boolean isDebug = log.isDebugEnabled();
    static ConstructorManager[] constructorManagers = new ConstructorManager[]{new SunConstructorManager(), new DefaultConstructorManager()};
    PersistentReference constructor = emptyReference;
    WeakReference clazz;
    String className;
    HashMap fields = new HashMap();
    boolean isArray;
    int arrayDepth;
    boolean isProxy;
    ArrayList fieldsCollection = new ArrayList();
    boolean isExternalizable;
    static final PersistentReference emptyReference = new EmptyReference();
    PersistentReference privateMethodWrite = emptyReference;
    PersistentReference privateMethodRead = emptyReference;
    PersistentReference readResolveMethod = emptyReference;
    PersistentReference writeReplaceMethod = emptyReference;
    static /* synthetic */ Class class$java$io$Serializable;

    public ClassMetaData(Class clazz) {
        this.setClassName(clazz.getName());
        this.setClazz(clazz);
        this.setProxy(Proxy.isProxyClass(clazz));
        try {
            Method aMethod = clazz.getDeclaredMethod("writeReplace", EMPTY_CLASS_ARRY);
            aMethod.setAccessible(true);
            this.setWriteReplaceMethod(aMethod);
        }
        catch (NoSuchMethodException e) {
            this.setWriteReplaceMethod(null);
        }
        try {
            this.setConstructor(ClassMetaData.findConstructor(clazz));
        }
        catch (NoSuchMethodException e) {
            this.setConstructor(null);
        }
        this.setExternalizable(Externalizable.class.isAssignableFrom(clazz));
        this.fieldsExplode(clazz);
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    private void calculateDepthAndName(Class clazz) {
        this.arrayDepth = 0;
        while (clazz.isArray()) {
            ++this.arrayDepth;
            clazz = clazz.getComponentType();
        }
        this.clazz = new WeakReference<Class>(clazz);
    }

    public Class getClazz() {
        return (Class)this.clazz.get();
    }

    public void setClazz(Class clazz) {
        this.clazz = new WeakReference<Class>(clazz);
        if (clazz.isArray()) {
            this.setArray(true);
            this.calculateDepthAndName(clazz);
        }
    }

    public Constructor getConstructor() {
        return (Constructor)this.constructor.get();
    }

    public void setConstructor(Constructor constructor) {
        if (constructor != null) {
            constructor.setAccessible(true);
        }
        this.constructor = new ConstructorPersistentReference(this.getClazz(), constructor);
    }

    public ClassMetadataField getField(String name) {
        return (ClassMetadataField)this.fields.get(name);
    }

    public ClassMetadataField getField(int pos) {
        return (ClassMetadataField)this.fieldsCollection.get(pos);
    }

    public boolean isExternalizable() {
        return this.isExternalizable;
    }

    public void setExternalizable(boolean isExternalizable) {
        this.isExternalizable = isExternalizable;
    }

    public Iterator getFieldsIterator() {
        return this.fieldsCollection.iterator();
    }

    public int hashCode() {
        return this.className.hashCode();
    }

    public boolean equals(Object obj) {
        return this.className.equals(((ClassMetaData)obj).className);
    }

    public void addField(String fieldName, ClassMetadataField classfield) {
        this.fields.put(fieldName, classfield);
        this.fieldsCollection.add(classfield);
    }

    public int getFieldsSize() {
        return this.fieldsCollection.size();
    }

    public boolean isArray() {
        return this.isArray;
    }

    public void setArray(boolean isArray) {
        this.isArray = isArray;
    }

    public int getArrayDepth() {
        return this.arrayDepth;
    }

    public Object newInstance() throws IOException {
        Constructor localConstructor = this.getConstructor();
        try {
            if (localConstructor == null) {
                return this.getClass().newInstance();
            }
            return localConstructor.newInstance(EMPTY_OBJECT_ARRAY);
        }
        catch (InstantiationException e) {
            throw new SerializationException("Could not create instance of " + this.className + " - " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new SerializationException("Could not create instance of " + this.className + " - " + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new SerializationException("Could not create instance of " + this.className + " - " + e.getMessage(), e);
        }
    }

    public Method getPrivateMethodRead() {
        return (Method)this.privateMethodRead.get();
    }

    public void setPrivateMethodRead(Method privateMethodRead) {
        this.privateMethodRead = new MethodPersistentReference(privateMethodRead);
    }

    public Method getPrivateMethodWrite() {
        return (Method)this.privateMethodWrite.get();
    }

    public void setPrivateMethodWrite(Method privateMethodWrite) {
        this.privateMethodWrite = new MethodPersistentReference(privateMethodWrite);
    }

    public Method getReadResolveMethod() {
        return (Method)this.readResolveMethod.get();
    }

    public void setReadResolveMethod(Method readResolveMethod) {
        this.readResolveMethod = new MethodPersistentReference(readResolveMethod);
    }

    public boolean isProxy() {
        return this.isProxy;
    }

    public void setProxy(boolean proxy) {
        this.isProxy = proxy;
    }

    public Method getWriteReplaceMethod() {
        return (Method)this.writeReplaceMethod.get();
    }

    public void setWriteReplaceMethod(Method writeReplaceMethod) {
        this.writeReplaceMethod = new MethodPersistentReference(writeReplaceMethod);
    }

    private static Constructor findConstructor(Class clazz) throws NoSuchMethodException {
        if (clazz.isInterface()) {
            return null;
        }
        for (int i = 0; i < constructorManagers.length; ++i) {
            if (!constructorManagers[i].isSupported()) continue;
            return constructorManagers[i].getConstructor(clazz);
        }
        throw new NoSuchMethodException("Constructor not found as having difficulties in reflection");
    }

    private void fieldsExplode(Class clazz) {
        if (!this.isExternalizable() && !this.isArray) {
            this.lookupInternalMethods(clazz);
            for (Class classIteration = clazz; classIteration != null; classIteration = classIteration.getSuperclass()) {
                Field[] fields = classIteration.getDeclaredFields();
                for (int i = 0; i < fields.length; ++i) {
                    if ((fields[i].getModifiers() & 0x88) != 0) continue;
                    fields[i].setAccessible(true);
                    ClassMetadataField classfield = new ClassMetadataField();
                    classfield.setField(fields[i]);
                    classfield.setFieldName(fields[i].getName());
                    classfield.setObject(!ClassMetamodelFactory.isImmutable(fields[i].getType()));
                    FieldsManager.getFieldsManager().fillMetadata(classfield);
                    this.addField(classfield.getFieldName(), classfield);
                }
            }
        }
    }

    private void lookupInternalMethods(Class clazz) {
        if (clazz.isInterface()) {
            return;
        }
        try {
            Method method = clazz.getDeclaredMethod("readResolve", EMPTY_CLASS_ARRY);
            method.setAccessible(true);
            this.setReadResolveMethod(method);
        }
        catch (Exception ignored) {
            // empty catch block
        }
        Class currentClass = clazz;
        while ((class$java$io$Serializable == null ? ClassMetaData.class$("java.io.Serializable") : class$java$io$Serializable).isAssignableFrom(currentClass)) {
            try {
                Method method = currentClass.getDeclaredMethod("readObject", ObjectInputStream.class);
                method.setAccessible(true);
                this.setPrivateMethodRead(method);
                method = currentClass.getDeclaredMethod("writeObject", ObjectOutputStream.class);
                method.setAccessible(true);
                this.setPrivateMethodWrite(method);
                break;
            }
            catch (Exception exception) {
                currentClass = currentClass.getSuperclass();
            }
        }
    }

    static class ConstructorPersistentReference
    extends PersistentReference {
        ConstructorPersistentReference(Class clazz, Constructor constructor) {
            super(clazz, constructor);
        }

        public synchronized void rebuildReference() throws Exception {
            if (this.internalGet() != null) {
                return;
            }
            if (isDebug) {
                log.debug((Object)("Constructor being rebuilt for " + this.getMappedClass()));
            }
            Constructor constructorUsed = ClassMetaData.findConstructor(this.getMappedClass());
            this.buildReference(constructorUsed);
        }

        public Constructor getConstructor() {
            return (Constructor)this.get();
        }
    }

    static class MethodPersistentReference
    extends PersistentReference {
        String name;
        Class[] arguments;

        MethodPersistentReference(Method method) {
            super(method != null ? method.getDeclaringClass() : null, method);
            if (method != null) {
                this.name = method.getName();
                this.arguments = method.getParameterTypes();
            }
        }

        public synchronized void rebuildReference() throws Exception {
            if (this.internalGet() != null) {
                return;
            }
            Method aMethod = this.getMappedClass().getDeclaredMethod(this.name, this.arguments);
            aMethod.setAccessible(true);
            this.buildReference(aMethod);
        }

        public Method getMethod() {
            return (Method)this.get();
        }
    }

    static class EmptyReference
    extends PersistentReference {
        public EmptyReference() {
            super(null, null);
        }

        public void rebuildReference() throws Exception {
        }
    }

    static abstract class PersistentReference {
        WeakReference classReference;
        Reference referencedObject;

        PersistentReference(Class clazz, Object referencedObject) {
            if (clazz != null) {
                this.classReference = new WeakReference<Class>(clazz);
            }
            this.buildReference(referencedObject);
        }

        protected Object internalGet() {
            if (this.referencedObject == null) {
                return null;
            }
            return this.referencedObject.get();
        }

        public Object get() {
            if (this.referencedObject == null) {
                return null;
            }
            Object returnValue = this.referencedObject.get();
            if (returnValue == null) {
                try {
                    if (isDebug) {
                        log.debug((Object)("Reference on " + this.getClass().getName() + " being rebuilt"));
                    }
                    this.rebuildReference();
                    returnValue = this.internalGet();
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            return returnValue;
        }

        public abstract void rebuildReference() throws Exception;

        public void buildReference(Object obj) {
            this.referencedObject = obj == null ? null : new SoftReference<Object>(obj);
        }

        public Class getMappedClass() {
            if (this.classReference == null) {
                return null;
            }
            Class returnClass = (Class)this.classReference.get();
            if (returnClass == null) {
                throw new RuntimeException("Class was already unloaded");
            }
            return returnClass;
        }
    }
}

