/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.serial.classmetamodel;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import org.jboss.serial.classmetamodel.ClassMetaData;
import org.jboss.serial.util.ClassMetaConsts;
import org.jboss.serial.util.FastHashMap;
import org.jboss.serial.util.PartitionedWeakHashMap;

public class ClassMetamodelFactory
implements ClassMetaConsts {
    static Method methodLookup;
    static Method methodGetField;
    private static Map systemClassLoaderMap;
    static ThreadLocal cacheLoader;
    static PartitionedWeakHashMap cache;
    static ClassMetaData proxyMetaData;

    private static ObjectStreamClass lookup(Class clazz) throws IllegalAccessException, InvocationTargetException {
        return (ObjectStreamClass)methodLookup.invoke(null, clazz, Boolean.TRUE);
    }

    private static Field getField(Object source) throws IllegalAccessException, InvocationTargetException {
        return (Field)methodGetField.invoke(source, EMPTY_OBJECT_ARRAY);
    }

    public static void clear() {
        cache.clear();
    }

    public static Map getCache() {
        return cache;
    }

    public static void printCacheDebug() {
        Iterator iter = ClassMetamodelFactory.getCache().keySet().iterator();
        while (iter.hasNext()) {
            Object loader = iter.next();
            System.out.println("ClassLoader = " + loader);
            Map classesMap = (Map)ClassMetamodelFactory.getCache().get(loader);
            Iterator classesIterator = classesMap.keySet().iterator();
            while (classesIterator.hasNext()) {
                System.out.println("Class = " + classesIterator.next());
            }
        }
    }

    private static Map getLoaderMap(ClassLoader loader) {
        if (loader == null) {
            return systemClassLoaderMap;
        }
        CacheLoaderReference loaderReference = (CacheLoaderReference)cacheLoader.get();
        if (loaderReference == null) {
            loaderReference = new CacheLoaderReference();
            cacheLoader.set(loaderReference);
        }
        if (loaderReference.getCurrentClassLoader() == loader) {
            return loaderReference.getCurrentMap();
        }
        Map hashMap = (Map)cache.get(loader);
        Object returnLoader = null;
        if (hashMap == null) {
            hashMap = new FastHashMap();
            cache.put(loader, hashMap);
            hashMap = (Map)cache.get(loader);
        }
        loaderReference.setCurrentClassLoader(loader);
        loaderReference.setCurrentMap(hashMap);
        return hashMap;
    }

    public static ClassMetaData getClassMetaData(String clazzName, ClassLoader loader, boolean checkSerializable) throws IOException {
        try {
            Map loaderMap = ClassMetamodelFactory.getLoaderMap(loader);
            ClassMetaData classMetadata = (ClassMetaData)loaderMap.get(clazzName);
            if (classMetadata == null) {
                if (classMetadata == null) {
                    Class<?> clazz = loader.loadClass(clazzName);
                    if (checkSerializable && !Serializable.class.isAssignableFrom(clazz)) {
                        throw new NotSerializableException(clazz.getName());
                    }
                    loaderMap = ClassMetamodelFactory.getLoaderMap(loader);
                    classMetadata = new ClassMetaData(clazz);
                    loaderMap.put(clazzName, classMetadata);
                }
                classMetadata = (ClassMetaData)loaderMap.get(clazzName);
            }
            if (classMetadata.isProxy()) {
                return proxyMetaData;
            }
            return classMetadata;
        }
        catch (ClassNotFoundException e) {
            IOException ex = new IOException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    public static ClassMetaData getClassMetaData(Class clazz, boolean checkSerializable) throws IOException {
        if (checkSerializable && !Serializable.class.isAssignableFrom(clazz)) {
            throw new NotSerializableException(clazz.getName());
        }
        Map loaderMap = ClassMetamodelFactory.getLoaderMap(clazz.getClassLoader());
        ClassMetaData classMetadata = (ClassMetaData)loaderMap.get(clazz.getName());
        if (classMetadata == null) {
            classMetadata = new ClassMetaData(clazz);
            loaderMap.put(clazz.getName(), classMetadata);
            classMetadata = (ClassMetaData)loaderMap.get(clazz.getName());
        }
        if (classMetadata.isProxy()) {
            return proxyMetaData;
        }
        return classMetadata;
    }

    public static boolean isImmutable(Class clazz) {
        return clazz == Character.class || clazz == String.class || clazz == Long.class || clazz == Byte.class || clazz == Double.class || clazz == Float.class || clazz == Integer.class || clazz == Short.class || clazz == Boolean.class || clazz.isPrimitive();
    }

    static {
        systemClassLoaderMap = new FastHashMap();
        cacheLoader = new ThreadLocal();
        try {
            methodLookup = ObjectStreamClass.class.getDeclaredMethod("lookup", Class.class, Boolean.TYPE);
            methodLookup.setAccessible(true);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            methodGetField = ObjectStreamField.class.getDeclaredMethod("getField", new Class[0]);
            methodGetField.setAccessible(true);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        cache = new PartitionedWeakHashMap();
        proxyMetaData = null;
        try {
            proxyMetaData = ClassMetamodelFactory.getClassMetaData("java.lang.reflect.Proxy", Thread.currentThread().getContextClassLoader(), true);
            proxyMetaData.setProxy(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class CacheLoaderReference {
        WeakReference currentClassLoader;
        WeakReference currentHashMap;

        private CacheLoaderReference() {
        }

        public ClassLoader getCurrentClassLoader() {
            if (this.currentClassLoader == null) {
                return null;
            }
            return (ClassLoader)this.currentClassLoader.get();
        }

        public void setCurrentClassLoader(ClassLoader loader) {
            this.currentClassLoader = new WeakReference<ClassLoader>(loader);
        }

        public Map getCurrentMap() {
            if (this.currentHashMap == null) {
                return null;
            }
            return (Map)this.currentHashMap.get();
        }

        public void setCurrentMap(Map currentMap) {
            this.currentHashMap = new WeakReference<Map>(currentMap);
        }
    }
}

