/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.serial.io;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.lang.reflect.Field;
import org.jboss.serial.exception.SerializationException;
import org.jboss.serial.objectmetamodel.DataContainer;
import org.jboss.serial.objectmetamodel.ObjectSubstitutionInterface;
import org.jboss.serial.objectmetamodel.safecloning.SafeCloningRepository;
import org.jboss.serial.util.Logger;
import org.jboss.serial.util.StringUtil;
import org.jboss.serial.util.StringUtilBuffer;

public class JBossObjectOutputStream
extends ObjectOutputStream {
    OutputStream output;
    DataOutputStream dataOutput;
    boolean checkSerializableClass = false;
    static Field fieldEnableReplace;
    StringUtilBuffer buffer;

    private ObjectSubstitutionInterface getSubstitutionInterface() throws IOException {
        try {
            if (fieldEnableReplace.getBoolean(this)) {
                return new ObjectSubstitutionInterface(){

                    public Object replaceObject(Object obj) throws IOException {
                        return JBossObjectOutputStream.this.replaceObject(obj);
                    }
                };
            }
            return null;
        }
        catch (IllegalAccessException ex) {
            throw new SerializationException(ex.getMessage(), ex);
        }
    }

    protected boolean enableReplaceObject(boolean enable) {
        try {
            if (enable == fieldEnableReplace.getBoolean(this)) {
                return enable;
            }
            fieldEnableReplace.setBoolean(this, enable);
            return !fieldEnableReplace.getBoolean(this);
        }
        catch (Exception e) {
            Logger.printLog(e.getMessage(), e);
            return super.enableReplaceObject(enable);
        }
    }

    public JBossObjectOutputStream(OutputStream output) throws IOException {
        this(output, false);
    }

    public JBossObjectOutputStream(OutputStream output, StringUtilBuffer buffer) throws IOException {
        this(output, false, buffer);
    }

    public JBossObjectOutputStream(OutputStream output, boolean checkSerializableClass) throws IOException {
        this(output, checkSerializableClass, new StringUtilBuffer(10240, 10240));
    }

    public JBossObjectOutputStream(OutputStream output, boolean checkSerializableClass, StringUtilBuffer buffer) throws IOException {
        this.buffer = buffer;
        this.output = output;
        this.checkSerializableClass = checkSerializableClass;
        this.dataOutput = output instanceof DataOutputStream ? (DataOutputStream)output : new DataOutputStream(output);
    }

    protected void writeObjectOverride(Object obj) throws IOException {
        DataContainer dataContainer = new DataContainer(null, this.getSubstitutionInterface(), this.checkSerializableClass);
        dataContainer.setBuffer(this.buffer);
        this.dataOutput = this.output instanceof DataOutputStream ? (DataOutputStream)this.output : new DataOutputStream(this.output);
        ObjectOutput objectOutput = dataContainer.getOutput();
        objectOutput.writeObject(obj);
        dataContainer.saveData(this.dataOutput);
    }

    public void writeObjectDirect(Object obj) throws IOException {
        DataContainer dataContainer = new DataContainer(null, this.getSubstitutionInterface(), this.checkSerializableClass);
        dataContainer.setBuffer(this.buffer);
        this.dataOutput = this.output instanceof DataOutputStream ? (DataOutputStream)this.output : new DataOutputStream(this.output);
        ObjectOutput objectOutput = dataContainer.getDirectOutput(this.dataOutput);
        objectOutput.writeObject(obj);
        objectOutput.flush();
        this.flush();
    }

    public void writeUnshared(Object obj) throws IOException {
        this.writeObjectOverride(obj);
    }

    public void defaultWriteObject() throws IOException {
    }

    public void writeFields() throws IOException {
    }

    public void reset() throws IOException {
    }

    protected void writeStreamHeader() throws IOException {
    }

    protected void writeClassDescriptor(ObjectStreamClass desc) throws IOException {
    }

    public void write(int val) throws IOException {
        this.dataOutput.write(val);
    }

    public void write(byte[] buf) throws IOException {
        this.dataOutput.write(buf);
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        if (buf == null) {
            throw new SerializationException("buf parameter can't be null");
        }
        this.dataOutput.write(buf, off, len);
    }

    public void flush() throws IOException {
        if (this.dataOutput != null) {
            this.dataOutput.flush();
        } else {
            this.output.flush();
        }
    }

    protected void drain() throws IOException {
    }

    public void close() throws IOException {
        this.flush();
        this.dataOutput.close();
        this.dataOutput.close();
    }

    public void writeBoolean(boolean val) throws IOException {
        this.dataOutput.writeBoolean(val);
    }

    public void writeByte(int val) throws IOException {
        this.dataOutput.writeByte(val);
    }

    public void writeShort(int val) throws IOException {
        this.dataOutput.writeShort(val);
    }

    public void writeChar(int val) throws IOException {
        this.dataOutput.writeChar(val);
    }

    public void writeInt(int val) throws IOException {
        this.dataOutput.writeInt(val);
    }

    public void writeLong(long val) throws IOException {
        this.dataOutput.writeLong(val);
    }

    public void writeFloat(float val) throws IOException {
        this.dataOutput.writeFloat(val);
    }

    public void writeDouble(double val) throws IOException {
        this.dataOutput.writeDouble(val);
    }

    public void writeBytes(String str) throws IOException {
        this.dataOutput.writeBytes(str);
    }

    public void writeChars(String str) throws IOException {
        this.dataOutput.writeChars(str);
    }

    public void writeUTF(String str) throws IOException {
        StringUtil.saveString(this.dataOutput, str, this.buffer);
    }

    public Object smartClone(Object obj) throws IOException {
        return this.smartClone(obj, null, Thread.currentThread().getContextClassLoader());
    }

    public Object smartClone(Object obj, SafeCloningRepository safeToReuse) throws IOException {
        return this.smartClone(obj, safeToReuse, Thread.currentThread().getContextClassLoader());
    }

    public Object smartClone(Object obj, SafeCloningRepository safeToReuse, ClassLoader loader) throws IOException {
        DataContainer container = new DataContainer(loader, this.getSubstitutionInterface(), safeToReuse, this.checkSerializableClass);
        ObjectOutput output = container.getOutput();
        output.writeObject(obj);
        output.flush();
        ObjectInput input = container.getInput();
        try {
            return input.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new SerializationException(e.getMessage(), e);
        }
    }

    static {
        try {
            fieldEnableReplace = ObjectOutputStream.class.getDeclaredField("enableReplace");
            fieldEnableReplace.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            Logger.printLog(e.getMessage(), e);
        }
    }
}

