/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.serial.objectmetamodel;

import java.io.IOException;
import java.io.ObjectInput;
import java.lang.reflect.InvocationTargetException;
import org.jboss.serial.classmetamodel.ClassMetaData;
import org.jboss.serial.classmetamodel.ClassMetamodelFactory;
import org.jboss.serial.exception.SerializationException;
import org.jboss.serial.objectmetamodel.ObjectDescription;
import org.jboss.serial.objectmetamodel.ObjectReference;
import org.jboss.serial.objectmetamodel.ObjectSubstitutionInterface;
import org.jboss.serial.objectmetamodel.ObjectsCache;
import org.jboss.serial.persister.PersistResolver;
import org.jboss.serial.persister.Persister;
import org.jboss.serial.util.Logger;

public class ObjectDescriptorFactory {
    static Object objectFromDescription(ObjectsCache cache, ObjectReference reference, ObjectInput input) throws IOException {
        ObjectDescription description = null;
        byte byteIdentify = cache.getInput().readByte();
        if (byteIdentify == 51) {
            return ObjectDescriptorFactory.readObjectDescriptionFromStreaming(cache, reference, input);
        }
        if (cache.getSafeToReuse() != null) {
            description = cache.getSafeToReuse().findReference(reference);
        }
        if (description == null) {
            description = cache.findObjectInCache(reference);
        }
        if (description == null) {
            throw new SerializationException("Object reference " + reference + " was not found");
        }
        return description.getCurrentValue();
    }

    static ObjectDescription describeObject(ObjectsCache cache, Object obj, ObjectSubstitutionInterface substitution) throws IOException {
        ClassMetaData metaData;
        ObjectsCache.JBossSeralizationOutputInterface outputParent = cache.getOutput();
        if (Logger.logLevel >= 1 && obj == null) {
            Logger.printLog("obj==null", new Exception());
        }
        if (Logger.logLevel >= 5) {
            Logger.printLog("describeObject for class=" + obj.getClass().getName());
        }
        if (substitution != null) {
            obj = substitution.replaceObject(obj);
        }
        if ((metaData = ClassMetamodelFactory.getClassMetaData(obj.getClass(), cache.isCheckSerializableClass())).getWriteReplaceMethod() != null) {
            try {
                obj = metaData.getWriteReplaceMethod().invoke(obj, new Object[0]);
                metaData = ClassMetamodelFactory.getClassMetaData(obj.getClass(), cache.isCheckSerializableClass());
            }
            catch (Exception e) {
                IOException io = new IOException("Metadata Serialization Error");
                io.initCause(e);
                throw io;
            }
        }
        ObjectReference reference = new ObjectReference(obj, metaData.getClassName());
        cache.getOutput().addObjectReference(reference);
        ObjectDescription description = null;
        if (cache.getSafeToReuse() != null) {
            description = cache.getSafeToReuse().storeSafe(reference, obj);
        }
        if (description == null) {
            description = cache.findObjectInCache(reference);
        }
        if (description != null) {
            outputParent.writeByte(50);
            return description;
        }
        outputParent.writeByte(51);
        Persister persister = PersistResolver.resolvePersister(obj, metaData);
        description = new ObjectDescription(metaData);
        cache.putObjectInCache(obj, description);
        outputParent.writeByte(persister.getId());
        persister.writeData(description, cache.getOutput(), obj, substitution);
        return description;
    }

    static Object readObjectDescriptionFromStreaming(ObjectsCache cache, ObjectReference reference, ObjectInput input) throws IOException {
        if (Logger.logLevel >= 5) {
            Logger.printLog("Reading object for type=" + reference.getClassName() + " classLoader=" + cache.getLoader());
        }
        byte persisterId = input.readByte();
        Persister persister = PersistResolver.resolvePersister(persisterId);
        ObjectDescription description = new ObjectDescription();
        description.setMetaData(ClassMetamodelFactory.getClassMetaData(reference.getClassName(), cache.getLoader(), false));
        cache.putObjectInCache(reference, description);
        Object value = persister.readData(cache.getLoader(), description, cache.getInput(), cache.getSubstitution());
        if (cache.getSubstitution() != null) {
            value = cache.getSubstitution().replaceObject(value);
        }
        try {
            if (description.getMetaData().getReadResolveMethod() != null) {
                value = description.getMetaData().getReadResolveMethod().invoke(value, new Object[0]);
            }
        }
        catch (IllegalAccessException e) {
            throw new SerializationException(e);
        }
        catch (InvocationTargetException e) {
            throw new SerializationException(e);
        }
        description.setCurrentValue(value);
        return value;
    }
}

