/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.serial.objectmetamodel;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jboss.serial.objectmetamodel.DataExport;
import org.jboss.serial.util.StringUtil;
import org.jboss.serial.util.StringUtilBuffer;

public class ObjectReference
extends DataExport {
    int hashUniqueId;
    String className;

    public ObjectReference() {
    }

    public ObjectReference(int hashUniqueId, String className) {
        this.hashUniqueId = hashUniqueId;
        this.className = className;
    }

    public ObjectReference(Object obj) {
        this.setHashUniqueId(System.identityHashCode(obj));
        this.className = obj.getClass().getName();
    }

    public ObjectReference(Object obj, String className) {
        this.setHashUniqueId(System.identityHashCode(obj));
        this.className = className;
    }

    public int getHashUniqueId() {
        return this.hashUniqueId;
    }

    public void setHashUniqueId(int hashUniqueId) {
        this.hashUniqueId = hashUniqueId;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String toString() {
        return "reference " + this.hashUniqueId + " for class=" + this.className;
    }

    public void writeMyself(DataOutput output, StringUtilBuffer buffer) throws IOException {
        output.writeInt(this.hashUniqueId);
        StringUtil.saveString(output, this.className, buffer);
    }

    public void readMyself(DataInput input) throws IOException {
        this.hashUniqueId = input.readInt();
        this.className = StringUtil.readString(input);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectReference that = (ObjectReference)o;
        if (this.hashUniqueId != that.hashUniqueId) {
            return false;
        }
        return this.className.equals(that.className);
    }

    public int hashCode() {
        int result = this.hashUniqueId;
        result = 29 * result + this.className.hashCode();
        return result;
    }
}

