/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.serial.persister;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import org.jboss.serial.exception.SerializationException;
import org.jboss.serial.objectmetamodel.ObjectDescription;
import org.jboss.serial.objectmetamodel.ObjectSubstitutionInterface;
import org.jboss.serial.persister.Persister;

public class ArrayPersister
implements Persister {
    byte id;

    public byte getId() {
        return this.id;
    }

    public void setId(byte id) {
        this.id = id;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeData(ObjectDescription descriptor, ObjectOutput out, Object obj, ObjectSubstitutionInterface substitution) throws IOException {
        if (descriptor.getMetaData().getArrayDepth() == 1 && descriptor.getMetaData().getClazz().isPrimitive()) {
            Class clazz = descriptor.getMetaData().getClazz();
            if (clazz == Integer.TYPE) {
                int[] finalArray = (int[])obj;
                out.writeInt(finalArray.length);
                for (int i = 0; i < finalArray.length; ++i) {
                    out.writeInt(finalArray[i]);
                }
                return;
            } else if (clazz == Byte.TYPE) {
                byte[] finalArray = (byte[])obj;
                out.writeInt(finalArray.length);
                out.write(finalArray);
                return;
            } else if (clazz == Long.TYPE) {
                long[] finalArray = (long[])obj;
                out.writeInt(finalArray.length);
                for (int i = 0; i < finalArray.length; ++i) {
                    out.writeLong(finalArray[i]);
                }
                return;
            } else if (clazz == Float.TYPE) {
                float[] finalArray = (float[])obj;
                out.writeInt(finalArray.length);
                for (int i = 0; i < finalArray.length; ++i) {
                    out.writeFloat(finalArray[i]);
                }
                return;
            } else if (clazz == Double.TYPE) {
                double[] finalArray = (double[])obj;
                out.writeInt(finalArray.length);
                for (int i = 0; i < finalArray.length; ++i) {
                    out.writeDouble(finalArray[i]);
                }
                return;
            } else if (clazz == Short.TYPE) {
                short[] finalArray = (short[])obj;
                out.writeInt(finalArray.length);
                for (int i = 0; i < finalArray.length; ++i) {
                    out.writeShort(finalArray[i]);
                }
                return;
            } else if (clazz == Character.TYPE) {
                char[] finalArray = (char[])obj;
                out.writeInt(finalArray.length);
                for (int i = 0; i < finalArray.length; ++i) {
                    out.writeChar(finalArray[i]);
                }
                return;
            } else {
                if (clazz != Boolean.TYPE) throw new RuntimeException("Unexpected datatype " + clazz.getName());
                boolean[] finalArray = (boolean[])obj;
                out.writeInt(finalArray.length);
                for (int i = 0; i < finalArray.length; ++i) {
                    out.writeBoolean(finalArray[i]);
                }
            }
            return;
        } else {
            this.saveObjectArray(obj, out);
        }
    }

    private void saveObjectArray(Object obj, ObjectOutput out) throws IOException {
        Object[] objs = (Object[])obj;
        out.writeInt(objs.length);
        for (int i = 0; i < objs.length; ++i) {
            out.writeObject(objs[i]);
        }
    }

    public Object readData(ClassLoader loader, ObjectDescription descriptor, ObjectInput input, ObjectSubstitutionInterface substitution) throws IOException {
        try {
            int length = input.readInt();
            if (descriptor.getMetaData().getArrayDepth() == 1 && descriptor.getMetaData().getClazz().isPrimitive()) {
                Class clazz = descriptor.getMetaData().getClazz();
                if (clazz == Integer.TYPE) {
                    int[] finalArray = new int[length];
                    for (int i = 0; i < finalArray.length; ++i) {
                        finalArray[i] = input.readInt();
                    }
                    return finalArray;
                }
                if (clazz == Byte.TYPE) {
                    byte[] finalArray = new byte[length];
                    input.readFully(finalArray);
                    return finalArray;
                }
                if (clazz == Long.TYPE) {
                    long[] finalArray = new long[length];
                    for (int i = 0; i < finalArray.length; ++i) {
                        finalArray[i] = input.readLong();
                    }
                    return finalArray;
                }
                if (clazz == Float.TYPE) {
                    float[] finalArray = new float[length];
                    for (int i = 0; i < finalArray.length; ++i) {
                        finalArray[i] = input.readFloat();
                    }
                    return finalArray;
                }
                if (clazz == Double.TYPE) {
                    double[] finalArray = new double[length];
                    for (int i = 0; i < finalArray.length; ++i) {
                        finalArray[i] = input.readDouble();
                    }
                    return finalArray;
                }
                if (clazz == Short.TYPE) {
                    short[] finalArray = new short[length];
                    for (int i = 0; i < finalArray.length; ++i) {
                        finalArray[i] = input.readShort();
                    }
                    return finalArray;
                }
                if (clazz == Character.TYPE) {
                    char[] finalArray = new char[length];
                    for (int i = 0; i < finalArray.length; ++i) {
                        finalArray[i] = input.readChar();
                    }
                    return finalArray;
                }
                if (clazz == Boolean.TYPE) {
                    boolean[] finalArray = new boolean[length];
                    for (int i = 0; i < finalArray.length; ++i) {
                        finalArray[i] = input.readBoolean();
                    }
                    return finalArray;
                }
                throw new RuntimeException("Unexpected datatype " + clazz.getName());
            }
            return this.readObjectArray(descriptor, length, input);
        }
        catch (ClassNotFoundException ex) {
            throw new SerializationException(ex);
        }
    }

    private Object readObjectArray(ObjectDescription descriptor, int length, ObjectInput input) throws ClassNotFoundException, IOException {
        int depth = descriptor.getMetaData().getArrayDepth();
        int[] depthParam = new int[descriptor.getMetaData().getArrayDepth()];
        depthParam[0] = length;
        for (int i = 1; i < depth; ++i) {
            depthParam[i] = 0;
        }
        Object[] producedArray = (Object[])Array.newInstance(descriptor.getMetaData().getClazz(), depthParam);
        descriptor.setCurrentValue(producedArray);
        for (int i = 0; i < length; ++i) {
            producedArray[i] = input.readObject();
        }
        return producedArray;
    }

    public boolean canPersist(Object obj) {
        return false;
    }
}

