/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.serial.persister;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jboss.serial.classmetamodel.ClassMetaData;
import org.jboss.serial.classmetamodel.ClassMetamodelFactory;
import org.jboss.serial.objectmetamodel.ObjectDescription;
import org.jboss.serial.objectmetamodel.ObjectSubstitutionInterface;
import org.jboss.serial.persister.Persister;

public class EnumerationPersister
implements Persister {
    byte id;
    static Class enumClass;

    public byte getId() {
        return this.id;
    }

    public void setId(byte id) {
        this.id = id;
    }

    public void writeData(ObjectDescription descriptor, ObjectOutput out, Object obj, ObjectSubstitutionInterface substitution) throws IOException {
        Enum aEnum = (Enum)obj;
        out.writeUTF(aEnum.getDeclaringClass().getName());
        out.writeUTF(aEnum.name());
    }

    public Object readData(ClassLoader loader, ObjectDescription descriptor, ObjectInput input, ObjectSubstitutionInterface substitution) throws IOException {
        String instanceName = null;
        Class enumClass = null;
        String classEnum = input.readUTF();
        try {
            ClassMetaData metaData = ClassMetamodelFactory.getClassMetaData(classEnum, loader, true);
            enumClass = metaData.getClazz();
            instanceName = input.readUTF();
            T[] constants = enumClass.getEnumConstants();
            for (int i = 0; i < constants.length; ++i) {
                if (!constants[i].toString().equals(instanceName)) continue;
                return constants[i];
            }
        }
        catch (Exception e) {
            IOException ioException = new IOException(e.getMessage());
            ioException.initCause(e);
            throw ioException;
        }
        throw new IOException("Enumeration " + instanceName + " not found at Enum Class " + enumClass);
    }

    public boolean canPersist(Object obj) {
        if (enumClass != null) {
            return enumClass.isAssignableFrom(obj.getClass());
        }
        return false;
    }

    static {
        try {
            enumClass = Class.forName("java.lang.Enum");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

