/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.serial.persister;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import org.jboss.serial.exception.SerializationException;
import org.jboss.serial.objectmetamodel.ObjectDescription;
import org.jboss.serial.objectmetamodel.ObjectSubstitutionInterface;
import org.jboss.serial.persister.ExternalizePersister;
import org.jboss.serial.persister.ObjectInputStreamProxy;
import org.jboss.serial.persister.ObjectOutputStreamProxy;
import org.jboss.serial.persister.Persister;
import org.jboss.serial.persister.RegularObjectPersister;

public class PrivateWritePersister
implements Persister {
    byte id;
    ExternalizePersister externalizer;
    RegularObjectPersister regular;

    public byte getId() {
        return this.id;
    }

    public void setId(byte id) {
        this.id = id;
    }

    public ExternalizePersister getExternalizer() {
        return this.externalizer;
    }

    public void setExternalizer(ExternalizePersister externalizer) {
        this.externalizer = externalizer;
    }

    public RegularObjectPersister getRegular() {
        return this.regular;
    }

    public void setRegular(RegularObjectPersister regular) {
        this.regular = regular;
    }

    public void writeData(ObjectDescription descriptor, ObjectOutput out, Object obj, ObjectSubstitutionInterface substitution) throws IOException {
        try {
            if (descriptor.getMetaData().getPrivateMethodWrite() == null) {
                if (descriptor.getMetaData().isExternalizable()) {
                    this.externalizer.writeData(descriptor, out, obj, substitution);
                } else {
                    this.regular.writeData(descriptor, out, obj, substitution);
                }
            } else {
                descriptor.getMetaData().getPrivateMethodWrite().invoke(obj, new ObjectOutputStreamProxy(out, obj, descriptor.getMetaData(), substitution));
            }
        }
        catch (IllegalArgumentException e) {
            throw new SerializationException(e);
        }
        catch (IllegalAccessException e) {
            throw new SerializationException(e);
        }
        catch (InvocationTargetException e) {
            throw new SerializationException(e);
        }
    }

    public Object readData(ClassLoader loader, ObjectDescription descriptor, ObjectInput input, ObjectSubstitutionInterface substitution) throws IOException {
        Object obj = descriptor.getMetaData().newInstance();
        descriptor.setCurrentValue(obj);
        try {
            if (descriptor.getMetaData().getPrivateMethodRead() == null) {
                if (descriptor.getMetaData().isExternalizable()) {
                    this.externalizer.readData(loader, descriptor, input, substitution);
                } else {
                    this.regular.readData(loader, descriptor, input, substitution);
                }
            } else {
                descriptor.getMetaData().getPrivateMethodRead().invoke(obj, new ObjectInputStreamProxy(input, obj, descriptor.getMetaData(), substitution));
            }
        }
        catch (IllegalArgumentException e) {
            throw new SerializationException(e);
        }
        catch (IllegalAccessException e) {
            throw new SerializationException(e);
        }
        catch (InvocationTargetException e) {
            throw new SerializationException(e);
        }
        return obj;
    }

    public boolean canPersist(Object obj) {
        return false;
    }
}

