/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.serial.persister;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import org.jboss.serial.exception.SerializationException;
import org.jboss.serial.objectmetamodel.ObjectDescription;
import org.jboss.serial.objectmetamodel.ObjectSubstitutionInterface;
import org.jboss.serial.persister.Persister;

public class ProxyPersister
implements Persister {
    private byte id;

    public byte getId() {
        return this.id;
    }

    public void setId(byte id) {
        this.id = id;
    }

    public void writeData(ObjectDescription descriptor, ObjectOutput output, Object obj, ObjectSubstitutionInterface substitution) throws IOException {
        InvocationHandler handler = Proxy.getInvocationHandler(obj);
        output.writeObject(handler);
        output.writeObject(obj.getClass());
    }

    public Object readData(ClassLoader loader, ObjectDescription descriptor, ObjectInput input, ObjectSubstitutionInterface substitution) throws IOException {
        try {
            Object handler = input.readObject();
            Class proxy = (Class)input.readObject();
            Constructor constructor = proxy.getConstructor(InvocationHandler.class);
            return constructor.newInstance(handler);
        }
        catch (ClassNotFoundException e) {
            throw new SerializationException(e);
        }
        catch (NoSuchMethodException e) {
            throw new SerializationException(e);
        }
        catch (IllegalAccessException e) {
            throw new SerializationException(e);
        }
        catch (InstantiationException e) {
            throw new SerializationException(e);
        }
        catch (InvocationTargetException e) {
            throw new SerializationException(e);
        }
    }

    public boolean canPersist(Object obj) {
        return false;
    }
}

