/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.serial.persister;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import java.util.Iterator;
import org.jboss.serial.classmetamodel.ClassMetaData;
import org.jboss.serial.classmetamodel.ClassMetadataField;
import org.jboss.serial.classmetamodel.FieldsManager;
import org.jboss.serial.exception.SerializationException;
import org.jboss.serial.objectmetamodel.FieldsContainer;
import org.jboss.serial.objectmetamodel.ObjectDescription;
import org.jboss.serial.objectmetamodel.ObjectSubstitutionInterface;
import org.jboss.serial.persister.Persister;

public class RegularObjectPersister
implements Persister {
    byte id;

    public byte getId() {
        return this.id;
    }

    public void setId(byte id) {
        this.id = id;
    }

    public void writeData(ObjectDescription descriptor, ObjectOutput output, Object obj, ObjectSubstitutionInterface substitution) throws IOException {
        ClassMetaData metaClass = descriptor.getMetaData();
        RegularObjectPersister.defaultWrite(output, obj, metaClass, substitution);
    }

    public static void defaultWrite(ObjectOutput output, Object obj, ClassMetaData metaClass, ObjectSubstitutionInterface substitution) throws IOException {
        FieldsContainer.writeNumberOfFields(output, metaClass.getFieldsSize());
        Iterator iter = metaClass.getFieldsIterator();
        ClassMetadataField field = null;
        try {
            while (iter.hasNext()) {
                field = (ClassMetadataField)iter.next();
                Object value = null;
                if (field.getField().getType().isPrimitive() && !field.getField().getType().isArray()) {
                    RegularObjectPersister.writeOnPrimitive(output, obj, field);
                    continue;
                }
                value = FieldsManager.getFieldsManager().getObject(obj, field);
                if (substitution != null) {
                    value = substitution.replaceObject(value);
                }
                output.writeUTF(field.getFieldName());
                output.writeByte(3);
                output.writeObject(value);
            }
        }
        catch (IllegalAccessException e) {
            throw new SerializationException("Error persisting " + field.getField().getDeclaringClass().getName() + " field=" + field.getFieldName(), e);
        }
    }

    private static void writeOnPrimitive(ObjectOutput out, Object obj, ClassMetadataField metaField) throws IllegalAccessException, IOException {
        out.writeUTF(metaField.getFieldName());
        Field field = metaField.getField();
        Class<?> clazz = field.getType();
        if (clazz == Integer.TYPE) {
            out.writeByte(6);
            out.writeInt(FieldsManager.getFieldsManager().getInt(obj, metaField));
        } else if (clazz == Byte.TYPE) {
            out.writeByte(9);
            out.writeByte(FieldsManager.getFieldsManager().getByte(obj, metaField));
        } else if (clazz == Long.TYPE) {
            out.writeByte(7);
            out.writeLong(FieldsManager.getFieldsManager().getLong(obj, metaField));
        } else if (clazz == Float.TYPE) {
            out.writeByte(10);
            out.writeFloat(FieldsManager.getFieldsManager().getFloat(obj, metaField));
        } else if (clazz == Double.TYPE) {
            out.writeByte(5);
            out.writeDouble(FieldsManager.getFieldsManager().getDouble(obj, metaField));
        } else if (clazz == Short.TYPE) {
            out.writeByte(8);
            out.writeShort(FieldsManager.getFieldsManager().getShort(obj, metaField));
        } else if (clazz == Character.TYPE) {
            out.writeByte(11);
            out.writeChar(field.getChar(obj));
        } else if (clazz == Boolean.TYPE) {
            out.writeByte(12);
            out.writeBoolean(field.getBoolean(obj));
        } else {
            throw new RuntimeException("Unexpected datatype " + clazz.getName());
        }
    }

    public Object readData(ClassLoader loader, ObjectDescription descriptor, ObjectInput input, ObjectSubstitutionInterface substitution) throws IOException {
        Object obj = descriptor.getMetaData().newInstance();
        descriptor.setCurrentValue(obj);
        return RegularObjectPersister.defaultRead(input, obj, descriptor.getMetaData(), substitution);
    }

    public static Object defaultRead(ObjectInput input, Object obj, ClassMetaData metaData, ObjectSubstitutionInterface substitution) throws IOException {
        ClassMetadataField field = null;
        try {
            int numberOfFields = FieldsContainer.readNumberOfFields(input);
            block13: for (int i = 0; i < numberOfFields; ++i) {
                String fieldName = input.readUTF();
                field = metaData.getField(fieldName);
                byte dataType = input.readByte();
                switch (dataType) {
                    case 6: {
                        FieldsManager.getFieldsManager().setInt(obj, field, input.readInt());
                        continue block13;
                    }
                    case 9: {
                        FieldsManager.getFieldsManager().setByte(obj, field, input.readByte());
                        continue block13;
                    }
                    case 7: {
                        FieldsManager.getFieldsManager().setLong(obj, field, input.readLong());
                        continue block13;
                    }
                    case 10: {
                        FieldsManager.getFieldsManager().setFloat(obj, field, input.readFloat());
                        continue block13;
                    }
                    case 5: {
                        FieldsManager.getFieldsManager().setDouble(obj, field, input.readDouble());
                        continue block13;
                    }
                    case 8: {
                        FieldsManager.getFieldsManager().setShort(obj, field, input.readShort());
                        continue block13;
                    }
                    case 11: {
                        FieldsManager.getFieldsManager().setCharacter(obj, field, input.readChar());
                        continue block13;
                    }
                    case 12: {
                        FieldsManager.getFieldsManager().setBoolean(obj, field, input.readBoolean());
                        continue block13;
                    }
                    case 3: {
                        Object objTmp = input.readObject();
                        FieldsManager.getFieldsManager().setObject(obj, field, objTmp);
                        continue block13;
                    }
                    default: {
                        throw new IOException("Invalid datatype " + dataType);
                    }
                }
            }
            return obj;
        }
        catch (ClassNotFoundException e) {
            throw new SerializationException("Error reading " + obj.getClass().getName(), e);
        }
    }

    public boolean canPersist(Object obj) {
        return false;
    }
}

