/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.serial.util;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class PartitionedWeakHashMap
extends AbstractMap {
    Map[] partitionMaps = new Map[10];
    private static final int PARTITION_SIZE = 10;

    public PartitionedWeakHashMap() {
        for (int i = 0; i < 10; ++i) {
            this.partitionMaps[i] = new WeakHashMap();
        }
    }

    public Map getMap(Object obj) {
        int hash = obj.hashCode();
        if (hash < 0) {
            hash *= -1;
        }
        return this.partitionMaps[hash %= 10];
    }

    public Set entrySet() {
        throw new RuntimeException("method not supported");
    }

    public void clear() {
        for (int i = 0; i < this.partitionMaps.length; ++i) {
            this.partitionMaps[i].clear();
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new RuntimeException("Clone not supported");
    }

    public boolean containsKey(Object key) {
        return this.getMap(key).containsKey(key);
    }

    public boolean containsValue(Object value) {
        throw new RuntimeException("method not supported");
    }

    public boolean equals(Object o) {
        throw new RuntimeException("method not supported");
    }

    public Object get(Object key) {
        return this.getMap(key).get(key);
    }

    public boolean isEmpty() {
        throw new RuntimeException("method not supported");
    }

    public Set keySet() {
        HashSet hashSet = new HashSet();
        for (int i = 0; i < 10; ++i) {
            hashSet.addAll(this.partitionMaps[i].keySet());
        }
        return hashSet;
    }

    public Object put(Object key, Object value) {
        return this.getMap(key).put(key, value);
    }

    public void putAll(Map elementsToAdd) {
        Iterator iter = elementsToAdd.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object key) {
        return this.getMap(key).remove(key);
    }

    public int size() {
        int size = 0;
        for (int i = 0; i < 10; ++i) {
            size += this.partitionMaps[i].size();
        }
        return size;
    }

    public Collection values() {
        ArrayList values = new ArrayList();
        for (int i = 0; i < 10; ++i) {
            values.addAll(this.partitionMaps[i].values());
        }
        return values;
    }
}

