/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice.metadata.jaxrpcmapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.webservice.metadata.jaxrpcmapping.ExceptionMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.JavaXmlTypeMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.PackageMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.ServiceEndpointInterfaceMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.ServiceInterfaceMapping;

public class JavaWsdlMapping
implements Serializable {
    private static final long serialVersionUID = -142671631068024054L;
    private static Logger log = Logger.getLogger(JavaWsdlMapping.class);
    private List packageMappings = new ArrayList();
    private List javaXmlTypeMappings = new ArrayList();
    private List exceptionMappings = new ArrayList();
    private List serviceInterfaceMappings = new ArrayList();
    private List serviceEndpointInterfaceMappings = new ArrayList();

    public PackageMapping[] getPackageMappings() {
        PackageMapping[] arr = new PackageMapping[this.packageMappings.size()];
        this.packageMappings.toArray(arr);
        return arr;
    }

    public JavaXmlTypeMapping[] getJavaXmlTypeMappings() {
        JavaXmlTypeMapping[] arr = new JavaXmlTypeMapping[this.javaXmlTypeMappings.size()];
        this.javaXmlTypeMappings.toArray(arr);
        return arr;
    }

    public ExceptionMapping[] getExceptionMappings() {
        ExceptionMapping[] arr = new ExceptionMapping[this.exceptionMappings.size()];
        this.exceptionMappings.toArray(arr);
        return arr;
    }

    public ServiceInterfaceMapping[] getServiceInterfaceMappings() {
        ServiceInterfaceMapping[] arr = new ServiceInterfaceMapping[this.serviceInterfaceMappings.size()];
        this.serviceInterfaceMappings.toArray(arr);
        return arr;
    }

    public ServiceEndpointInterfaceMapping[] getServiceEndpointInterfaceMappings() {
        ServiceEndpointInterfaceMapping[] arr = new ServiceEndpointInterfaceMapping[this.serviceEndpointInterfaceMappings.size()];
        this.serviceEndpointInterfaceMappings.toArray(arr);
        return arr;
    }

    public String getPackageNameForNamespaceURI(String nsURI) {
        String packageStr = null;
        for (int i = 0; packageStr == null && i < this.packageMappings.size(); ++i) {
            PackageMapping mapping = (PackageMapping)this.packageMappings.get(i);
            if (!mapping.getNamespaceURI().equals(nsURI)) continue;
            packageStr = mapping.getPackageType();
        }
        return packageStr;
    }

    public JavaXmlTypeMapping getTypeMappingForQName(QName xmlType) {
        JavaXmlTypeMapping typeMapping = null;
        if (xmlType != null) {
            JavaXmlTypeMapping mapping;
            Iterator it = this.javaXmlTypeMappings.iterator();
            while (typeMapping == null && it.hasNext()) {
                mapping = (JavaXmlTypeMapping)it.next();
                if (!xmlType.equals(mapping.getRootTypeQName())) continue;
                typeMapping = mapping;
            }
            it = this.javaXmlTypeMappings.iterator();
            while (typeMapping == null && it.hasNext()) {
                mapping = (JavaXmlTypeMapping)it.next();
                QName anonymousQName = mapping.getAnonymousTypeQName();
                if (anonymousQName == null || !xmlType.getNamespaceURI().equals(anonymousQName.getNamespaceURI())) continue;
                String localPart = xmlType.getLocalPart();
                if (anonymousQName.getLocalPart().equals(localPart)) {
                    typeMapping = mapping;
                }
                if (!anonymousQName.getLocalPart().equals(">" + localPart)) continue;
                typeMapping = mapping;
            }
            if (typeMapping == null) {
                log.warn("Cannot find jaxrpc-mapping for type: " + xmlType);
            }
        }
        return typeMapping;
    }

    public ExceptionMapping getExceptionMappingForMessageQName(QName wsdlMessage) {
        ExceptionMapping exMapping = null;
        if (wsdlMessage != null) {
            Iterator it = this.exceptionMappings.iterator();
            while (it.hasNext()) {
                ExceptionMapping mapping = (ExceptionMapping)it.next();
                if (!wsdlMessage.equals(mapping.getWsdlMessage())) continue;
                exMapping = mapping;
            }
        }
        return exMapping;
    }

    public QName getPortTypeQNameForServiceEndpointInterface(String seiName) {
        QName portTypeQName = null;
        ServiceEndpointInterfaceMapping[] seiMappings = this.getServiceEndpointInterfaceMappings();
        for (int i = 0; i < seiMappings.length; ++i) {
            ServiceEndpointInterfaceMapping aux = seiMappings[i];
            if (!aux.getServiceEndpointInterface().equals(seiName)) continue;
            portTypeQName = aux.getWsdlPortType();
        }
        return portTypeQName;
    }

    public ServiceEndpointInterfaceMapping getServiceEndpointInterfaceMappingByPortType(QName portType) {
        ServiceEndpointInterfaceMapping seiMapping = null;
        ServiceEndpointInterfaceMapping[] seiMappings = this.getServiceEndpointInterfaceMappings();
        for (int i = 0; seiMapping == null && i < seiMappings.length; ++i) {
            ServiceEndpointInterfaceMapping aux = seiMappings[i];
            if (!aux.getWsdlPortType().equals(portType)) continue;
            seiMapping = aux;
        }
        return seiMapping;
    }

    public ServiceEndpointInterfaceMapping getServiceEndpointInterfaceMapping(String seiName) {
        ServiceEndpointInterfaceMapping seiMapping = null;
        ServiceEndpointInterfaceMapping[] seiMappings = this.getServiceEndpointInterfaceMappings();
        for (int i = 0; seiMapping == null && i < seiMappings.length; ++i) {
            ServiceEndpointInterfaceMapping aux = seiMappings[i];
            if (!aux.getServiceEndpointInterface().equals(seiName)) continue;
            seiMapping = aux;
        }
        return seiMapping;
    }

    public String serialize() {
        StringBuffer sb = new StringBuffer();
        sb.append("<java-wsdl-mapping version='1.1' ").append("xmlns='http://java.sun.com/xml/ns/j2ee' ");
        sb.append("xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' ");
        sb.append("xsi:schemaLocation='http://java.sun.com/xml/ns/j2ee    ");
        sb.append("http://www.ibm.com/webservices/xsd/j2ee_jaxrpc_mapping_1_1.xsd'>");
        Iterator piter = this.packageMappings.iterator();
        while (piter != null && piter.hasNext()) {
            sb.append(((PackageMapping)piter.next()).serialize());
        }
        Iterator jxiter = this.javaXmlTypeMappings.iterator();
        while (jxiter.hasNext()) {
            sb.append(((JavaXmlTypeMapping)jxiter.next()).serialize());
        }
        int lenSIM = this.serviceInterfaceMappings.size();
        for (int i = 0; i < lenSIM; ++i) {
            ServiceInterfaceMapping sim = (ServiceInterfaceMapping)this.serviceInterfaceMappings.get(i);
            sb.append(sim.serialize());
            ServiceEndpointInterfaceMapping seim = (ServiceEndpointInterfaceMapping)this.serviceEndpointInterfaceMappings.get(i);
            sb.append(seim.serialize());
        }
        Iterator i = this.exceptionMappings.iterator();
        while (i.hasNext()) {
            sb.append(((ExceptionMapping)i.next()).serialize());
        }
        sb.append("</java-wsdl-mapping>");
        return sb.toString();
    }

    public void addPackageMapping(PackageMapping packageMapping) {
        this.packageMappings.add(packageMapping);
    }

    public void addJavaXmlTypeMappings(JavaXmlTypeMapping typeMapping) {
        this.javaXmlTypeMappings.add(typeMapping);
    }

    public void addExceptionMappings(ExceptionMapping exceptionMapping) {
        this.exceptionMappings.add(exceptionMapping);
    }

    public void addServiceInterfaceMappings(ServiceInterfaceMapping serviceInterfaceMapping) {
        this.serviceInterfaceMappings.add(serviceInterfaceMapping);
    }

    public void addServiceEndpointInterfaceMappings(ServiceEndpointInterfaceMapping serviceEndpointInterfaceMapping) {
        this.serviceEndpointInterfaceMappings.add(serviceEndpointInterfaceMapping);
    }

    public void removePackageMappingsByPackageType(String packageType) {
        for (int i = 0; i < this.packageMappings.size(); ++i) {
            PackageMapping mapping = (PackageMapping)this.packageMappings.get(i);
            if (!packageType.equals(mapping.getPackageType())) continue;
            this.packageMappings.remove(i--);
        }
    }
}

