/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ws.jaxme.xs.XSAttributable;
import org.apache.ws.jaxme.xs.XSAttribute;
import org.apache.ws.jaxme.xs.XSComplexType;
import org.apache.ws.jaxme.xs.XSElement;
import org.apache.ws.jaxme.xs.XSGroup;
import org.apache.ws.jaxme.xs.XSParser;
import org.apache.ws.jaxme.xs.XSParticle;
import org.apache.ws.jaxme.xs.XSSchema;
import org.apache.ws.jaxme.xs.XSSimpleType;
import org.apache.ws.jaxme.xs.XSType;
import org.apache.ws.jaxme.xs.xml.XsQName;
import org.jboss.logging.Logger;
import org.jboss.xb.binding.AbstractMarshaller;
import org.jboss.xb.binding.AttributesImpl;
import org.jboss.xb.binding.ContentWriter;
import org.jboss.xb.binding.DelegatingObjectModelProvider;
import org.jboss.xb.binding.GenericObjectModelProvider;
import org.jboss.xb.binding.ObjectModelProvider;
import org.jboss.xb.binding.SimpleTypeBindings;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XsMarshaller
extends AbstractMarshaller {
    private static final Logger log = Logger.getLogger(XsMarshaller.class);
    private AbstractMarshaller.Stack stack = new AbstractMarshaller.StackImpl();
    private GenericObjectModelProvider provider;
    private Object root;

    public void marshal(Reader schema, ObjectModelProvider provider, Object root, Writer writer) throws IOException, SAXException, ParserConfigurationException {
        InputSource source = new InputSource(schema);
        XSParser xsParser = new XSParser();
        xsParser.setValidating(false);
        XSSchema xsSchema = xsParser.parse(source);
        this.provider = provider instanceof GenericObjectModelProvider ? (GenericObjectModelProvider)provider : new DelegatingObjectModelProvider(provider);
        this.root = root;
        this.content.startDocument();
        if (this.rootQNames.isEmpty()) {
            XSElement[] elements = xsSchema.getElements();
            for (int i = 0; i < elements.length; ++i) {
                this.processElement(elements[i], 1, true);
            }
        } else {
            for (int i = 0; i < this.rootQNames.size(); ++i) {
                QName qName = (QName)this.rootQNames.get(i);
                XsQName rootName = new XsQName(qName.getNamespaceURI(), qName.getLocalPart(), qName.getPrefix());
                XSElement xsRoot = xsSchema.getElement(rootName);
                if (xsRoot == null) {
                    throw new IllegalStateException("Root element not found: " + rootName);
                }
                this.processElement(xsRoot, 1, true);
            }
        }
        this.content.endDocument();
        this.writeXmlVersion(writer);
        ContentWriter contentWriter = new ContentWriter(writer, this.propertyIsTrueOrNotSet("org.jboss.xml.binding.marshalling.indent"));
        this.content.handleContent(contentWriter);
    }

    public void addAttribute(String prefix, String localName, String type, String value) {
    }

    public void addAttribute(String namespaceUri, String prefix, String localName, String type, String value) {
        this.declareNamespace(prefix, namespaceUri);
        this.addAttribute(prefix, localName, type, value);
    }

    private void processElement(XSElement element, int maxOccurs, boolean declareNs) throws SAXException {
        XSType type = element.getType();
        this.processType(element, type, maxOccurs, declareNs);
    }

    private void processType(XSElement element, XSType type, int maxOccurs, boolean declareNs) throws SAXException {
        if (type.isSimple()) {
            this.processSimpleType(element, type, null, declareNs);
        } else {
            XSComplexType complexType = type.getComplexType();
            this.processComplexType(element, complexType, maxOccurs, declareNs);
        }
    }

    private void processSimpleType(XSElement element, XSType xsType, AttributesImpl attrs, boolean declareNs) throws SAXException {
        XsQName name;
        String prefix;
        String qName;
        XSSimpleType type = xsType.getSimpleType();
        if (type.isAtomic()) {
            if (log.isTraceEnabled()) {
                log.trace("atomic simple type");
            }
        } else if (type.isList()) {
            if (log.isTraceEnabled()) {
                log.trace("list of types");
            }
        } else if (type.isRestriction()) {
            if (log.isTraceEnabled()) {
                log.trace("restricted type");
            }
        } else if (type.isUnion()) {
            if (log.isTraceEnabled()) {
                log.trace("union of types");
            }
        } else {
            throw new IllegalStateException("Simple type is not atomic, list, restriction or union!");
        }
        String string = qName = (prefix = (name = element.getName()).getPrefix()) == null || prefix.length() == 0 ? name.getLocalName() : prefix + ':' + name.getLocalName();
        if (declareNs && this.prefixByUri.size() > 0) {
            if (attrs == null) {
                attrs = new AttributesImpl(this.prefixByUri.size());
            }
            this.declareNs(attrs);
        }
        if (this.stack.isEmpty()) {
            Object parent = this.provider.getRoot(this.root, null, name.getNamespaceURI(), name.getLocalName());
            if (parent == null) {
                return;
            }
            char[] ch = parent.toString().toCharArray();
            this.content.startElement(name.getNamespaceURI(), name.getLocalName(), qName, attrs);
            this.content.characters(ch, 0, ch.length);
            this.content.endElement(name.getNamespaceURI(), name.getLocalName(), qName);
        } else {
            Object parent = this.stack.peek();
            Object value = this.provider.getElementValue(parent, null, name.getNamespaceURI(), name.getLocalName());
            if (value != null) {
                XsQName typeName = xsType.getName();
                String marshalled = "http://www.w3.org/2001/XMLSchema".equals(typeName.getNamespaceURI()) ? SimpleTypeBindings.marshal(typeName.getLocalName(), value, null) : value.toString();
                char[] ch = marshalled.toCharArray();
                this.content.startElement(name.getNamespaceURI(), name.getLocalName(), qName, attrs);
                this.content.characters(ch, 0, ch.length);
                this.content.endElement(name.getNamespaceURI(), name.getLocalName(), qName);
            }
        }
    }

    private void processComplexType(XSElement element, XSComplexType type, int maxOccurs, boolean declareNs) throws SAXException {
        String qName;
        Object parent;
        XsQName xsName = element.getName();
        AttributesImpl attrs = null;
        if (declareNs && this.prefixByUri.size() > 0) {
            attrs = new AttributesImpl(this.prefixByUri.size());
            this.declareNs(attrs);
        }
        boolean popRoot = false;
        if (this.stack.isEmpty()) {
            parent = this.provider.getRoot(this.root, null, xsName.getNamespaceURI(), xsName.getLocalName());
            if (parent == null) {
                return;
            }
            if (type.getAttributes() != null) {
                if (attrs == null) {
                    attrs = this.provideAttributes(type.getAttributes(), parent);
                } else {
                    attrs.addAll(this.provideAttributes(type.getAttributes(), parent));
                }
            }
            String qName2 = xsName.getPrefix() == null ? xsName.getLocalName() : xsName.getPrefix() + ":" + xsName.getLocalName();
            this.content.startElement(xsName.getNamespaceURI(), xsName.getLocalName(), qName2, attrs);
            this.stack.push(parent);
            popRoot = true;
        } else {
            parent = this.stack.peek();
        }
        Object children = null;
        if (!popRoot) {
            children = this.provider.getChildren(parent, null, xsName.getNamespaceURI(), xsName.getLocalName());
        }
        if (children != null) {
            qName = null;
            if (maxOccurs == 1) {
                if (type.getAttributes() != null) {
                    if (attrs != null) {
                        attrs.addAll(this.provideAttributes(type.getAttributes(), parent));
                    } else {
                        attrs = this.provideAttributes(type.getAttributes(), parent);
                    }
                }
                qName = xsName.getPrefix() == null ? xsName.getLocalName() : xsName.getPrefix() + ":" + xsName.getLocalName();
                this.content.startElement(xsName.getNamespaceURI(), xsName.getLocalName(), qName, attrs);
            }
            this.handleChildren(element, type, children, maxOccurs);
            if (qName != null) {
                this.content.endElement(xsName.getNamespaceURI(), xsName.getLocalName(), qName);
            }
        } else if (type.hasSimpleContent()) {
            this.processSimpleType(element, type.getSimpleContent().getType(), null, declareNs);
        } else if (type.isEmpty()) {
            XsQName name = element.getName();
            Object value = this.provider.getElementValue(parent, null, name.getNamespaceURI(), name.getLocalName());
            if (Boolean.TRUE.equals(value)) {
                String prefix = name.getPrefix();
                String qName3 = prefix == null || prefix.length() == 0 ? name.getLocalName() : prefix + ':' + name.getLocalName();
                AttributesImpl ownAttrs = this.provideAttributes(type.getAttributes(), parent);
                if (declareNs && this.prefixByUri.size() > 0) {
                    if (ownAttrs == null) {
                        ownAttrs = new AttributesImpl(this.prefixByUri.size());
                    }
                    this.declareNs(ownAttrs);
                }
                this.content.startElement(name.getNamespaceURI(), name.getLocalName(), qName3, ownAttrs);
                this.content.endElement(name.getNamespaceURI(), name.getLocalName(), qName3);
            }
        } else {
            XSParticle particle = type.getParticle();
            if (particle != null) {
                this.processParticle(particle);
            }
        }
        if (popRoot) {
            this.stack.pop();
            qName = xsName.getPrefix() == null ? xsName.getLocalName() : xsName.getPrefix() + ":" + xsName.getLocalName();
            this.content.endElement(xsName.getNamespaceURI(), xsName.getLocalName(), qName);
        }
    }

    private void handleChildren(XSElement parent, XSComplexType type, Object children, int maxOccurs) throws SAXException {
        if (children != null) {
            if (children instanceof List) {
                this.handleChildrenList(parent, type, (List)children, maxOccurs);
            } else if (children instanceof Collection) {
                this.handleChildrenIterator(parent, type, ((Collection)children).iterator(), maxOccurs);
            } else if (children instanceof Iterator) {
                this.handleChildrenIterator(parent, type, (Iterator)children, maxOccurs);
            } else if (children.getClass().isArray()) {
                this.handleChildrenArray(parent, type, (Object[])children, maxOccurs);
            } else {
                this.handleChild(parent, type, children, false);
            }
        }
    }

    private AttributesImpl provideAttributes(XSAttributable[] xsAttrs, Object container) {
        AttributesImpl attrs = new AttributesImpl(xsAttrs.length);
        for (int i = 0; i < xsAttrs.length; ++i) {
            XSAttribute attr;
            XsQName attrQName;
            Object attrValue;
            XSAttributable attributable = xsAttrs[i];
            if (!(attributable instanceof XSAttribute) || (attrValue = this.provider.getAttributeValue(container, null, (attrQName = (attr = (XSAttribute)attributable).getName()).getNamespaceURI(), attrQName.getLocalName())) == null) continue;
            String prefix = attrQName.getPrefix();
            String qName = prefix == null || prefix.length() == 0 ? attrQName.getLocalName() : attrQName.getPrefix() + ':' + attrQName.getLocalName();
            attrs.add(attrQName.getNamespaceURI(), attrQName.getLocalName(), qName, attr.getType().getName().getLocalName(), attrValue.toString());
        }
        return attrs;
    }

    private void processParticle(XSParticle particle) throws SAXException {
        if (particle.isElement()) {
            XSElement element = particle.getElement();
            this.processElement(element, particle.getMaxOccurs(), false);
        } else if (particle.isGroup()) {
            XSGroup group = particle.getGroup();
            this.processGroup(group);
        } else if (particle.isWildcard()) {
            if (log.isTraceEnabled()) {
                log.trace("any");
            }
        } else {
            throw new IllegalStateException("Particle is not an element, group or wildcard!");
        }
    }

    private void processGroup(XSGroup group) throws SAXException {
        if (!(group.isSequence() || group.isChoice() || group.isAll())) {
            throw new IllegalStateException("Group is not a sequence, choice or all!");
        }
        XSParticle[] particles = group.getParticles();
        for (int i = 0; i < particles.length; ++i) {
            XSParticle particle = particles[i];
            this.processParticle(particle);
        }
    }

    private void handleChildrenList(XSElement parent, XSComplexType type, List children, int maxOccurs) throws SAXException {
        this.handleChildrenIterator(parent, type, children.iterator(), maxOccurs);
    }

    private void handleChildrenIterator(XSElement parent, XSComplexType type, Iterator children, int maxOccurs) throws SAXException {
        XsQName name = parent.getName();
        String qName = null;
        if (maxOccurs == -1 || maxOccurs > 0) {
            String string = qName = name.getPrefix() == null ? name.getLocalName() : name.getPrefix() + ':' + name.getLocalName();
        }
        while (children.hasNext()) {
            Object child = children.next();
            if (qName != null) {
                AttributesImpl attrs = null;
                if (type.getAttributes() != null) {
                    attrs = this.provideAttributes(type.getAttributes(), child);
                }
                this.content.startElement(name.getNamespaceURI(), name.getLocalName(), qName, attrs);
            }
            this.handleChild(parent, type, child, false);
            if (qName == null) continue;
            this.content.endElement(name.getNamespaceURI(), name.getLocalName(), qName);
        }
    }

    private void handleChildrenArray(XSElement parent, XSComplexType type, Object[] children, int maxOccurs) throws SAXException {
        this.handleChildrenIterator(parent, type, Arrays.asList(children).iterator(), maxOccurs);
    }

    private void handleChild(XSElement parent, XSComplexType type, Object child, boolean declareNs) throws SAXException {
        AttributesImpl ownAttrs;
        this.stack.push(child);
        XSAttributable[] xsAttrs = type.getAttributes();
        AttributesImpl attributesImpl = ownAttrs = xsAttrs == null ? null : this.provideAttributes(xsAttrs, child);
        if (type.hasSimpleContent()) {
            this.processSimpleType(parent, type.getSimpleContent().getType(), ownAttrs, declareNs);
        } else if (!type.isEmpty() && type.getParticle() != null) {
            this.processParticle(type.getParticle());
        } else {
            XSSchema xsSchema;
            AbstractMarshaller.ClassMapping mapping = this.getClassMapping(child.getClass());
            InputSource source = new InputSource(mapping.schemaUrl);
            XSParser xsParser = new XSParser();
            xsParser.setValidating(false);
            try {
                xsSchema = xsParser.parse(source);
            }
            catch (Exception e) {
                log.error(e);
                throw new IllegalStateException(e.getMessage());
            }
            XsQName rootName = new XsQName(mapping.elementName.getNamespaceURI(), mapping.elementName.getLocalPart());
            XSElement root = xsSchema.getElement(rootName);
            rootName = root.getName();
            String rootPrefix = rootName.getPrefix();
            String rootQName = rootPrefix == null || rootPrefix.length() == 0 ? rootName.getLocalName() : rootPrefix + ':' + rootName.getLocalName();
            AbstractMarshaller.Stack oldStack = this.stack;
            this.stack = new AbstractMarshaller.StackImpl();
            Object oldRoot = this.root;
            this.root = child;
            GenericObjectModelProvider oldProvider = this.provider;
            this.provider = mapping.provider;
            this.content.startElement(rootName.getNamespaceURI(), rootName.getLocalName(), rootQName, null);
            this.processElement(root, 1, false);
            this.content.endElement(rootName.getNamespaceURI(), rootName.getLocalName(), rootQName);
            this.root = oldRoot;
            this.stack = oldStack;
            this.provider = oldProvider;
        }
        this.stack.pop();
    }

    private void declareNs(AttributesImpl ownAttrs) {
        Iterator i = this.prefixByUri.entrySet().iterator();
        while (i.hasNext()) {
            String localName;
            Map.Entry entry = i.next();
            ownAttrs.add(null, localName, (localName = (String)entry.getValue()) == null ? "xmlns" : "xmlns:" + localName, null, (String)entry.getKey());
        }
    }
}

