/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.eventing;

import java.net.URI;
import javax.xml.namespace.QName;
import javax.xml.ws.addressing.AddressingProperties;
import javax.xml.ws.addressing.ReferenceParameters;
import org.jboss.util.xml.DOMUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HeaderUtil {
    public static final QName IDQN = new QName("http://schemas.xmlsoap.org/ws/2004/08/eventing", "Identifier", "ns1");

    public static String extractSubscriptionId(AddressingProperties addrProps) {
        String subscriptionId = null;
        ReferenceParameters refParams = addrProps.getReferenceParameters();
        if (refParams != null) {
            for (Object obj : refParams.getElements()) {
                Element el;
                QName qname;
                if (!(obj instanceof Element) || !(qname = DOMUtils.getElementQName((Element)(el = (Element)obj))).equals(IDQN)) continue;
                subscriptionId = DOMUtils.getTextContent((Node)el);
            }
        }
        return subscriptionId;
    }

    public static void appendSubscriptionId(AddressingProperties addrProps, URI subscriptionId) {
        ReferenceParameters refParams = addrProps.getReferenceParameters();
        refParams.addElement(HeaderUtil.getIdentifierElement(subscriptionId.toString()));
    }

    private static String getIdentifierElement(String subscriptionId) {
        String qualname = IDQN.getPrefix() + ":" + IDQN.getLocalPart();
        StringBuffer buffer = new StringBuffer("<" + qualname);
        buffer.append(" xmlns:" + IDQN.getPrefix() + "='" + IDQN.getNamespaceURI() + "'");
        buffer.append(">" + subscriptionId + "</" + qualname + ">");
        return buffer.toString();
    }
}

