/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.eventing.deployment;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.logging.Logger;
import org.jboss.util.xml.DOMWriter;
import org.jboss.ws.WSException;
import org.jboss.ws.eventing.deployment.EventSourceConfig;
import org.jboss.ws.eventing.deployment.EventSourceDesc;
import org.jboss.ws.eventing.mgmt.SubscriptionManagerMBean;
import org.jboss.ws.metadata.wsdl.WSDLDefinitionsFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DescriptorServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(DescriptorServlet.class);
    private final String WSDL_RESOURCE_PATH = "/WEB-INF/wsdl/jbwse.wsdl";
    private SubscriptionManagerMBean subscriptionManager = null;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequest(request, response);
    }

    protected void doRequest(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        EventSourceConfig config = this.getSubscriptionManager().getEventSourceConfig();
        String pathInfo = req.getPathInfo();
        String eventSourceName = DescriptorServlet.nameFromPathinfo(pathInfo);
        if (null == eventSourceName) {
            this.showEventSources(config, req, res);
            return;
        }
        log.debug((Object)("Request for eventsource " + eventSourceName));
        EventSourceDesc descriptor = this.descriptorByName(config, eventSourceName);
        if (null == descriptor) {
            throw new ServletException("Eventsource " + eventSourceName + " not registered");
        }
        if (req.getParameter("schema") != null || req.getParameter("SCHEMA") != null) {
            this.handleSchemaRequest(descriptor, req, res);
        } else if (req.getParameter("wsdl") != null || req.getParameter("WSDL") != null) {
            this.handleWSDLrequest(descriptor, req, res);
        } else {
            this.handleDefaultRequest(descriptor, req, res);
        }
    }

    private void showEventSources(EventSourceConfig config, HttpServletRequest req, HttpServletResponse res) throws IOException {
        String requestURI = req.getRequestURI();
        String requestURL = req.getRequestURL().toString();
        String hostPath = requestURL.substring(0, requestURL.indexOf(requestURI));
        requestURI = requestURI.endsWith("/") ? requestURI : requestURI + "/";
        StringBuffer sb = new StringBuffer();
        sb.append("<html><body>");
        sb.append("<h1>").append("Deployed event sources:").append("</h1><p>");
        sb.append("<ul>");
        for (EventSourceDesc desc : config.getDescriptors()) {
            sb.append("<li>").append(desc.getName()).append(": ");
            sb.append("<a href='").append(hostPath).append(requestURI).append(desc.getName() + "/").append("?wsdl'>").append("WSDL").append("</a>");
            sb.append(" / ");
            sb.append("<a href='").append(hostPath).append(requestURI).append(desc.getName() + "/").append("?schema'>").append("Schema").append("</a>");
        }
        sb.append("</ul>");
        sb.append("</body></html>");
        res.setContentType("text/html");
        PrintWriter pw = res.getWriter();
        pw.print(sb.toString());
        pw.close();
    }

    private void handleSchemaRequest(EventSourceDesc descriptor, HttpServletRequest req, HttpServletResponse res) throws ServletException {
        try {
            Element schemaEl = descriptor.getSchemaElement();
            res.setContentType("text/xml");
            PrintWriter pw = res.getWriter();
            pw.print(DOMWriter.printNode((Node)schemaEl, (boolean)true));
            pw.close();
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private EventSourceDesc descriptorByName(EventSourceConfig config, String eventSourceName) {
        EventSourceDesc desc = null;
        for (EventSourceDesc d : config.getDescriptors()) {
            if (!eventSourceName.equals(d.getName())) continue;
            desc = d;
            break;
        }
        return desc;
    }

    private void handleDefaultRequest(EventSourceDesc descriptor, HttpServletRequest req, HttpServletResponse res) throws IOException {
        String requestURI = req.getRequestURI();
        String requestURL = req.getRequestURL().toString();
        String hostPath = requestURL.substring(0, requestURL.indexOf(requestURI));
        StringBuffer sb = new StringBuffer();
        sb.append("<html><body>");
        sb.append("<h1>").append(descriptor.getName()).append("</h1><p>");
        sb.append("<a href='").append(hostPath).append(requestURI).append("?wsdl'>").append("Get the WSDL here").append("</a>");
        sb.append("</body></html>");
        res.setContentType("text/html");
        PrintWriter pw = res.getWriter();
        pw.print(sb.toString());
        pw.close();
    }

    private void handleWSDLrequest(EventSourceDesc descriptor, HttpServletRequest req, HttpServletResponse res) throws ServletException {
        String resourcePath = req.getParameter("resource");
        String requestURI = req.getRequestURI();
        String requestURL = req.getRequestURL().toString();
        String hostPath = requestURL.substring(0, requestURL.indexOf(requestURI));
        try {
            Document outputDocument = null;
            WSDLFactory wsdlFactory = WSDLFactory.newInstance();
            WSDLReader wsdlReader = wsdlFactory.newWSDLReader();
            if (resourcePath == null) {
                URL wsdlURL = this.getServletContext().getResource("/WEB-INF/wsdl/jbwse.wsdl");
                if (null == wsdlURL) {
                    throw new ServletException("Cannot obtain wsdl from: /WEB-INF/wsdl/jbwse.wsdl");
                }
                WSDLDefinitionsFactory.WSDLLocatorImpl locator = new WSDLDefinitionsFactory.WSDLLocatorImpl(wsdlURL);
                Definition wsdlDefinition = wsdlReader.readWSDL((WSDLLocator)locator);
                outputDocument = this.getWSDLDocument(wsdlDefinition);
                this.appendNotificationSchema(hostPath, requestURI, resourcePath, outputDocument);
                this.appendNotificationPortType(descriptor, hostPath, requestURI, resourcePath, outputDocument);
            } else {
                String schemaPath = "/WEB-INF/wsdl/" + resourcePath;
                URL resourceURL = this.getServletContext().getResource(schemaPath);
                if (resourceURL == null) {
                    throw new ServletException("Cannot obtain resource from: " + schemaPath);
                }
                DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                docFactory.setNamespaceAware(true);
                docFactory.setValidating(false);
                DocumentBuilder builder = docFactory.newDocumentBuilder();
                outputDocument = builder.parse(resourceURL.openStream());
            }
            this.modifyImportLocations(hostPath, requestURI, resourcePath, outputDocument.getDocumentElement());
            res.setContentType("text/xml");
            ServletOutputStream outs = res.getOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outs);
            new DOMWriter((Writer)writer).setPrettyprint(true).print((Node)outputDocument.getDocumentElement());
            outs.flush();
            outs.close();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void appendNotificationPortType(EventSourceDesc desc, String hostPath, String requestURI, String resourcePath, Document wsdlDoc) {
        Element portType = wsdlDoc.createElementNS("http://schemas.xmlsoap.org/wsdl/", "wsdl:portType");
        portType.setAttributeNS("http://schemas.xmlsoap.org/wsdl/", "name", desc.getName());
        portType.setAttributeNS("http://schemas.xmlsoap.org/ws/2004/08/eventing", "wse:EventSource", "true");
        Element operation = wsdlDoc.createElementNS("http://schemas.xmlsoap.org/wsdl/", "wsdl:operation");
        operation.setAttributeNS("http://schemas.xmlsoap.org/wsdl/", "name", desc.getName() + "Notification");
        Element output = wsdlDoc.createElementNS("http://schemas.xmlsoap.org/wsdl/", "wsdl:output");
        output.setAttributeNS("http://schemas.xmlsoap.org/wsdl/", "message", desc.getName() + "Msg");
        operation.appendChild(output);
        portType.appendChild(operation);
        DocumentFragment portTypeFragment = wsdlDoc.createDocumentFragment();
        portTypeFragment.appendChild(portType);
        Node definitions = wsdlDoc.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "definitions").item(0);
        definitions.appendChild(portTypeFragment);
        Element messageEl = wsdlDoc.createElementNS("http://schemas.xmlsoap.org/wsdl/", "wsdl:message");
        messageEl.setAttributeNS("http://schemas.xmlsoap.org/wsdl/", "name", desc.getName() + "Msg");
        String messageTNS = this.getNotificationTNS(desc.getSchemaElement());
        String messageElementName = this.getNotificationRootName(desc.getSchemaElement());
        Element partEl = wsdlDoc.createElementNS("http://schemas.xmlsoap.org/wsdl/", "wsdl:part");
        partEl.setAttributeNS("http://schemas.xmlsoap.org/wsdl/", "name", "body");
        partEl.setAttributeNS("http://schemas.xmlsoap.org/wsdl/", "element", "nsNotify:" + messageElementName);
        ((Element)definitions).setAttribute("xmlns:nsNotify", messageTNS);
        messageEl.appendChild(partEl);
        DocumentFragment messageFragment = wsdlDoc.createDocumentFragment();
        messageFragment.appendChild(messageEl);
        definitions.appendChild(messageFragment);
    }

    private void appendNotificationSchema(String hostPath, String requestURI, String resourcePath, Document doc) {
        Element includeEL = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:include");
        includeEL.setAttributeNS("http://www.w3.org/2001/XMLSchema", "schemaLocation", hostPath + requestURI + "?schema");
        Element schemaEl = doc.createElementNS("http://schemas.xmlsoap.org/ws/2004/08/eventing", "xs:schema");
        schemaEl.appendChild(includeEL);
        Node typesNode = doc.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "types").item(0);
        typesNode.appendChild(schemaEl);
    }

    private String getNotificationTNS(Element schema) {
        return schema.getAttributeNode("targetNamespace").getNodeValue();
    }

    private String getNotificationRootName(Element schema) {
        String name = null;
        NodeList nl = schema.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node childNode = nl.item(i);
            if (childNode.getNodeType() != 1) continue;
            Node namedItem = childNode.getAttributes().getNamedItem("name");
            name = namedItem.getNodeValue();
            break;
        }
        return name;
    }

    private SubscriptionManagerMBean getSubscriptionManager() {
        if (null == this.subscriptionManager) {
            try {
                ObjectName objectName = new ObjectName("jboss.ws.eventing:service=SubscriptionManager");
                MBeanServer server = MBeanServerFactory.findMBeanServer(null).get(0);
                this.subscriptionManager = MBeanServerInvocationHandler.newProxyInstance(server, objectName, SubscriptionManagerMBean.class, false);
            }
            catch (MalformedObjectNameException e) {
                throw new WSException("Failed to access subscription manager: " + e.getMessage());
            }
        }
        return this.subscriptionManager;
    }

    private void modifyImportLocations(String hostPath, String requestURI, String resourcePath, Element element) {
        NodeList nlist = element.getChildNodes();
        for (int i = 0; i < nlist.getLength(); ++i) {
            Node childNode = nlist.item(i);
            if (childNode.getNodeType() != 1) continue;
            Element childElement = (Element)childNode;
            String nodeName = childElement.getLocalName();
            if ("import".equals(nodeName) || "include".equals(nodeName)) {
                boolean isAbsolute;
                Attr locationAttr = childElement.getAttributeNode("schemaLocation");
                if (locationAttr == null) {
                    locationAttr = childElement.getAttributeNode("location");
                }
                if (locationAttr == null) continue;
                String orgLocation = locationAttr.getNodeValue();
                boolean bl = isAbsolute = orgLocation.startsWith("http://") || orgLocation.startsWith("https://");
                if (isAbsolute || orgLocation.startsWith(requestURI)) continue;
                String newResourcePath = orgLocation;
                if (resourcePath != null && resourcePath.indexOf("/") > 0) {
                    newResourcePath = resourcePath.substring(0, resourcePath.lastIndexOf("/") + 1) + orgLocation;
                }
                String newLocation = hostPath + requestURI + "?wsdl&resource=" + newResourcePath;
                locationAttr.setNodeValue(newLocation);
                log.debug((Object)("Mapping import from '" + orgLocation + "' to '" + newLocation + "'"));
                continue;
            }
            this.modifyImportLocations(hostPath, requestURI, resourcePath, childElement);
        }
    }

    private Document getWSDLDocument(Definition wsdlDefinition) {
        try {
            WSDLFactory factory = WSDLFactory.newInstance();
            WSDLWriter wsdlWriter = factory.newWSDLWriter();
            return wsdlWriter.getDocument(wsdlDefinition);
        }
        catch (WSDLException e) {
            throw new RuntimeException(e);
        }
    }

    private static String nameFromPathinfo(String pathInfo) {
        if (pathInfo != null) {
            if (pathInfo.startsWith("/")) {
                pathInfo = pathInfo.substring(1, pathInfo.length());
            }
            if (pathInfo.endsWith("/")) {
                pathInfo = pathInfo.substring(0, pathInfo.length() - 1);
            }
        }
        if (pathInfo != null) {
            pathInfo = pathInfo.equals("") ? null : pathInfo;
        }
        return pathInfo;
    }
}

