/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.eventing.deployment;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.ws.eventing.deployment.EventSourceDesc;
import org.jboss.ws.eventing.metadata.EventingEpMetaExt;
import org.jboss.ws.eventing.mgmt.SubscriptionManagerFactory;
import org.jboss.ws.metadata.ServerEndpointMetaData;
import org.jboss.ws.server.ServiceEndpointInfo;
import org.jboss.ws.server.ServiceEndpointLifecycle;

public class EventingEndpointLifecycle
implements ServiceEndpointLifecycle {
    private static final Logger log = Logger.getLogger(EventingEndpointLifecycle.class);
    private Map<ObjectName, EventSourceDesc> serviceEndpoints = new HashMap<ObjectName, EventSourceDesc>();
    private SubscriptionManagerFactory factory = SubscriptionManagerFactory.getInstance();

    public void createServiceEndpoint(ServiceEndpointInfo seInfo) throws Exception {
        ServerEndpointMetaData epMetaData = seInfo.getEndpointMetaData();
        EventingEpMetaExt ext = (EventingEpMetaExt)epMetaData.getExtension("http://schemas.xmlsoap.org/ws/2004/08/eventing");
        if (ext != null && ext.isEventSource() && !this.isRegistered(ext)) {
            EventSourceDesc desc = new EventSourceDesc(ext.getEventSourceNS(), ext.getNotificationSchema());
            ObjectName serviceID = seInfo.getServiceID();
            this.serviceEndpoints.put(serviceID, desc);
            this.factory.createSubscriptionManager().registerEventSource(this.serviceEndpoints.get(serviceID));
            log.debug((Object)("Create event source " + serviceID));
        }
    }

    public void startServiceEndpoint(ObjectName serviceID) throws Exception {
        if (this.serviceEndpoints.keySet().contains(serviceID)) {
            log.info((Object)("Start event source " + this.serviceEndpoints.get(serviceID).getName()));
        }
    }

    public void stopServiceEndpoint(ObjectName serviceID) throws Exception {
        if (this.serviceEndpoints.keySet().contains(serviceID)) {
            log.info((Object)("Stop event source " + this.serviceEndpoints.get(serviceID).getName()));
        }
    }

    public void destroyServiceEndpoint(ObjectName serviceID) throws Exception {
        if (this.serviceEndpoints.keySet().contains(serviceID)) {
            this.factory.createSubscriptionManager().removeEventSource(new URI(this.serviceEndpoints.get(serviceID).getName()));
            log.info((Object)("Remove event source " + this.serviceEndpoints.get(serviceID).getName()));
            this.serviceEndpoints.remove(serviceID);
        }
    }

    private boolean isRegistered(EventingEpMetaExt ext) {
        boolean isRegistered = false;
        for (EventSourceDesc desc : this.serviceEndpoints.values()) {
            if (!desc.getName().equals(ext.getEventSourceNS())) continue;
            isRegistered = true;
        }
        return isRegistered;
    }
}

