/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.eventing.mgmt;

import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import org.jboss.ws.WSException;
import org.jboss.ws.eventing.EventingConstants;
import org.jboss.ws.eventing.deployment.EventSourceDesc;
import org.jboss.ws.eventing.mgmt.EventSource;

public class EventingBuilder {
    private EventingBuilder() {
    }

    public static EventingBuilder createEventingBuilder() {
        return new EventingBuilder();
    }

    public EventSource newEventSource(EventSourceDesc desc) {
        URI eventSourceNS = this.newEventSourceURI(desc.getName());
        EventSource eventSource = new EventSource(desc.getName(), eventSourceNS, (String)desc.getSchema());
        eventSource.getSupportedFilterDialects().add(EventingConstants.getDefaultFilterDialect());
        return eventSource;
    }

    public URI newManagerEndpointURI() {
        try {
            return new URI("http://" + this.resolveAddress() + "/jbossws-eventing/subscribe");
        }
        catch (URISyntaxException e) {
            throw new WSException("Failed to create subscription manager endpoint URI: " + e.getMessage());
        }
    }

    public URI newEventSourceURI(String name) {
        try {
            return new URI(name);
        }
        catch (URISyntaxException e) {
            throw new WSException("Failed to create eventsource URI: " + e.getMessage());
        }
    }

    private String resolveAddress() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getHostAddress();
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Failed to resolve hostname: " + e.getMessage());
        }
    }
}

