/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.eventing.mgmt;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Date;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.apache.xpath.objects.XObject;
import org.jboss.logging.Logger;
import org.jboss.util.xml.DOMWriter;
import org.jboss.ws.eventing.EventingConstants;
import org.jboss.ws.eventing.element.EndpointReference;
import org.jboss.ws.eventing.mgmt.Filter;
import org.jboss.ws.soap.SOAPConnectionImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class Subscription {
    private static final Logger log = Logger.getLogger(Subscription.class);
    private final EndpointReference notifyTo;
    private final EndpointReference endTo;
    private Date expires;
    private final Filter filter;
    private final EndpointReference endpointReference;

    public Subscription(EndpointReference endpointReference, EndpointReference notifyTo, EndpointReference endTo, Date expires, Filter filter) {
        this.notifyTo = notifyTo;
        this.endTo = endTo;
        this.expires = expires;
        this.filter = filter;
        this.endpointReference = endpointReference;
    }

    public void notify(Element event) {
        log.debug((Object)(this.getIdentifier() + " dispatching " + event));
        try {
            String eventXML = DOMWriter.printNode((Node)event, (boolean)false);
            MessageFactory msgFactory = MessageFactory.newInstance();
            SOAPConnection con = SOAPConnectionFactory.newInstance().createConnection();
            StringBuffer sb = new StringBuffer();
            sb.append("<env:Envelope xmlns:env='http://www.w3.org/2003/05/soap-envelope' ");
            sb.append("xmlns:wse='").append("http://schemas.xmlsoap.org/ws/2004/08/eventing").append("' ");
            sb.append("xmlns:wsa='").append(EventingConstants.NS_ADDRESSING).append("'>");
            sb.append("<env:Header>");
            sb.append("<wsa:Action>").append(this.getNotificationAction()).append("</wsa:Action>");
            sb.append("<wsa:To>").append(this.notifyTo.getAddress().toString()).append("</wsa:To>");
            sb.append("</env:Header>");
            sb.append("<env:Body>");
            sb.append(eventXML);
            sb.append("</env:Body>");
            sb.append("</env:Envelope>");
            SOAPMessage reqMsg = msgFactory.createMessage(null, (InputStream)new ByteArrayInputStream(sb.toString().getBytes()));
            URL epURL = this.notifyTo.getAddress().toURL();
            ((SOAPConnectionImpl)con).call(reqMsg, epURL, true);
        }
        catch (Exception e) {
            log.error((Object)"Failed to send notification message", (Throwable)e);
        }
    }

    public boolean accepts(Element event) {
        boolean b = true;
        if (this.filter != null) {
            try {
                XObject o = XPathAPI.eval((Node)event, (String)this.filter.getExpression());
                b = o.bool();
            }
            catch (TransformerException e) {
                log.error((Object)"Failed to evalute xpath expression", (Throwable)e);
            }
        }
        return b;
    }

    public void end(String status) {
        if (null == this.endTo) {
            return;
        }
        log.debug((Object)("Ending subscription " + this.getIdentifier()));
        StringBuffer sb = new StringBuffer();
        sb.append("<env:Envelope xmlns:env='http://www.w3.org/2003/05/soap-envelope' ");
        sb.append("xmlns:wse='").append("http://schemas.xmlsoap.org/ws/2004/08/eventing").append("' ");
        sb.append("xmlns:wsa='").append(EventingConstants.NS_ADDRESSING).append("'>");
        sb.append("<env:Header>");
        sb.append("<wsa:Action>").append("http://schemas.xmlsoap.org/ws/2004/08/eventing/SubscriptionEnd").append("</wsa:Action>");
        sb.append("<wsa:To>").append(this.endTo.getAddress().toString()).append("</wsa:To>");
        sb.append("</env:Header>");
        sb.append("<env:Body>");
        sb.append("<wse:SubscriptionEnd>");
        sb.append("<wse:SubscriptionManager>");
        sb.append("<wsa:Address>");
        sb.append(this.endpointReference.getAddress().toString());
        sb.append("</wsa:Address>");
        sb.append("<wsa:ReferenceParameters>");
        sb.append("<wse:Identifier>");
        sb.append(this.getIdentifier().toString());
        sb.append("</wse:Identifier>");
        sb.append("</wsa:ReferenceParameters>");
        sb.append("</wse:SubscriptionManager>");
        sb.append("<wse:Status>").append(status).append("</wse:Status>");
        sb.append("<wse:Reason/>");
        sb.append("</wse:SubscriptionEnd>");
        sb.append("</env:Body>");
        sb.append("</env:Envelope>");
        try {
            MessageFactory msgFactory = MessageFactory.newInstance();
            SOAPConnection con = SOAPConnectionFactory.newInstance().createConnection();
            SOAPMessage reqMsg = msgFactory.createMessage(null, (InputStream)new ByteArrayInputStream(sb.toString().getBytes()));
            URL epURL = this.endTo.getAddress().toURL();
            ((SOAPConnectionImpl)con).call(reqMsg, epURL, true);
        }
        catch (Exception e) {
            log.warn((Object)"Failed to send subscription end message", (Throwable)e);
        }
    }

    private String getNotificationAction() {
        String identifier = this.getIdentifier().toString();
        return identifier.substring(0, identifier.indexOf(35)) + "/Notification";
    }

    public boolean isExpired() {
        return System.currentTimeMillis() > this.expires.getTime();
    }

    public EndpointReference getNotifyTo() {
        return this.notifyTo;
    }

    public EndpointReference getEndTo() {
        return this.endTo;
    }

    public Date getExpires() {
        return this.expires;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public EndpointReference getEndpointReference() {
        return this.endpointReference;
    }

    public URI getIdentifier() {
        return this.endpointReference.getReferenceParams().getIdentifier();
    }

    public void setExpires(Date expires) {
        this.expires = expires;
    }
}

