/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.jaxrpc;

import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.jaxrpc.SchemaGenerator;
import org.jboss.ws.jaxrpc.TypeMappingImpl;
import org.jboss.ws.jaxrpc.TypeMappingRegistryImpl;
import org.jboss.ws.jaxrpc.Use;
import org.jboss.ws.jaxrpc.encoding.JAXBDeserializerFactory;
import org.jboss.ws.jaxrpc.encoding.JAXBSerializerFactory;
import org.jboss.ws.jaxrpc.encoding.SOAPArrayDeserializerFactory;
import org.jboss.ws.jaxrpc.encoding.SOAPArraySerializerFactory;
import org.jboss.ws.metadata.EndpointMetaData;
import org.jboss.ws.metadata.ServiceMetaData;
import org.jboss.ws.metadata.TypeMappingMetaData;
import org.jboss.ws.metadata.UnifiedMetaData;
import org.jboss.ws.utils.JavaUtils;

public class ServiceDesc {
    private final Logger log = Logger.getLogger(ServiceDesc.class);
    private ServiceMetaData serviceMetaData;
    private TypeMappingRegistry tmRegistry = new TypeMappingRegistryImpl();
    private SchemaGenerator schemaGenerator;
    private boolean typeMappingInitialized;

    public ServiceDesc(QName serviceName) {
        UnifiedMetaData wsMetaData = new UnifiedMetaData();
        this.serviceMetaData = new ServiceMetaData(wsMetaData, serviceName);
        wsMetaData.addService(this.serviceMetaData);
    }

    public ServiceDesc(ServiceMetaData serviceMetaData) {
        this.serviceMetaData = serviceMetaData;
    }

    public TypeMappingImpl getTypeMapping() {
        Use encStyle = this.serviceMetaData.getEncodingStyle();
        TypeMappingImpl typeMapping = (TypeMappingImpl)this.tmRegistry.getTypeMapping(encStyle.toURI());
        if (typeMapping == null) {
            throw new WSException("No type mapping for encoding style: " + encStyle);
        }
        if (!this.typeMappingInitialized) {
            for (TypeMappingMetaData tmMetaData : this.serviceMetaData.getTypesMetaData().getTypeMappings()) {
                Class registeredType;
                String javaTypeName = tmMetaData.getJavaTypeName();
                QName xmlType = tmMetaData.getXmlType();
                if (xmlType == null || (registeredType = typeMapping.getJavaType(xmlType)) != null && registeredType.getName().equals(javaTypeName)) continue;
                ClassLoader classLoader = this.serviceMetaData.getUnifiedMetaData().getClassLoader();
                if (classLoader == null) {
                    throw new WSException("ClassLoader not available in meta data");
                }
                try {
                    Class javaType = JavaUtils.loadJavaType(javaTypeName, classLoader);
                    if (JavaUtils.isPrimitive(javaTypeName)) {
                        javaType = JavaUtils.getWrapperType(javaType);
                    }
                    if (encStyle == Use.ENCODED && javaType.isArray()) {
                        typeMapping.register(javaType, xmlType, new SOAPArraySerializerFactory(), new SOAPArrayDeserializerFactory());
                        continue;
                    }
                    typeMapping.register(javaType, xmlType, new JAXBSerializerFactory(), new JAXBDeserializerFactory());
                }
                catch (ClassNotFoundException e) {
                    this.log.warn((Object)("Cannot load class for type: " + xmlType + "," + javaTypeName));
                }
            }
            this.typeMappingInitialized = true;
        }
        return typeMapping;
    }

    public QName getServiceName() {
        return this.serviceMetaData.getName();
    }

    public ServiceMetaData getServiceMetaData() {
        return this.serviceMetaData;
    }

    public EndpointMetaData getEndpointDesc(QName epName) {
        EndpointMetaData epMetaData = this.serviceMetaData.getEndpoint(epName);
        return epMetaData;
    }

    public SchemaGenerator getSchemaGenerator() {
        if (this.schemaGenerator == null) {
            this.schemaGenerator = new SchemaGenerator();
        }
        return this.schemaGenerator;
    }

    public void assertTargetNamespace(String targetNS) {
        if (this.serviceMetaData != null && !this.serviceMetaData.getName().getNamespaceURI().equals(targetNS)) {
            throw new WSException("Requested namespace is not WSDL target namespace: " + targetNS);
        }
    }
}

