/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.jaxrpc.encoding;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import org.apache.xerces.xs.XSModel;
import org.jboss.logging.Logger;
import org.jboss.webservice.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.ws.binding.BindingException;
import org.jboss.ws.jaxrpc.encoding.DeserializerSupport;
import org.jboss.ws.jaxrpc.encoding.SerializationContextImpl;

public class JAXBDeserializer
extends DeserializerSupport {
    private static final Logger log = Logger.getLogger(JAXBDeserializer.class);
    private Unmarshaller jaxbUnmarshaller;

    public JAXBDeserializer() throws BindingException {
        try {
            JAXBContext context = JAXBContext.newInstance((String)"org.jboss.jaxb");
            this.jaxbUnmarshaller = context.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new BindingException(e);
        }
    }

    public Object deserialize(QName xmlName, QName xmlType, String val, SerializationContextImpl serContext) throws BindingException {
        log.debug((Object)("deserialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + "]"));
        try {
            XSModel model = serContext.getXsModel();
            JavaWsdlMapping jaxrpcMapping = serContext.getJavaWsdlMapping();
            this.jaxbUnmarshaller.setProperty("org.jboss.jaxb.xsd.xsmodel", (Object)model);
            this.jaxbUnmarshaller.setProperty("org.jboss.jaxb.root.qname", (Object)xmlName);
            this.jaxbUnmarshaller.setProperty("org.jboss.jaxb.type.qname", (Object)xmlType);
            this.jaxbUnmarshaller.setProperty("org.jboss.jaxb.java.mapping", (Object)jaxrpcMapping);
            ByteArrayInputStream ins = new ByteArrayInputStream(val.getBytes());
            Object value = this.jaxbUnmarshaller.unmarshal((InputStream)ins);
            log.debug((Object)("deserialized: " + (value != null ? value.getClass().getName() : null)));
            return value;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BindingException(e);
        }
    }
}

