/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata;

import javax.jws.WebService;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.ejb3.Ejb3ModuleMBean;
import org.jboss.ejb3.stateless.StatelessContainer;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanProxy;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.AnnotationsMetaDataBuilder;
import org.jboss.ws.metadata.ServerEndpointMetaData;
import org.jboss.ws.metadata.UnifiedMetaData;

public class AnnotationsMetaDataBuilderEJB3
extends AnnotationsMetaDataBuilder {
    private final Logger log = Logger.getLogger(AnnotationsMetaDataBuilderEJB3.class);
    protected Class annotatedClass;

    public UnifiedMetaData buildMetaData(DeploymentInfo di) {
        this.log.debug((Object)("START buildMetaData: [canonicalName=" + di.getCanonicalName() + "]"));
        try {
            UnifiedMetaData wsMetaData = new UnifiedMetaData();
            wsMetaData.setResourceLoader(this.resourceLoader);
            wsMetaData.setClassLoader(this.classLoader);
            if (di.annotationsCl == null) {
                throw new WSException("Annotations class loader not initialized");
            }
            MBeanServer server = MBeanServerLocator.locateJBoss();
            Ejb3ModuleMBean ejb3Module = (Ejb3ModuleMBean)MBeanProxy.get(Ejb3ModuleMBean.class, (ObjectName)di.deployedObject, (MBeanServer)server);
            if (ejb3Module == null) {
                throw new WSException("Cannot obtain EJB3 module: " + di.deployedObject);
            }
            for (Object manager : ejb3Module.getContainers().values()) {
                StatelessContainer container;
                String ejbClassName;
                Class<?> beanClass;
                if (!(manager instanceof StatelessContainer) || !(beanClass = di.annotationsCl.loadClass(ejbClassName = (container = (StatelessContainer)manager).getBeanClassName())).isAnnotationPresent(WebService.class)) continue;
                Class<?> annotatedClass = beanClass;
                WebService anWebService = beanClass.getAnnotation(WebService.class);
                String seiName = annotatedClass.getName();
                if (anWebService.endpointInterface().length() > 0 && (anWebService = (annotatedClass = di.annotationsCl.loadClass(seiName = anWebService.endpointInterface())).getAnnotation(WebService.class)) == null) {
                    throw new WSException("Interface does not have a @WebService annotation: " + seiName);
                }
                String ejbLink = container.getEjbName();
                ServerEndpointMetaData sepMetaData = this.setupEndpointFromAnnotations(wsMetaData, di, annotatedClass, ejbLink);
                sepMetaData.setEndpointImplementationName(beanClass.getName());
                sepMetaData.setServiceEndpointInterfaceName(seiName);
            }
            this.log.debug((Object)("END buildMetaData: " + wsMetaData));
            return wsMetaData;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new WSException("Cannot build meta data: " + ex.getMessage(), ex);
        }
    }
}

