/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.webservice.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.ServiceEndpointInterfaceMapping;
import org.jboss.webservice.metadata.serviceref.HandlerMetaData;
import org.jboss.webservice.metadata.serviceref.ServiceRefMetaData;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.ClientEndpointMetaData;
import org.jboss.ws.metadata.EndpointMetaData;
import org.jboss.ws.metadata.JSR109MetaDataBuilder;
import org.jboss.ws.metadata.ServiceMetaData;
import org.jboss.ws.metadata.UnifiedMetaData;
import org.jboss.ws.metadata.wsdl.NCName;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
import org.jboss.ws.metadata.wsse.WSSecurityConfigurationFactory;

public class JSR109ClientMetaDataBuilder
extends JSR109MetaDataBuilder {
    private final Logger log = Logger.getLogger(JSR109ClientMetaDataBuilder.class);

    public ServiceMetaData buildMetaData(QName serviceQName, URL wsdlURL, URL mappingURL, URL securityURL, ServiceRefMetaData serviceRefMetaData) {
        this.log.debug((Object)("START buildMetaData: [service=" + serviceQName + ",wsdl=" + wsdlURL + ",mapping=" + mappingURL + ",security=" + securityURL + "]"));
        try {
            UnifiedMetaData wsMetaData = new UnifiedMetaData();
            wsMetaData.setResourceLoader(this.resourceLoader);
            wsMetaData.setClassLoader(this.classLoader);
            ServiceMetaData serviceMetaData = new ServiceMetaData(wsMetaData, serviceQName);
            wsMetaData.addService(serviceMetaData);
            serviceMetaData.setWsdlFile(wsdlURL.toExternalForm());
            WSDLDefinitions wsdlDefinitions = serviceMetaData.getWsdlDefinitions();
            JavaWsdlMapping javaWsdlMapping = null;
            if (mappingURL != null) {
                serviceMetaData.setJaxrpcMappingFile(mappingURL.toExternalForm());
                javaWsdlMapping = serviceMetaData.getJavaWsdlMapping();
            }
            if (securityURL != null) {
                WSSecurityConfiguration securityConfig = WSSecurityConfigurationFactory.newInstance().parse(securityURL);
                serviceMetaData.setSecurityConfiguration(securityConfig);
                this.setupSecurity(securityConfig);
            }
            this.buildMetaDataInternal(serviceMetaData, wsdlDefinitions, javaWsdlMapping, serviceRefMetaData);
            this.log.debug((Object)("END buildMetaData: " + serviceMetaData));
            return serviceMetaData;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new WSException("Cannot build meta data: " + ex.getMessage(), ex);
        }
    }

    public ServiceMetaData buildMetaData(QName serviceQName, URL wsdlURL, JavaWsdlMapping javaWsdlMapping, WSSecurityConfiguration securityConfig, ServiceRefMetaData serviceRefMetaData) {
        this.log.debug((Object)("START buildMetaData: [service=" + serviceQName + "]"));
        try {
            UnifiedMetaData wsMetaData = new UnifiedMetaData();
            wsMetaData.setResourceLoader(this.resourceLoader);
            wsMetaData.setClassLoader(this.classLoader);
            ServiceMetaData serviceMetaData = new ServiceMetaData(wsMetaData, serviceQName);
            wsMetaData.addService(serviceMetaData);
            serviceMetaData.setWsdlFile(wsdlURL.toExternalForm());
            WSDLDefinitions wsdlDefinitions = serviceMetaData.getWsdlDefinitions();
            URL mappingURL = null;
            if (javaWsdlMapping != null) {
                mappingURL = new URL("http://www.jboss.org/jbossws/dummy-mapping-url");
                wsMetaData.addMappingDefinition(mappingURL.toExternalForm(), javaWsdlMapping);
                serviceMetaData.setJaxrpcMappingFile(mappingURL.toExternalForm());
            }
            if (securityConfig != null) {
                serviceMetaData.setSecurityConfiguration(securityConfig);
                this.setupSecurity(securityConfig);
            }
            this.buildMetaDataInternal(serviceMetaData, wsdlDefinitions, javaWsdlMapping, serviceRefMetaData);
            this.log.debug((Object)("END buildMetaData: " + serviceMetaData));
            return serviceMetaData;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new WSException("Cannot build meta data: " + ex.getMessage(), ex);
        }
    }

    private void buildMetaDataInternal(ServiceMetaData serviceMetaData, WSDLDefinitions wsdlDefinitions, JavaWsdlMapping javaWsdlMapping, ServiceRefMetaData serviceRefMetaData) throws IOException {
        QName serviceQName = serviceMetaData.getName();
        WSDLService wsdlService = null;
        if (serviceQName == null) {
            if (wsdlDefinitions.getServices().length != 1) {
                throw new IllegalArgumentException("Expected a single service element");
            }
            wsdlService = wsdlDefinitions.getServices()[0];
            serviceMetaData.setName(wsdlService.getQName());
        } else {
            wsdlService = wsdlDefinitions.getService(new NCName(serviceQName.getLocalPart()));
        }
        if (wsdlService == null) {
            throw new IllegalArgumentException("Cannot obtain wsdl service: " + serviceQName);
        }
        this.setupTypesMetaData(serviceMetaData);
        for (WSDLEndpoint wsdlEndpoint : wsdlService.getEndpoints()) {
            QName epName = wsdlEndpoint.getQName();
            ClientEndpointMetaData epMetaData = new ClientEndpointMetaData(serviceMetaData, epName);
            epMetaData.setEndpointAddress(wsdlEndpoint.getAddress());
            serviceMetaData.addEndpoint(epMetaData);
            if (serviceRefMetaData != null) {
                String configFile;
                String configName = serviceRefMetaData.getConfigName();
                if (configName != null) {
                    epMetaData.setConfigName(configName);
                }
                if ((configFile = serviceRefMetaData.getConfigFile()) != null) {
                    epMetaData.setConfigFile(configFile);
                }
                epMetaData.getClientConfig();
            }
            this.initEndpointEncodingStyle(epMetaData);
            ServiceEndpointInterfaceMapping seiMapping = null;
            if (javaWsdlMapping != null) {
                QName portType = wsdlEndpoint.getInterface().getQName();
                seiMapping = javaWsdlMapping.getServiceEndpointInterfaceMappingByPortType(portType);
                if (seiMapping != null) {
                    epMetaData.setServiceEndpointInterfaceName(seiMapping.getServiceEndpointInterface());
                } else {
                    this.log.warn((Object)("Cannot obtain the SEI mapping for: " + portType));
                }
            }
            this.processEpMetaDataExtensions(epMetaData, wsdlDefinitions);
            this.setupOperationsFromWSDL(epMetaData, wsdlEndpoint, seiMapping);
            this.setupHandlers(serviceRefMetaData, epName, epMetaData);
        }
    }

    private void setupHandlers(ServiceRefMetaData serviceRefMetaData, QName epName, EndpointMetaData epMetaData) {
        if (serviceRefMetaData != null) {
            for (HandlerMetaData handlerMetaData : serviceRefMetaData.getHandlers()) {
                List<String> portNames = Arrays.asList(handlerMetaData.getPortNames());
                if (portNames.size() != 0 && !portNames.contains(epName.getLocalPart())) continue;
                epMetaData.addHandler(handlerMetaData);
            }
        }
    }

    private void setupSecurity(WSSecurityConfiguration securityConfig) {
        URL location;
        if (securityConfig.getKeyStoreFile() != null && (location = this.resourceLoader.getResource(securityConfig.getKeyStoreFile())) != null) {
            securityConfig.setKeyStoreURL(location);
        }
        if (securityConfig.getTrustStoreFile() != null && (location = this.resourceLoader.getResource(securityConfig.getTrustStoreFile())) != null) {
            securityConfig.setTrustStoreURL(location);
        }
    }
}

