/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.wsdl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.util.xml.DOMUtils;
import org.jboss.util.xml.DOMWriter;
import org.jboss.ws.Constants;
import org.jboss.ws.WSException;
import org.jboss.ws.jaxrpc.Style;
import org.jboss.ws.metadata.wsdl.NCName;
import org.jboss.ws.metadata.wsdl.WSDLBinding;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperation;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
import org.jboss.ws.metadata.wsdl.WSDLInterface;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceFault;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperation;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationInput;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutfault;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutput;
import org.jboss.ws.metadata.wsdl.WSDLProperty;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.ws.metadata.wsdl.WSDLTypes;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
import org.jboss.ws.metadata.wsdl.xsd.SchemaUtils;
import org.jboss.ws.tools.JavaToXSD;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class WSDL11Reader {
    private static final Logger log = Logger.getLogger(WSDL11Reader.class);
    private WSDLDefinitions destWsdl;
    private Map<String, QName> messagePartToElementMap = new HashMap<String, QName>();
    private Map<String, URL> schemaLocationsMap = new HashMap<String, URL>();

    public WSDLDefinitions processDefinition(Definition srcWsdl, URL wsdlLoc) throws IOException {
        log.trace((Object)("processDefinition: " + wsdlLoc));
        this.destWsdl = new WSDLDefinitions();
        this.destWsdl.setWsdlOneOneDefinition(srcWsdl);
        this.destWsdl.setWsdlNamespace("http://schemas.xmlsoap.org/wsdl/");
        this.processNamespaces(srcWsdl);
        this.processTypes(srcWsdl, wsdlLoc);
        this.processServices(srcWsdl);
        if (this.getAllDefinedBindings(srcWsdl).size() != this.destWsdl.getBindings().length) {
            this.processUnreachableBindings(srcWsdl);
        }
        return this.destWsdl;
    }

    private void processUnreachableBindings(Definition srcWsdl) {
        log.trace((Object)"processUnreachableBindings");
        for (Binding srcBinding : this.getAllDefinedBindings(srcWsdl).values()) {
            QName srcQName = srcBinding.getQName();
            WSDLBinding destBinding = this.destWsdl.getBinding(new NCName(srcQName));
            if (destBinding != null) continue;
            this.processBinding(srcWsdl, srcBinding);
        }
    }

    private void processNamespaces(Definition srcWsdl) {
        String targetNS = srcWsdl.getTargetNamespace();
        this.destWsdl.setTargetNamespace(targetNS);
        Map nsMap = srcWsdl.getNamespaces();
        for (Map.Entry entry : nsMap.entrySet()) {
            String prefix = (String)entry.getKey();
            String nsURI = (String)entry.getValue();
            this.destWsdl.registerNamespaceURI(nsURI, prefix);
        }
    }

    private void processTypes(Definition srcWsdl, URL wsdlLoc) throws IOException {
        log.trace((Object)("BEGIN processTypes: " + wsdlLoc));
        WSDLTypes destTypes = this.destWsdl.getWsdlTypes();
        Types srcTypes = srcWsdl.getTypes();
        if (srcTypes != null && srcTypes.getExtensibilityElements().size() > 0) {
            List extElements = srcTypes.getExtensibilityElements();
            int len = extElements.size();
            for (int i = 0; i < len; ++i) {
                Element domElement;
                ExtensibilityElement extElement = (ExtensibilityElement)extElements.get(i);
                if (extElement instanceof Schema) {
                    domElement = ((Schema)extElement).getElement();
                } else if (extElement instanceof UnknownExtensibilityElement) {
                    domElement = ((UnknownExtensibilityElement)extElement).getElement();
                } else {
                    throw new WSException("Unsupported extensibility element: " + extElement);
                }
                Element domElementClone = (Element)domElement.cloneNode(true);
                this.copyParentNamespaceDeclarations(domElementClone, domElement);
                String localname = domElementClone.getLocalName();
                try {
                    if ("import".equals(localname)) {
                        this.processSchemaImport(destTypes, wsdlLoc, domElementClone);
                        continue;
                    }
                    if ("schema".equals(localname)) {
                        this.processSchemaInclude(destTypes, wsdlLoc, domElementClone);
                        continue;
                    }
                    throw new IllegalArgumentException("Unsuported schema element: " + localname);
                }
                catch (IOException e) {
                    throw new WSException("Cannot extract schema definition", e);
                }
            }
            if (len > 0) {
                Collection<URL> col = this.schemaLocationsMap.values();
                JavaToXSD jxsd = new JavaToXSD();
                ArrayList<String> strlist = new ArrayList<String>();
                for (URL uri : col) {
                    strlist.add(uri.toExternalForm());
                }
                JBossXSModel xsmodel = jxsd.parseSchema(this.schemaLocationsMap);
                destTypes.addSchemaModel(this.destWsdl.getTargetNamespace(), xsmodel);
            }
        } else {
            log.trace((Object)"Empty wsdl types element, processing imports");
            for (List srcImports : srcWsdl.getImports().values()) {
                for (Import srcImport : srcImports) {
                    Definition impDefinition = srcImport.getDefinition();
                    String impLoc = impDefinition.getDocumentBaseURI();
                    this.processTypes(impDefinition, new URL(impLoc));
                }
            }
        }
        log.trace((Object)("END processTypes: " + wsdlLoc + "\n" + destTypes));
    }

    private void copyParentNamespaceDeclarations(Element destElement, Element srcElement) {
        for (Node parent = srcElement.getParentNode(); parent != null; parent = parent.getParentNode()) {
            if (!parent.hasAttributes()) continue;
            NamedNodeMap attributes = parent.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Attr attr = (Attr)attributes.item(i);
                String name = attr.getName();
                String value = attr.getValue();
                if (!name.startsWith("xmlns:") || destElement.hasAttribute(name)) continue;
                destElement.setAttribute(name, value);
            }
        }
    }

    private void processSchemaImport(WSDLTypes types, URL wsdlLoc, Element importEl) throws IOException {
        Element rootElement;
        if (wsdlLoc == null) {
            throw new IllegalArgumentException("Cannot process import, parent location not set");
        }
        log.trace((Object)("processSchemaImport: " + wsdlLoc));
        String location = importEl.getAttribute("schemaLocation");
        if (location == null || location.length() == 0) {
            throw new IllegalArgumentException("schemaLocation is null for xsd:import");
        }
        URL locationURL = this.getLocationURL(wsdlLoc, location);
        URL newloc = this.processSchemaInclude(types, locationURL, rootElement = DOMUtils.parse((InputStream)locationURL.openStream()));
        if (newloc != null) {
            importEl.setAttribute("schemaLocation", newloc.toExternalForm());
        }
    }

    private URL processSchemaInclude(WSDLTypes types, URL wsdlLoc, Element schemaEl) throws IOException {
        if (wsdlLoc == null) {
            throw new IllegalArgumentException("Cannot process iclude, parent location not set");
        }
        File tmpFile = null;
        if (wsdlLoc == null) {
            throw new IllegalArgumentException("Cannot process include, parent location not set");
        }
        log.trace((Object)("processSchemaInclude: " + wsdlLoc));
        String schemaPrefix = schemaEl.getPrefix();
        String importTag = schemaPrefix == null ? "import" : schemaPrefix + ":import";
        Element importElement = schemaEl.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", importTag);
        importElement.setAttribute("namespace", "http://schemas.xmlsoap.org/soap/encoding/");
        schemaEl.insertBefore(importElement, DOMUtils.getFirstChildElement((Node)schemaEl));
        Iterator it = DOMUtils.getChildElements((Node)schemaEl, (QName)new QName("http://www.w3.org/2001/XMLSchema", "include"));
        while (it.hasNext()) {
            Element rootElement;
            Element includeEl = (Element)it.next();
            String location = includeEl.getAttribute("schemaLocation");
            if (location == null || location.length() == 0) {
                throw new IllegalArgumentException("schemaLocation is null for xsd:include");
            }
            URL locationURL = this.getLocationURL(wsdlLoc, location);
            URL newloc = this.processSchemaInclude(types, locationURL, rootElement = DOMUtils.parse((InputStream)locationURL.openStream()));
            if (newloc == null) continue;
            includeEl.setAttribute("schemaLocation", newloc.toExternalForm());
        }
        String targetNS = schemaEl.getAttribute("targetNamespace");
        if (targetNS.length() > 0) {
            log.trace((Object)("processSchemaInclude: [targetNS=" + targetNS + ",parentURL=" + wsdlLoc + "]"));
            tmpFile = SchemaUtils.getSchemaTempFile(targetNS);
            tmpFile.deleteOnExit();
            FileWriter fwrite = new FileWriter(tmpFile);
            new DOMWriter((Writer)fwrite).setPrettyprint(true).print((Node)schemaEl);
            fwrite.close();
            this.schemaLocationsMap.put(targetNS, tmpFile.toURL());
        }
        if (targetNS.length() == 0) {
            log.trace((Object)("Schema element without target namespace in: " + wsdlLoc));
        }
        this.handleSchemaImports(schemaEl, wsdlLoc);
        return tmpFile != null ? tmpFile.toURL() : null;
    }

    private void handleSchemaImports(Element schemaEl, URL wsdlLoc) throws MalformedURLException {
        if (wsdlLoc == null) {
            throw new IllegalArgumentException("Cannot process import, parent location not set");
        }
        Iterator it = DOMUtils.getChildElements((Node)schemaEl, (QName)new QName("http://www.w3.org/2001/XMLSchema", "import"));
        while (it.hasNext()) {
            Element includeEl = (Element)it.next();
            String schemaLocation = includeEl.getAttribute("schemaLocation");
            String namespace = includeEl.getAttribute("namespace");
            log.trace((Object)("handleSchemaImport: [namespace=" + namespace + ",schemaLocation=" + schemaLocation + "]"));
            if (namespace.length() > 0 && schemaLocation.length() > 0) {
                URL currLoc = this.getLocationURL(wsdlLoc, schemaLocation);
                this.schemaLocationsMap.put(namespace, currLoc);
                continue;
            }
            log.trace((Object)("Skip schema import: [namespace=" + namespace + ",schemaLocation=" + schemaLocation + "]"));
        }
    }

    private URL getLocationURL(URL parentURL, String location) throws MalformedURLException {
        log.trace((Object)("getLocationURL: [location=" + location + ",parent=" + parentURL + "]"));
        URL locationURL = null;
        try {
            locationURL = new URL(location);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (locationURL == null) {
            String parentProtocol = parentURL.getProtocol();
            if (parentProtocol.equals("file") && !location.startsWith("/")) {
                String path = parentURL.toExternalForm();
                path = path.substring(0, path.lastIndexOf("/"));
                locationURL = new URL(path + "/" + location);
            } else if (parentProtocol.startsWith("http") && location.startsWith("/")) {
                String path = parentProtocol + "://" + parentURL.getHost() + ":" + parentURL.getPort();
                locationURL = new URL(path + location);
            } else if (parentProtocol.equals("jar") && !location.startsWith("/")) {
                String path = parentURL.toExternalForm();
                path = path.substring(0, path.lastIndexOf("/"));
                locationURL = new URL(path + "/" + location);
            } else {
                throw new WSException("Unsupported schemaLocation: " + location);
            }
        }
        log.trace((Object)("Modified schemaLocation: " + locationURL));
        return locationURL;
    }

    private void processPortType(Definition srcWsdl, PortType srcPortType) {
        log.trace((Object)("processPortType: " + srcPortType.getQName()));
        QName qname = srcPortType.getQName();
        NCName ncName = new NCName(qname);
        if (this.destWsdl.getInterface(ncName) == null) {
            WSDLInterface destInterface = new WSDLInterface(this.destWsdl);
            destInterface.setName(ncName);
            destInterface.setQName(qname);
            QName eventSourceProp = (QName)srcPortType.getExtensionAttribute(Constants.WSDL_ATTRIBUTE_WSE_EVENTSOURCE);
            if (eventSourceProp != null && eventSourceProp.getLocalPart().equals(Boolean.TRUE.toString())) {
                destInterface.addProperty(new WSDLProperty("http://www.jboss.org/jbossws/wse/isEventSource", eventSourceProp.getLocalPart()));
            }
            this.destWsdl.addInterface(destInterface);
            this.processPortTypeOperations(srcWsdl, destInterface, srcPortType);
        }
    }

    private void processPortTypeOperations(Definition srcWsdl, WSDLInterface destInterface, PortType srcPortType) {
        for (Operation srcOperation : srcPortType.getOperations()) {
            WSDLInterfaceOperation destOperation = new WSDLInterfaceOperation(destInterface);
            destOperation.setName(new NCName(srcOperation.getName()));
            this.processOperationInput(srcWsdl, srcOperation, destOperation, srcPortType);
            this.processOperationOutput(srcWsdl, srcOperation, destOperation, srcPortType);
            this.processOperationFaults(srcOperation, destOperation, destInterface);
            destInterface.addOperation(destOperation);
        }
    }

    private void processOperationInput(Definition srcWsdl, Operation srcOperation, WSDLInterfaceOperation destOperation, PortType srcPortType) {
        Input srcInput = srcOperation.getInput();
        if (srcInput != null) {
            Message srcMessage = srcInput.getMessage();
            log.trace((Object)("processOperationInput: " + srcMessage.getQName()));
            QName wsaAction = (QName)srcInput.getExtensionAttribute(Constants.WSDL_ATTRIBUTE_WSA_ACTION);
            if (wsaAction != null) {
                destOperation.addProperty(new WSDLProperty("http://www.jboss.org/jbossws/wsa/actionIn", wsaAction.getLocalPart()));
            }
            List paramOrder = srcOperation.getParameterOrdering();
            Iterator itMessageParts = srcMessage.getOrderedParts(paramOrder).iterator();
            while (itMessageParts.hasNext()) {
                WSDLInterfaceOperationInput destInput = new WSDLInterfaceOperationInput(destOperation);
                Part srcPart = (Part)itMessageParts.next();
                QName elementName = this.messagePartToElementName(srcWsdl, srcPortType, srcOperation, srcMessage, srcPart);
                destInput.setElement(elementName);
                destInput.addProperty(new WSDLProperty("http://www.jboss.org/jbossws/messagename", srcMessage.getQName().getLocalPart()));
                destOperation.addProperty(new WSDLProperty("http://www.jboss.org/jbossws/messagename/in", srcMessage.getQName().getLocalPart()));
                WSDLProperty wsdlProperty = new WSDLProperty("http://www.jboss.org/jbossws/partname", srcPart.getName());
                destInput.addProperty(wsdlProperty);
                QName xmlType = srcPart.getTypeName();
                if (xmlType != null) {
                    xmlType = this.destWsdl.registerQName(xmlType);
                    String value = xmlType.getPrefix() + ":" + xmlType.getLocalPart();
                    wsdlProperty = new WSDLProperty("http://www.jboss.org/jbossws/rpc/xmltype", value);
                    destInput.addProperty(wsdlProperty);
                }
                destOperation.addInput(destInput);
            }
        }
    }

    private void processOperationOutput(Definition srcWsdl, Operation srcOperation, WSDLInterfaceOperation destOperation, PortType srcPortType) {
        Output srcOutput = srcOperation.getOutput();
        if (srcOutput != null) {
            Message srcMessage = srcOutput.getMessage();
            log.trace((Object)("processOperationOutput: " + srcMessage.getQName()));
            destOperation.setPattern("http://www.w3.org/2004/08/wsdl/in-out");
            QName wsaAction = (QName)srcOutput.getExtensionAttribute(Constants.WSDL_ATTRIBUTE_WSA_ACTION);
            if (wsaAction != null) {
                destOperation.addProperty(new WSDLProperty("http://www.jboss.org/jbossws/wsa/actionOut", wsaAction.getLocalPart()));
            }
            Iterator itMessageParts = srcMessage.getOrderedParts(null).iterator();
            while (itMessageParts.hasNext()) {
                WSDLInterfaceOperationOutput destOutput = new WSDLInterfaceOperationOutput(destOperation);
                Part srcPart = (Part)itMessageParts.next();
                QName elementName = this.messagePartToElementName(srcWsdl, srcPortType, srcOperation, srcMessage, srcPart);
                destOutput.setElement(elementName);
                destOutput.addProperty(new WSDLProperty("http://www.jboss.org/jbossws/messagename", srcMessage.getQName().getLocalPart()));
                destOperation.addProperty(new WSDLProperty("http://www.jboss.org/jbossws/messagename/out", srcMessage.getQName().getLocalPart()));
                WSDLProperty wsdlProperty = new WSDLProperty("http://www.jboss.org/jbossws/partname", srcPart.getName());
                destOutput.addProperty(wsdlProperty);
                QName xmlType = srcPart.getTypeName();
                if (xmlType != null) {
                    xmlType = this.destWsdl.registerQName(xmlType);
                    String value = xmlType.getPrefix() + ":" + xmlType.getLocalPart();
                    wsdlProperty = new WSDLProperty("http://www.jboss.org/jbossws/rpc/xmltype", value);
                    destOutput.addProperty(wsdlProperty);
                }
                destOperation.addOutput(destOutput);
            }
        } else {
            destOperation.setPattern("http://www.w3.org/2004/08/wsdl/in-only");
        }
    }

    private void processOperationFaults(Operation srcOperation, WSDLInterfaceOperation destOperation, WSDLInterface destInterface) {
        Map faults = srcOperation.getFaults();
        for (Fault srcFault : faults.values()) {
            this.processOperationFault(destOperation, destInterface, srcFault);
        }
    }

    private void processOperationFault(WSDLInterfaceOperation destOperation, WSDLInterface destInterface, Fault srcFault) {
        String faultName = srcFault.getName();
        log.trace((Object)("processOperationFault: " + faultName));
        WSDLInterfaceFault destFault = new WSDLInterfaceFault(destInterface);
        NCName ncName = new NCName(faultName);
        destFault.setName(ncName);
        Message message = srcFault.getMessage();
        QName messageName = message.getQName();
        Map partsMap = message.getParts();
        if (partsMap.size() != 1) {
            throw new WSException("Unsupported number of fault parts in message " + messageName);
        }
        Part part = (Part)partsMap.values().iterator().next();
        QName xmlName = part.getElementName();
        QName xmlType = part.getTypeName();
        destFault.setXmlType(xmlType);
        if (xmlName != null) {
            destFault.setXmlName(xmlName);
        } else {
            destFault.setXmlName(messageName);
            log.warn((Object)("Unsupported fault message part in message: " + messageName));
        }
        WSDLInterfaceFault prevFault = destInterface.getFault(ncName);
        if (prevFault != null && !prevFault.getName().equals(ncName)) {
            throw new WSException("Fault name must be unique: " + faultName);
        }
        destInterface.addFault(destFault);
        WSDLInterfaceOperationOutfault opOutFault = new WSDLInterfaceOperationOutfault(destOperation);
        opOutFault.setRef(new QName(this.destWsdl.getTargetNamespace(), faultName));
        destOperation.addOutfault(opOutFault);
    }

    private QName messagePartToElementName(Definition srcWsdl, PortType srcPortType, Operation srcOperation, Message srcMessage, Part srcPart) {
        QName xmlName = srcPart.getElementName();
        if (xmlName != null) {
            xmlName = this.destWsdl.registerQName(xmlName);
        }
        if (xmlName == null) {
            BindingOutput srcBindingOutput;
            xmlName = new QName(srcPart.getName());
            Binding srcBinding = null;
            Iterator itBindings = this.getAllDefinedBindings(srcWsdl).values().iterator();
            while (srcBinding == null && itBindings.hasNext()) {
                Binding binding = (Binding)itBindings.next();
                if (!binding.getPortType().equals(srcPortType)) continue;
                srcBinding = binding;
            }
            if (srcBinding == null) {
                throw new WSException("Cannot find binding for: " + srcPortType.getQName());
            }
            String srcOperationName = srcOperation.getName();
            BindingOperation srcBindingOperation = srcBinding.getBindingOperation(srcOperationName, null, null);
            if (srcBindingOperation == null) {
                throw new WSException("Cannot find binding operation for: " + srcOperationName);
            }
            BindingInput srcBindingInput = srcBindingOperation.getBindingInput();
            if (srcBindingInput != null) {
                for (ExtensibilityElement extEl : srcBindingInput.getExtensibilityElements()) {
                    String namespaceURI;
                    if (!(extEl instanceof SOAPHeader)) continue;
                    SOAPHeader header = (SOAPHeader)extEl;
                    QName messageQName = header.getMessage();
                    String partName = header.getPart();
                    if (!messageQName.equals(srcMessage.getQName()) || !partName.equals(srcPart.getName()) || (namespaceURI = header.getNamespaceURI()) == null) continue;
                    xmlName = new QName(namespaceURI, partName);
                    xmlName = this.destWsdl.registerQName(xmlName);
                }
            }
            if ((srcBindingOutput = srcBindingOperation.getBindingOutput()) != null) {
                for (ExtensibilityElement extEl : srcBindingOutput.getExtensibilityElements()) {
                    String namespaceURI;
                    if (!(extEl instanceof SOAPHeader)) continue;
                    SOAPHeader header = (SOAPHeader)extEl;
                    QName messageQName = header.getMessage();
                    String partName = header.getPart();
                    if (!messageQName.equals(srcMessage.getQName()) || !partName.equals(srcPart.getName()) || (namespaceURI = header.getNamespaceURI()) == null) continue;
                    xmlName = new QName(namespaceURI, partName);
                    xmlName = this.destWsdl.registerQName(xmlName);
                }
            }
        }
        String key = srcMessage.getQName() + "->" + srcPart.getName();
        this.messagePartToElementMap.put(key, xmlName);
        return xmlName;
    }

    private void processBinding(Definition srcWsdl, Binding srcBinding) {
        QName srcBindingQName = srcBinding.getQName();
        log.trace((Object)("processBinding: " + srcBindingQName));
        NCName ncName = new NCName(srcBindingQName);
        if (this.destWsdl.getBinding(ncName) == null) {
            PortType srcPortType = srcBinding.getPortType();
            this.processPortType(srcWsdl, srcPortType);
            WSDLBinding destBinding = new WSDLBinding(this.destWsdl);
            destBinding.setQName(srcBindingQName);
            destBinding.setName(ncName);
            destBinding.setInterfaceName(srcPortType.getQName());
            String bindingStyle = Style.getDefaultStyle().toString();
            List extList = srcBinding.getExtensibilityElements();
            for (int i = 0; i < extList.size(); ++i) {
                Object extElement = extList.get(i);
                if (!(extElement instanceof SOAPBinding)) continue;
                SOAPBinding soapBinding = (SOAPBinding)extElement;
                bindingStyle = soapBinding.getStyle();
            }
            this.destWsdl.addBinding(destBinding);
            this.processBindingOperations(destBinding, srcBinding, bindingStyle);
        }
    }

    private Map getAllDefinedBindings(Definition srcWsdl) {
        LinkedHashMap<QName, Binding> retMap = new LinkedHashMap<QName, Binding>();
        Map srcBindings = srcWsdl.getBindings();
        for (Binding srcBinding : srcBindings.values()) {
            retMap.put(srcBinding.getQName(), srcBinding);
        }
        for (Service srcService : srcWsdl.getServices().values()) {
            for (Port srcPort : srcService.getPorts().values()) {
                Binding srcBinding = srcPort.getBinding();
                retMap.put(srcBinding.getQName(), srcBinding);
            }
        }
        return retMap;
    }

    private void processBindingOperations(WSDLBinding destBinding, Binding srcBinding, String bindingStyle) {
        for (BindingOperation srcBindingOperation : srcBinding.getBindingOperations()) {
            this.processBindingOperation(destBinding, bindingStyle, srcBindingOperation);
        }
    }

    private void processBindingOperation(WSDLBinding destBinding, String bindingStyle, BindingOperation srcBindingOperation) {
        BindingOutput srcBindingOutput;
        String srcBindingName = srcBindingOperation.getName();
        log.trace((Object)("processBindingOperation: " + srcBindingName));
        WSDLInterface destInterface = destBinding.getInterface();
        String namespaceURI = destInterface.getQName().getNamespaceURI();
        WSDLBindingOperation destBindingOperation = new WSDLBindingOperation(destBinding);
        QName refQName = new QName(namespaceURI, srcBindingName);
        destBindingOperation.setRef(refQName);
        destBinding.addOperation(destBindingOperation);
        String opName = srcBindingName;
        WSDLInterfaceOperation destIntfOperation = destInterface.getOperation(new NCName(opName));
        String operationStyle = null;
        for (ExtensibilityElement extEl : srcBindingOperation.getExtensibilityElements()) {
            if (!(extEl instanceof SOAPOperation)) continue;
            SOAPOperation soapOp = (SOAPOperation)extEl;
            destBindingOperation.setSOAPAction(soapOp.getSoapActionURI());
            operationStyle = soapOp.getStyle();
        }
        destIntfOperation.setStyle(operationStyle != null ? operationStyle : bindingStyle);
        BindingInput srcBindingInput = srcBindingOperation.getBindingInput();
        if (srcBindingInput != null) {
            this.processBindingInput(destBindingOperation, destIntfOperation, srcBindingInput);
        }
        if ((srcBindingOutput = srcBindingOperation.getBindingOutput()) != null) {
            this.processBindingOutput(destBindingOperation, destIntfOperation, srcBindingOutput);
        }
    }

    private void processBindingInput(WSDLBindingOperation destBindingOperation, WSDLInterfaceOperation destIntfOperation, BindingInput srcBindingInput) {
        log.trace((Object)"processBindingInput");
        for (ExtensibilityElement extEl : srcBindingInput.getExtensibilityElements()) {
            if (extEl instanceof SOAPBody) {
                SOAPBody body = (SOAPBody)extEl;
                this.processEncodingStyle(body, destBindingOperation);
                continue;
            }
            if (extEl instanceof SOAPHeader) {
                SOAPHeader header = (SOAPHeader)extEl;
                QName messageQName = header.getMessage();
                String partName = header.getPart();
                String key = messageQName + "->" + partName;
                QName elementName = this.messagePartToElementMap.get(key);
                if (elementName == null) continue;
                WSDLInterfaceOperationInput destIntfInput = destIntfOperation.getInput(elementName);
                if (destIntfInput == null) {
                    throw new WSException("Cannot find interface input for element: " + elementName);
                }
                WSDLProperty wsdlProperty = new WSDLProperty("http://www.w3.org/2004/08/wsdl/feature/AD/data", false, null, null);
                destIntfInput.addProperty(wsdlProperty);
                continue;
            }
            if (!(extEl instanceof MIMEMultipartRelated)) continue;
            MIMEMultipartRelated related = (MIMEMultipartRelated)extEl;
            for (MIMEPart part : related.getMIMEParts()) {
                Iterator j = part.getExtensibilityElements().iterator();
                String name = null;
                String types = null;
                while (j.hasNext()) {
                    ExtensibilityElement inner = (ExtensibilityElement)j.next();
                    if (!(inner instanceof MIMEContent)) continue;
                    MIMEContent content = (MIMEContent)inner;
                    name = content.getPart();
                    if (types == null) {
                        types = content.getType();
                        continue;
                    }
                    types = types + "," + content.getType();
                }
                if (name == null) continue;
                QName elementName = new QName(name);
                WSDLInterfaceOperationInput destIntfInput = destIntfOperation.getInput(elementName);
                if (destIntfInput == null) {
                    throw new WSException("Cannot find interface input for element: " + elementName);
                }
                WSDLProperty wsdlProperty = new WSDLProperty("http://www.jboss.org/jbossws/attachment/mimetype", false, types, null);
                destIntfInput.addProperty(wsdlProperty);
            }
        }
    }

    private void processBindingOutput(WSDLBindingOperation destBindingOperation, WSDLInterfaceOperation destIntfOperation, BindingOutput srcBindingOutput) {
        log.trace((Object)"processBindingOutput");
        for (ExtensibilityElement extEl : srcBindingOutput.getExtensibilityElements()) {
            if (extEl instanceof SOAPBody) {
                SOAPBody body = (SOAPBody)extEl;
                this.processEncodingStyle(body, destBindingOperation);
                continue;
            }
            if (extEl instanceof SOAPHeader) {
                SOAPHeader header = (SOAPHeader)extEl;
                QName messageQName = header.getMessage();
                String partName = header.getPart();
                String key = messageQName + "->" + partName;
                QName elementName = this.messagePartToElementMap.get(key);
                if (elementName == null) continue;
                WSDLInterfaceOperationOutput destIntfOutput = destIntfOperation.getOutput(elementName);
                if (destIntfOutput == null) {
                    throw new WSException("Cannot find interface output for element: " + elementName);
                }
                WSDLProperty wsdlProperty = new WSDLProperty("http://www.w3.org/2004/08/wsdl/feature/AD/data", false, null, null);
                destIntfOutput.addProperty(wsdlProperty);
                continue;
            }
            if (!(extEl instanceof MIMEMultipartRelated)) continue;
            MIMEMultipartRelated related = (MIMEMultipartRelated)extEl;
            for (MIMEPart part : related.getMIMEParts()) {
                Iterator j = part.getExtensibilityElements().iterator();
                String name = null;
                String types = null;
                while (j.hasNext()) {
                    ExtensibilityElement inner = (ExtensibilityElement)j.next();
                    if (!(inner instanceof MIMEContent)) continue;
                    MIMEContent content = (MIMEContent)inner;
                    name = content.getPart();
                    if (types == null) {
                        types = content.getType();
                        continue;
                    }
                    types = types + "," + content.getType();
                }
                if (name == null) continue;
                QName elementName = new QName(name);
                WSDLInterfaceOperationOutput destIntfOutput = destIntfOperation.getOutput(elementName);
                if (destIntfOutput == null) {
                    throw new WSException("Cannot find interface output for element: " + elementName);
                }
                WSDLProperty wsdlProperty = new WSDLProperty("http://www.jboss.org/jbossws/attachment/mimetype", false, types, null);
                destIntfOutput.addProperty(wsdlProperty);
            }
        }
    }

    private void processEncodingStyle(SOAPBody body, WSDLBindingOperation destBindingOperation) {
        log.trace((Object)"processEncodingStyle");
        List encStyleList = body.getEncodingStyles();
        if (encStyleList != null) {
            if (encStyleList.size() > 1) {
                log.warn((Object)("Multiple encoding styles not supported: " + encStyleList));
            }
            if (encStyleList.size() > 0) {
                String setStyle;
                String encStyle = (String)encStyleList.get(0);
                if (!encStyle.equals(setStyle = destBindingOperation.getEncodingStyle())) {
                    log.warn((Object)("Encoding style '" + encStyle + "' not supported for: " + destBindingOperation.getRef()));
                }
                destBindingOperation.setEncodingStyle(encStyle);
            }
        }
    }

    private void processServices(Definition srcWsdl) {
        log.trace((Object)("BEGIN processServices: " + srcWsdl.getDocumentBaseURI()));
        if (srcWsdl.getServices().size() > 0) {
            for (Service srcService : srcWsdl.getServices().values()) {
                QName qname = srcService.getQName();
                WSDLService destService = new WSDLService(this.destWsdl);
                destService.setName(new NCName(qname));
                destService.setQName(qname);
                this.destWsdl.addService(destService);
                this.processPorts(srcWsdl, destService, srcService);
            }
        } else {
            log.trace((Object)"Empty wsdl services, processing imports");
            for (List srcImports : srcWsdl.getImports().values()) {
                for (Import srcImport : srcImports) {
                    Definition importDefinition = srcImport.getDefinition();
                    this.processServices(importDefinition);
                }
            }
        }
        log.trace((Object)("END processServices: " + srcWsdl.getDocumentBaseURI()));
    }

    private void processPorts(Definition srcWsdl, WSDLService destService, Service srcService) {
        for (Port srcPort : srcService.getPorts().values()) {
            this.processPort(srcWsdl, destService, srcPort);
        }
    }

    private void processPort(Definition srcWsdl, WSDLService destService, Port srcPort) {
        log.trace((Object)("processPort: " + srcPort.getName()));
        Binding srcBinding = srcPort.getBinding();
        WSDLEndpoint destEndpoint = new WSDLEndpoint(destService);
        destEndpoint.setName(new NCName(srcPort.getName()));
        destEndpoint.setBinding(srcBinding.getQName());
        destEndpoint.setAddress(this.getEndPointAddress(srcPort));
        destService.addEndpoint(destEndpoint);
        this.processBinding(srcWsdl, srcBinding);
    }

    private String getEndPointAddress(Port srcPort) {
        String retstr = null;
        for (ExtensibilityElement extElement : srcPort.getExtensibilityElements()) {
            if (!(extElement instanceof SOAPAddress)) continue;
            SOAPAddress addr = (SOAPAddress)extElement;
            retstr = addr.getLocationURI();
        }
        return retstr;
    }
}

