/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.wsdl;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;
import org.jboss.util.xml.DOMUtils;
import org.jboss.util.xml.DOMWriter;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.wsdl.NCName;
import org.jboss.ws.metadata.wsdl.WSDLBinding;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperation;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperationInput;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperationOutput;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
import org.jboss.ws.metadata.wsdl.WSDLInterface;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperation;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationInput;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutfault;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutput;
import org.jboss.ws.metadata.wsdl.WSDLProperty;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.ws.metadata.wsdl.WSDLWriter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSDL11Writer
extends WSDLWriter {
    private String wsdlStyle = "RPC/Literal";
    private HashSet<String> writtenFaultMessages = new HashSet();

    public WSDL11Writer(WSDLDefinitions wsdl) {
        super(wsdl);
    }

    public void write(Writer writer) throws IOException {
        this.write(writer, null);
    }

    public void write(Writer writer, String charset) throws IOException {
        if (this.wsdl.getWsdlOneOneDefinition() != null) {
            Definition wsdlDefinition = this.wsdl.getWsdlOneOneDefinition();
            try {
                WSDLFactory wsdlFactory = WSDLFactory.newInstance();
                javax.wsdl.xml.WSDLWriter wsdlWriter = wsdlFactory.newWSDLWriter();
                wsdlWriter.writeWSDL(wsdlDefinition, writer);
            }
            catch (WSDLException e) {
                this.logException((Exception)((Object)e));
                throw new IOException(e.toString());
            }
        } else {
            StringBuilder buffer = new StringBuilder();
            this.wsdlStyle = this.utils.getWSDLStyle(this.wsdl);
            this.writtenFaultMessages.clear();
            this.appendDefinitions(buffer);
            this.appendTypes(buffer);
            this.appendMessages(buffer);
            this.appendPortTypes(buffer);
            this.appendBindings(buffer);
            this.appendServices(buffer);
            buffer.append("</definitions>");
            Element element = DOMUtils.parse((String)buffer.toString());
            if (charset != null) {
                writer.write("<?xml version=\"1.0\" encoding=\"" + charset + "\"?>\n");
            }
            new DOMWriter(writer).setPrettyprint(true).print((Node)element);
        }
    }

    protected void appendMessages(StringBuilder buffer) {
        WSDLInterface[] interfaces = this.wsdl.getInterfaces();
        int len = interfaces != null ? interfaces.length : 0;
        for (int i = 0; i < len; ++i) {
            WSDLInterface intf = interfaces[i];
            WSDLInterfaceOperation[] operations = intf.getSortedOperations();
            int lenOps = operations.length;
            for (int j = 0; j < lenOps; ++j) {
                this.appendMessage(buffer, operations[j]);
                this.appendMessagesForExceptions(buffer, operations[j]);
            }
        }
    }

    private void appendMessage(StringBuilder buffer, WSDLInterfaceOperation operation) {
        int lenout;
        String opname = operation.getName().toString();
        if (!"http://www.w3.org/2004/03/wsdl/style/rpc".equals(operation.getStyle())) {
            this.wsdlStyle = "Document/Literal";
        }
        String interfaceName = operation.getWsdlInterface().getName().toString();
        buffer.append("<message name='" + interfaceName + "_" + opname + "' >");
        WSDLInterfaceOperationInput[] inputs = operation.getInputs();
        int lenin = inputs.length;
        for (int i = 0; i < lenin; ++i) {
            WSDLInterfaceOperationInput input = inputs[i];
            this.appendInputParts(buffer, input, i);
        }
        buffer.append("</message>");
        WSDLInterfaceOperationOutput[] outputs = operation.getOutputs();
        int n = lenout = outputs != null ? outputs.length : 0;
        if ("http://www.w3.org/2004/08/wsdl/in-only".equals(operation.getPattern())) {
            return;
        }
        buffer.append("<message name='" + interfaceName + "_" + opname + "Response' >");
        if (lenout > 0) {
            String str = "";
            for (int i = 0; i < lenout; ++i) {
                WSDLInterfaceOperationOutput out = outputs[i];
                str = str + this.appendOutputParts(out, i);
            }
            buffer.append(str);
        }
        buffer.append("</message>");
    }

    private void appendMessagesForExceptions(StringBuilder buffer, WSDLInterfaceOperation operation) {
        WSDLInterfaceOperationOutfault[] faults = operation.getOutfaults();
        int len = faults != null ? faults.length : 0;
        for (int i = 0; i < len; ++i) {
            WSDLInterfaceOperationOutfault fault = faults[i];
            QName xmlName = fault.getRef();
            String exceptionName = xmlName.getLocalPart();
            if (this.writtenFaultMessages.contains(exceptionName)) continue;
            buffer.append("<message name='" + exceptionName + "' >");
            String prefix = this.wsdl.getPrefix(xmlName.getNamespaceURI());
            String xmlNameStr = prefix + ":" + xmlName.getLocalPart();
            buffer.append("<part name='" + exceptionName + "' element='" + xmlNameStr + "' />");
            buffer.append("</message>");
            this.writtenFaultMessages.add(exceptionName);
        }
    }

    private void appendInputParts(StringBuilder buffer, WSDLInterfaceOperationInput input, int index) {
        if (this.wsdlStyle.equals("RPC/Literal")) {
            QName el = input.getElement();
            QName xmlType = input.getXMLType();
            String prefix = this.wsdl.getPrefix(xmlType.getNamespaceURI());
            buffer.append("<part name='" + el.getLocalPart() + "'");
            buffer.append(" type='" + prefix + ":" + xmlType.getLocalPart() + "'>");
            buffer.append("</part>");
        } else {
            buffer.append("<part name='parameters'");
            QName elm = input.getElement();
            String part = this.wsdl.getPrefix(elm.getNamespaceURI()) + ":" + elm.getLocalPart();
            buffer.append(" element='" + part + "'>");
            buffer.append("</part>");
        }
    }

    private String appendOutputParts(WSDLInterfaceOperationOutput out, int index) {
        StringBuilder buf = new StringBuilder("");
        if (this.wsdlStyle.equals("RPC/Literal")) {
            QName xmlName = out.getElement();
            QName xmlType = out.getXMLType();
            String prefix = this.wsdl.getPrefix(xmlType.getNamespaceURI());
            buf.append("<part name='" + xmlName.getLocalPart() + "'");
            buf.append(" type='" + prefix + ":" + xmlType.getLocalPart() + "'>");
            buf.append("</part>");
        } else {
            buf.append("<part name='result'");
            QName elm = out.getElement();
            String value = this.wsdl.getPrefix(elm.getNamespaceURI()) + ":" + elm.getLocalPart();
            buf.append(" element='" + value + "'>");
            buf.append("</part>");
        }
        return buf.toString();
    }

    protected void appendInterfaces(StringBuilder buffer) {
    }

    protected void appendPortTypes(StringBuilder buffer) {
        WSDLInterface[] intfs = this.wsdl.getInterfaces();
        for (int i = 0; i < intfs.length; ++i) {
            WSDLInterface intf = intfs[i];
            if (i == 0) {
                buffer.append("<portType name='" + intf.getName() + "'>");
            }
            this.appendPortOperations(buffer, intf);
        }
        buffer.append("</portType>");
    }

    protected void appendPortOperations(StringBuilder buffer, WSDLInterface intf) {
        String targetPrefix = this.wsdl.getTargetPrefix();
        WSDLInterfaceOperation[] operations = intf.getSortedOperations();
        for (int i = 0; i < operations.length; ++i) {
            WSDLInterfaceOperationOutfault[] faults;
            WSDLInterfaceOperation operation = operations[i];
            WSDLInterfaceOperationInput[] inputs = operation.getInputs();
            int inplen = inputs.length;
            buffer.append("<operation name='" + operation.getName().toString() + "'");
            if (this.wsdlStyle.equals("RPC/Literal")) {
                if (inplen > 0) {
                    buffer.append(" parameterOrder='");
                }
                for (int j = 0; j < inplen; ++j) {
                    if (j > 0) {
                        buffer.append(" ");
                    }
                    WSDLInterfaceOperationInput input = inputs[j];
                    QName el = input.getElement();
                    buffer.append(el.getLocalPart());
                }
                if (inplen > 0) {
                    buffer.append("'");
                }
            }
            buffer.append(">");
            String opname = operation.getName().toString();
            String interfaceName = operation.getWsdlInterface().getName().toString();
            String msgEl = targetPrefix + ":" + interfaceName + "_" + opname;
            buffer.append("<input message='" + msgEl + "'>").append("</input>");
            if (!"http://www.w3.org/2004/08/wsdl/in-only".equals(operation.getPattern())) {
                buffer.append("<output message='" + msgEl + "Response'>");
                buffer.append("</output>");
            }
            int lenf = (faults = operation.getOutfaults()) != null ? faults.length : 0;
            for (int k = 0; k < lenf; ++k) {
                WSDLInterfaceOperationOutfault flt = faults[k];
                QName elt = flt.getRef();
                String targetNS = this.wsdl.getTargetNamespace();
                elt = new QName(targetNS, elt.getLocalPart(), this.wsdl.getPrefix(targetNS));
                String cleanname = this.utils.chop(this.utils.chop(elt.getLocalPart(), "Error"), "Fault");
                String n = "name='" + cleanname + "'";
                String cleanref = this.utils.chop(this.utils.getFormattedString(elt), "Error");
                buffer.append("<fault  message='" + cleanref + "' " + n + ">");
                buffer.append("</fault>");
            }
            buffer.append("</operation>");
        }
    }

    protected void appendBindings(StringBuilder buffer) {
        WSDLBinding[] bindings = this.wsdl.getBindings();
        for (int i = 0; i < bindings.length; ++i) {
            WSDLBinding binding = bindings[i];
            buffer.append("<binding name='" + binding.getName() + "' type='" + this.getQNameRef(binding.getInterfaceName()) + "'>");
            if (this.wsdlStyle == null) {
                throw new IllegalArgumentException("WSDL Style is null (should be rpc or document");
            }
            String style = "rpc";
            if (this.wsdlStyle.equals("Document/Literal")) {
                style = "document";
            }
            buffer.append("<soap:binding transport='http://schemas.xmlsoap.org/soap/http' style='" + style + "'/>");
            this.appendBindingOperations(buffer, binding);
            buffer.append("</binding>");
        }
    }

    private boolean isHeaderInput(WSDLBindingOperationInput input) {
        WSDLBindingOperation operation = input.getWsdlBindingOperation();
        WSDLBinding binding = operation.getWsdlBinding();
        WSDLInterface wsdlInterface = binding.getInterface();
        if (wsdlInterface == null) {
            return false;
        }
        WSDLInterfaceOperation interfaceOperation = wsdlInterface.getOperation(new NCName(operation.getRef().getLocalPart()));
        if (interfaceOperation == null) {
            return false;
        }
        WSDLInterfaceOperationInput interfaceInput = interfaceOperation.getInputByPartName(input.getMessageLabel().toString());
        if (interfaceInput == null) {
            return false;
        }
        return interfaceInput.getProperty("http://www.w3.org/2004/08/wsdl/feature/AD/data") != null;
    }

    private boolean isHeaderOutput(WSDLBindingOperationOutput output) {
        WSDLBindingOperation operation = output.getWsdlBindingOperation();
        WSDLBinding binding = operation.getWsdlBinding();
        WSDLInterface wsdlInterface = binding.getInterface();
        if (wsdlInterface == null) {
            return false;
        }
        WSDLInterfaceOperation interfaceOperation = wsdlInterface.getOperation(new NCName(operation.getRef().getLocalPart()));
        if (interfaceOperation == null) {
            return false;
        }
        WSDLInterfaceOperationOutput interfaceOutput = interfaceOperation.getOutputByPartName(output.getMessageLabel().toString());
        if (interfaceOutput == null) {
            return false;
        }
        return interfaceOutput.getProperty("http://www.w3.org/2004/08/wsdl/feature/AD/data") != null;
    }

    protected void appendBindingOperations(StringBuilder buffer, WSDLBinding binding) {
        Object[] operations = binding.getOperations();
        Arrays.sort(operations);
        String tns = this.wsdl.getTargetNamespace();
        for (int i = 0; i < operations.length; ++i) {
            QName intfname;
            WSDLInterface intf;
            Object operation = operations[i];
            String interfaceName = ((WSDLBindingOperation)operation).getWsdlBinding().getInterfaceName().getLocalPart();
            buffer.append("<operation name='" + ((WSDLBindingOperation)operation).getRef().getLocalPart() + "'>");
            String soapAction = ((WSDLBindingOperation)operation).getSOAPAction() != null ? ((WSDLBindingOperation)operation).getSOAPAction() : "";
            buffer.append("<soap:operation soapAction=\"" + soapAction + "\"/>");
            buffer.append("<input>");
            buffer.append("<soap:body use='literal'");
            if (this.wsdlStyle != "Document/Literal") {
                buffer.append(" namespace='" + tns + "'");
            }
            buffer.append("/>");
            WSDLBindingOperationInput[] inputs = ((WSDLBindingOperation)operation).getInputs();
            for (int j = 0; j < inputs.length; ++j) {
                WSDLBindingOperationInput input = inputs[j];
                if (!this.isHeaderInput(input)) continue;
                String messageName = interfaceName + "_" + input.getWsdlBindingOperation().getRef().getLocalPart();
                buffer.append("<soap:header message='tns:" + messageName + "' part='" + input.getMessageLabel() + "'/>");
            }
            buffer.append("</input>");
            if (!"http://www.w3.org/2004/08/wsdl/in-only".equals(this.getBindingOperationPattern((WSDLBindingOperation)operation))) {
                buffer.append("<output>");
                buffer.append("<soap:body use='literal'");
                if (this.wsdlStyle != "Document/Literal") {
                    buffer.append(" namespace='" + tns + "'");
                }
                buffer.append("/>");
                WSDLBindingOperationOutput[] outputs = ((WSDLBindingOperation)operation).getOutputs();
                for (int j = 0; j < outputs.length; ++j) {
                    WSDLBindingOperationOutput output = outputs[j];
                    if (!this.isHeaderOutput(output)) continue;
                    String messageName = interfaceName + "_" + output.getWsdlBindingOperation().getRef().getLocalPart();
                    buffer.append("<soap:header message='tns:" + messageName + "' part='" + output.getMessageLabel() + "'/>");
                }
                buffer.append("</output>");
            }
            if ((intf = this.wsdl.getInterface(new NCName((intfname = ((WSDLBindingOperation)operation).getWsdlBinding().getInterfaceName()).getLocalPart()))) == null) {
                throw new WSException("WSDL Interface should not be null");
            }
            WSDLInterfaceOperation interfaceOperation = intf.getOperation(new NCName(((WSDLBindingOperation)operation).getRef().getLocalPart()));
            WSDLInterfaceOperationOutfault[] faults = interfaceOperation.getOutfaults();
            int lenf = faults != null ? faults.length : 0;
            for (int k = 0; k < lenf; ++k) {
                WSDLInterfaceOperationOutfault flt = faults[k];
                String cleanname = this.utils.chop(this.utils.chop(flt.getRef().getLocalPart(), "Error"), "Fault");
                String n = "name='" + cleanname + "'";
                buffer.append("<fault  " + n + ">");
                buffer.append("<soap:fault  " + n + " use='literal' />");
                buffer.append("</fault>");
            }
            buffer.append("</operation>");
        }
    }

    private String getBindingOperationPattern(WSDLBindingOperation operation) {
        WSDLBinding binding = operation.getWsdlBinding();
        String pattern = binding.getInterface().getOperation(new NCName(operation.getRef().getLocalPart())).getPattern();
        return pattern;
    }

    protected void appendServices(StringBuilder buffer) {
        for (WSDLService service : this.wsdl.getServices()) {
            buffer.append("<service name='" + service.getName() + "'>");
            for (WSDLEndpoint endpoint : service.getEndpoints()) {
                this.appendServicePort(buffer, endpoint);
            }
            buffer.append("</service>");
        }
    }

    protected void appendServicePort(StringBuilder buffer, WSDLEndpoint endpoint) {
        String name = endpoint.getName().toString();
        QName endpointBinding = endpoint.getBinding();
        String prefix = endpointBinding.getPrefix();
        if (prefix == null || prefix == "") {
            prefix = this.wsdl.getTargetPrefix();
        }
        String ebname = prefix + ":" + endpointBinding.getLocalPart();
        buffer.append("<port name='" + name + "' binding='" + ebname + "'>");
        buffer.append("<soap:address location='" + endpoint.getAddress() + "'/>");
        buffer.append("</port>");
    }

    private String getXMLTypeFromWSDLProperty(WSDLInterfaceOperationOutput wiout) {
        String value = "";
        WSDLProperty outprop = wiout.getProperty("http://www.jboss.org/jbossws/rpc/xmltype");
        if (outprop != null) {
            value = outprop.getValue();
        }
        return value;
    }
}

