/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.soap;

import java.util.Stack;
import org.jboss.logging.Logger;
import org.jboss.ws.soap.SOAPMessageContextImpl;

public class MessageContextAssociation {
    private static Logger log = Logger.getLogger(MessageContextAssociation.class);
    private static ThreadLocal<Stack<SOAPMessageContextImpl>> ctxThreadLocal = new InheritableThreadLocal<Stack<SOAPMessageContextImpl>>();

    public static SOAPMessageContextImpl popMessageContext() {
        SOAPMessageContextImpl msgContext = null;
        Stack<SOAPMessageContextImpl> stack = ctxThreadLocal.get();
        if (stack != null && !stack.isEmpty()) {
            msgContext = stack.pop();
        }
        log.debug((Object)("popMessageContext: " + msgContext));
        return msgContext;
    }

    public static SOAPMessageContextImpl peekMessageContext() {
        SOAPMessageContextImpl msgContext = null;
        Stack<SOAPMessageContextImpl> stack = ctxThreadLocal.get();
        if (stack != null && !stack.isEmpty()) {
            msgContext = stack.peek();
        }
        log.trace((Object)("peekMessageContext: " + msgContext));
        return msgContext;
    }

    public static void pushMessageContext(SOAPMessageContextImpl msgContext) {
        log.debug((Object)("pushMessageContext: " + msgContext));
        Stack<SOAPMessageContextImpl> stack = ctxThreadLocal.get();
        if (stack == null) {
            stack = new Stack();
            ctxThreadLocal.set(stack);
        }
        stack.push(msgContext);
    }
}

