/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.soap;

import java.util.Iterator;
import java.util.Locale;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import org.jboss.logging.Logger;
import org.jboss.ws.Constants;
import org.jboss.ws.soap.NameImpl;
import org.jboss.ws.soap.SOAPBodyElementDoc;
import org.jboss.ws.soap.SOAPElementImpl;
import org.jboss.ws.soap.SOAPFactoryImpl;
import org.jboss.ws.soap.SOAPFaultImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SOAPBodyImpl
extends SOAPElementImpl
implements SOAPBody {
    private static Logger log = Logger.getLogger(SOAPBodyImpl.class);

    public SOAPBodyImpl(String prefix, String namespace) {
        super("Body", prefix, namespace);
    }

    public SOAPElement addChildElement(SOAPElement child) throws SOAPException {
        if (!(child instanceof SOAPBodyElement)) {
            child = this.convertToBodyElement((Node)child);
        }
        child = super.addChildElement(child);
        return child;
    }

    public SOAPBodyElement addBodyElement(Name name) throws SOAPException {
        SOAPBodyElementDoc child = new SOAPBodyElementDoc(name);
        return (SOAPBodyElement)this.addChildElement(child);
    }

    public SOAPBodyElement addDocument(Document doc) throws SOAPException {
        Element rootElement = doc.getDocumentElement();
        SOAPFactoryImpl soapFactory = new SOAPFactoryImpl();
        SOAPElementImpl soapElement = soapFactory.createElement(rootElement, true);
        return (SOAPBodyElement)this.addChildElement(soapElement);
    }

    public SOAPFault addFault() throws SOAPException {
        if (this.hasFault()) {
            throw new SOAPException("A SOAPBody may contain at most one SOAPFault child element");
        }
        return this.addFault(new NameImpl(Constants.SOAP11_FAULT_CODE_SERVER), "Generic server fault");
    }

    public SOAPFault addFault(Name faultCode, String faultString) throws SOAPException {
        if (this.hasFault()) {
            throw new SOAPException("A SOAPBody may contain at most one SOAPFault child element");
        }
        SOAPFaultImpl soapFault = new SOAPFaultImpl(this.getNamespaceURI());
        soapFault = (SOAPFaultImpl)this.addChildElement(soapFault);
        soapFault.setFaultCode(faultCode);
        soapFault.setFaultString(faultString);
        return soapFault;
    }

    public SOAPFault addFault(Name faultCode, String faultString, Locale locale) throws SOAPException {
        if (this.hasFault()) {
            throw new SOAPException("A SOAPBody may contain at most one SOAPFault child element");
        }
        SOAPFaultImpl soapFault = new SOAPFaultImpl(this.getNamespaceURI());
        soapFault.setFaultCode(faultCode);
        soapFault.setFaultString(faultString, locale);
        this.addChildElement(soapFault);
        return soapFault;
    }

    public SOAPFault getFault() {
        Iterator it = this.getChildElements(Constants.SOAP11_FAULT);
        return it.hasNext() ? (SOAPFault)it.next() : null;
    }

    public boolean hasFault() {
        return this.getChildElements(Constants.SOAP11_FAULT).hasNext();
    }

    public Node appendChild(Node newChild) throws DOMException {
        if (!(newChild instanceof SOAPBodyElement) && !(newChild instanceof DocumentFragment)) {
            newChild = this.convertToBodyElement((Node)newChild);
        }
        Node retNode = super.appendChild((Node)newChild);
        return retNode;
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        if (!(newChild instanceof SOAPBodyElement) && !(newChild instanceof DocumentFragment)) {
            newChild = this.convertToBodyElement((Node)newChild);
        }
        return super.insertBefore((Node)newChild, refChild);
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        if (!(newChild instanceof SOAPBodyElement) && !(newChild instanceof DocumentFragment)) {
            newChild = this.convertToBodyElement((Node)newChild);
        }
        return super.replaceChild((Node)newChild, oldChild);
    }

    private SOAPBodyElementDoc convertToBodyElement(Node node) {
        if (!(node instanceof SOAPElementImpl)) {
            throw new IllegalArgumentException("SOAPElement expected");
        }
        SOAPElementImpl element = (SOAPElementImpl)((Object)node);
        element.detachNode();
        return new SOAPBodyElementDoc(element);
    }
}

