/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.soap;

import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.handler.MessageContextImpl;
import org.jboss.ws.jaxrpc.ServiceDesc;
import org.jboss.ws.jaxrpc.encoding.SerializationContextImpl;
import org.jboss.ws.metadata.EndpointMetaData;
import org.jboss.ws.metadata.OperationMetaData;
import org.jboss.ws.metadata.ServiceMetaData;
import org.jboss.ws.soap.SOAPEnvelopeImpl;
import org.jboss.xb.binding.NamespaceRegistry;

public class SOAPMessageContextImpl
extends MessageContextImpl
implements SOAPMessageContext {
    private static Logger log = Logger.getLogger(SOAPMessageContextImpl.class);
    private SOAPMessage soapMessage;
    private ServiceDesc serviceDesc;
    private EndpointMetaData epMetaData;
    private OperationMetaData opMetaData;
    private SerializationContextImpl serContext;

    public SOAPMessage getMessage() {
        return this.soapMessage;
    }

    public void setMessage(SOAPMessage message) {
        this.soapMessage = message;
    }

    public String[] getRoles() {
        return new String[0];
    }

    public ServiceDesc getServiceDesc() {
        if (this.serviceDesc == null && this.opMetaData != null) {
            log.debug((Object)"Using default service description");
            this.serviceDesc = new ServiceDesc(this.opMetaData.getEndpointMetaData().getServiceMetaData());
        }
        return this.serviceDesc;
    }

    public void setServiceDesc(ServiceDesc serviceDesc) {
        this.serviceDesc = serviceDesc;
    }

    public EndpointMetaData getEndpointMetaData() {
        if (this.epMetaData == null && this.opMetaData != null) {
            this.epMetaData = this.opMetaData.getEndpointMetaData();
        }
        return this.epMetaData;
    }

    public void setEndpointMetaData(EndpointMetaData epMetaData) {
        this.epMetaData = epMetaData;
    }

    public OperationMetaData getOperationMetaData() {
        return this.opMetaData;
    }

    public void setOperationMetaData(OperationMetaData opMetaData) {
        this.opMetaData = opMetaData;
    }

    public SerializationContextImpl getSerializationContext() {
        if (this.serContext == null) {
            ServiceDesc serviceDesc = this.getServiceDesc();
            ServiceMetaData serviceMetaData = serviceDesc.getServiceMetaData();
            this.serContext = new SerializationContextImpl();
            this.serContext.setTypeMapping(serviceDesc.getTypeMapping());
            this.serContext.setJavaWsdlMapping(serviceMetaData.getJavaWsdlMapping());
        }
        this.serContext.setNamespaceRegistry(this.getNamespaceRegistry());
        return this.serContext;
    }

    public NamespaceRegistry getNamespaceRegistry() {
        if (this.soapMessage == null) {
            throw new WSException("Cannot obtain NamespaceRegistry, because there is no SOAPMessage associated with this context");
        }
        try {
            SOAPEnvelopeImpl soapEnv = (SOAPEnvelopeImpl)this.soapMessage.getSOAPPart().getEnvelope();
            NamespaceRegistry nsRegistry = soapEnv.getNamespaceRegistry();
            return nsRegistry;
        }
        catch (SOAPException e) {
            throw new WSException("Cannot get SOAPEnvelope: " + (Object)((Object)e));
        }
    }
}

