/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.soap.attachment;

import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.ParameterList;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import org.jboss.util.xml.DOMWriter;
import org.jboss.ws.soap.SOAPMessageImpl;
import org.jboss.ws.soap.attachment.MultipartRelatedEncoder;
import org.w3c.dom.Node;

public class MultipartRelatedXOPEncoder
extends MultipartRelatedEncoder {
    public MultipartRelatedXOPEncoder(SOAPMessageImpl soapMessage) throws SOAPException {
        super(soapMessage);
    }

    public void encodeMultipartRelatedMessage() throws SOAPException, MessagingException {
        ParameterList p = new ParameterList();
        p.set("type", "application/xop+xml");
        p.set("start", "<rootpart@ws.jboss.org>");
        MimeMultipart multipart = new MimeMultipart("related" + p);
        MimeBodyPart rootPart = new MimeBodyPart();
        SOAPEnvelope soapEnv = this.soapMessage.getSOAPPart().getEnvelope();
        String envStr = DOMWriter.printNode((Node)soapEnv, (boolean)true);
        rootPart.setText(envStr, "UTF-8");
        rootPart.setContentID("<rootpart@ws.jboss.org>");
        rootPart.setHeader("Content-Type", "application/xop+xml");
        rootPart.setHeader("Content-Transfer-Encoding", "8bit");
        multipart.addBodyPart((BodyPart)rootPart);
        this.addAttachmentParts(multipart);
        this.multipart = multipart;
    }
}

