/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.tools.Configuration;
import org.jboss.ws.tools.config.ToolsSchemaConfigReader;
import org.jboss.ws.tools.helpers.ToolsHelper;

public class WSTools {
    private static Logger log = Logger.getLogger(WSTools.class);
    private Configuration config;
    private String outputDir = ".";

    public static void main(String[] args) throws IOException {
        WSTools tools = new WSTools();
        tools.generate(args);
    }

    public void generate(String[] args) throws IOException {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("-config".equals(arg)) {
                this.readToolsConfiguration(args[i + 1]);
                ++i;
                continue;
            }
            if ("-dest".equals(arg)) {
                this.outputDir = args[i + 1];
                ++i;
                continue;
            }
            if (!"-classpath".equals(arg) && !"-cp".equals(arg)) continue;
            StringTokenizer st = new StringTokenizer(args[i + 1], ":");
            URL[] urls = new URL[st.countTokens()];
            for (int j = 0; j < st.countTokens(); ++j) {
                String token = st.nextToken();
                urls[j] = new File(token).toURL();
            }
            ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
            URLClassLoader urlLoader = new URLClassLoader(urls, ctxLoader);
            Thread.currentThread().setContextClassLoader(urlLoader);
            ++i;
        }
        if (this.config == null) {
            throw new IllegalArgumentException("wstools config not found");
        }
        this.process();
    }

    private void process() throws IOException {
        ToolsHelper helper = new ToolsHelper();
        if (this.config == null) {
            throw new WSException("Configuration is null");
        }
        if (this.config.getJavaToWSDLConfig(false) != null) {
            helper.handleJavaToWSDLGeneration(this.config, this.outputDir);
        }
        if (this.config.getWSDLToJavaConfig(false) != null) {
            helper.handleWSDLToJavaGeneration(this.config, this.outputDir);
        }
    }

    private void readToolsConfiguration(String filename) throws IOException {
        log.debug((Object)("Config file name=" + filename));
        ToolsSchemaConfigReader configReader = new ToolsSchemaConfigReader();
        this.config = configReader.readConfig(filename);
    }
}

