/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools;

import java.beans.Introspector;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.apache.xerces.xs.XSWildcard;
import org.jboss.ws.WSException;
import org.jboss.ws.jaxrpc.LiteralTypeMapping;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.ws.metadata.wsdl.xsd.SchemaUtils;
import org.jboss.ws.tools.JavaWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDTypeToJava {
    protected LiteralTypeMapping typeMapping = null;
    protected WSDLUtils utils = WSDLUtils.getInstance();
    protected SchemaUtils schemautils = SchemaUtils.getInstance();
    protected JavaWriter jwriter = new JavaWriter();
    protected String fname = "";
    protected File loc = null;
    protected String pkgname = "";
    private Set<String> generatedFiles = new HashSet<String>();
    private Map<String, List> typeNameToBaseVARList = new HashMap<String, List>();

    public void createJavaFile(XSComplexTypeDefinition type, File loc, String pkgname, XSModel schema) throws IOException {
        if (this.typeMapping == null) {
            throw new WSException("TypeMapping has not been set");
        }
        this.fname = type.getName();
        if (this.fname == null) {
            throw new WSException("File Name is null");
        }
        this.loc = loc;
        this.pkgname = pkgname;
        this.createJavaFile(type, schema, false);
    }

    public void createJavaFile(XSComplexTypeDefinition type, String filename, File loc, String pkgname, XSModel schema, boolean isExceptionType) throws IOException {
        if (this.typeMapping == null) {
            throw new WSException("TypeMapping has not been set");
        }
        this.fname = type.getName();
        if (this.fname == null) {
            this.fname = filename;
        }
        this.loc = loc;
        this.pkgname = pkgname;
        this.createJavaFile(type, schema, isExceptionType);
    }

    public void createJavaFile(XSSimpleTypeDefinition type, File loc, String pkgname, XSModel schema) throws IOException {
        if (this.typeMapping == null) {
            throw new WSException("TypeMapping has not been set");
        }
        this.fname = type.getName();
        this.loc = loc;
        this.pkgname = pkgname;
        this.createJavaFile(type, schema);
    }

    public void createJavaFile(XSComplexTypeDefinition type, XSModel schema, boolean isExceptionType) throws IOException {
        if (this.typeMapping == null) {
            throw new WSException("TypeMapping has not been set");
        }
        XSTypeDefinition baseType = type.getBaseType();
        this.fname = this.utils.firstLetterUpperCase(this.fname);
        ArrayList<VAR> vars = new ArrayList();
        String baseName = null;
        if (isExceptionType && baseType != null && "anyType".equals(baseType.getName())) {
            baseName = "Exception";
        } else if (isExceptionType && baseType == null) {
            baseName = "Exception";
        }
        if (baseName == null) {
            baseName = this.getBaseTypeName(type);
        }
        vars = this.getVARList(type, schema, isExceptionType);
        this.jwriter.createJavaFile(this.loc, this.fname, this.pkgname, vars, null, baseName, isExceptionType, this.typeNameToBaseVARList);
    }

    public void createJavaFile(XSSimpleTypeDefinition xsSimple, XSModel schema) throws IOException {
        if (this.typeMapping == null) {
            throw new WSException("TypeMapping has not been set");
        }
        XSTypeDefinition baseType = xsSimple.getBaseType();
        short variety = xsSimple.getVariety();
        if (1 == variety) {
            StringList slist = xsSimple.getLexicalEnumeration();
            if (slist != null && slist.getLength() > 0) {
                this.jwriter.createJavaFileForEnumeratedValues(this.fname, slist, this.loc, this.pkgname, xsSimple);
            } else {
                if ("http://www.w3.org/2001/XMLSchema".equals(xsSimple.getNamespace())) {
                    return;
                }
                return;
            }
        }
    }

    public List<VAR> getVARList(XSComplexTypeDefinition type, XSModel schema, boolean isExceptionType) throws IOException {
        if (this.typeMapping == null) {
            throw new WSException("TypeMapping has not been set");
        }
        XSTypeDefinition baseType = type.getBaseType();
        ArrayList<VAR> vars = new ArrayList();
        vars = this.handleAttributes(type, vars);
        short contentType = type.getContentType();
        if (1 == contentType) {
            short der = type.getDerivationMethod();
            if (1 == der) {
                XSSimpleTypeDefinition xssimple = type.getSimpleType();
                QName q = new QName(xssimple.getNamespace(), xssimple.getName());
                QName qn = this.schemautils.patchXSDQName(q);
                VAR v = new VAR("_value", this.typeMapping.getJavaType(qn).getName(), false);
                vars.add(v);
            }
        } else if (0 == contentType) {
            short der = type.getDerivationMethod();
            if (2 == der) {
                vars.addAll(this.createVARsforXSParticle(type, schema));
            }
        } else if (2 == contentType) {
            if (!this.utils.isBaseTypeIgnorable(baseType, type)) {
                short der = type.getDerivationMethod();
                if (0 == der) {
                    this.handleContentTypeElementsWithDerivationNone(type, schema, isExceptionType, vars, type.getParticle());
                }
                if (1 == der) {
                    this.handleContentTypeElementsWithDerivationExtension(type, schema, vars, type.getParticle());
                } else if (2 == der) {
                    this.handleContentTypeElementsWithDerivationRestriction(type, schema, vars, type.getParticle());
                }
            } else {
                vars.addAll(this.createVARsforXSParticle(type, schema));
            }
        }
        return vars;
    }

    public void setPackageName(String packageName) {
        this.pkgname = packageName;
    }

    public void setTypeMapping(LiteralTypeMapping tm) {
        this.typeMapping = tm;
    }

    private void handleContentTypeElementsWithDerivationRestriction(XSComplexTypeDefinition type, XSModel schema, List vars, XSParticle xsparticle) throws IOException {
        XSTerm xsterm;
        if (xsparticle != null && (xsterm = xsparticle.getTerm()) instanceof XSModelGroup) {
            XSModelGroup xsm = (XSModelGroup)xsterm;
            XSObjectList xparts = xsm.getParticles();
            XSParticle xspar = (XSParticle)xparts.item(1);
            XSTerm xterm = xspar.getTerm();
            if (xterm instanceof XSElementDeclaration) {
                vars.addAll(this.createVARforXSElementDeclaration(xterm, this.schemautils.isArrayType(xspar), schema, type));
            } else if (xterm instanceof XSModelGroup) {
                XSModelGroup xsmodelgrp = (XSModelGroup)xterm;
                vars.addAll(this.createVARsforXSModelGroup(xsmodelgrp, schema, type));
            }
        }
    }

    private void handleContentTypeElementsWithDerivationExtension(XSComplexTypeDefinition type, XSModel schema, List vars, XSParticle xsparticle) throws IOException {
        XSTerm xsterm;
        if (xsparticle != null && (xsterm = xsparticle.getTerm()) instanceof XSModelGroup) {
            XSModelGroup xsm = (XSModelGroup)xsterm;
            XSObjectList xparts = xsm.getParticles();
            XSParticle xspar = (XSParticle)xparts.item(xparts.getLength() - 1);
            XSTerm xsparTerm = xspar.getTerm();
            if (xsparTerm instanceof XSModelGroup) {
                XSModelGroup xsmodelgrp = (XSModelGroup)xspar.getTerm();
                vars.addAll(this.createVARsforXSModelGroup(xsmodelgrp, schema, type));
            } else if (xsparTerm instanceof XSElementDeclaration) {
                vars.addAll(this.createVARforXSElementDeclaration(xsparTerm, this.schemautils.isArrayType(xspar), schema, type));
            }
        }
    }

    private void handleContentTypeElementsWithDerivationNone(XSComplexTypeDefinition type, XSModel schema, boolean isExceptionType, List vars, XSParticle xsparticle) throws IOException {
        if (xsparticle != null) {
            XSTerm xsterm = xsparticle.getTerm();
            if (xsterm instanceof XSModelGroup) {
                XSModelGroup xsm = (XSModelGroup)xsterm;
                XSObjectList xparts = xsm.getParticles();
                int len = xparts != null ? xparts.getLength() : 0;
                int diff = len - 0;
                for (int i = 0; i < len; ++i) {
                    if (isExceptionType && type.getBaseType() != null) {
                        XSParticle xspar;
                        XSTerm xsparTerm;
                        ArrayList<VAR> baseList = new ArrayList<VAR>();
                        for (int j = 0; j < diff - 1; ++j) {
                            XSParticle xspar2 = (XSParticle)xparts.item(j);
                            XSTerm xsparTerm2 = xspar2.getTerm();
                            if (!(xsparTerm2 instanceof XSModelGroup)) continue;
                            XSModelGroup xsmodelgrp = (XSModelGroup)xspar2.getTerm();
                            baseList.addAll(this.createVARsforXSModelGroup(xsmodelgrp, schema, type));
                        }
                        if (baseList.size() > 0) {
                            this.typeNameToBaseVARList.put(type.getName(), baseList);
                        }
                        if ((xsparTerm = (xspar = (XSParticle)xparts.item(len - 1)).getTerm()) instanceof XSModelGroup) {
                            XSModelGroup xsmodelgrp = (XSModelGroup)xspar.getTerm();
                            vars.addAll(this.createVARsforXSModelGroup(xsmodelgrp, schema, type));
                        }
                        break;
                    }
                    XSParticle xspar = (XSParticle)xparts.item(i);
                    XSTerm xsparTerm = xspar.getTerm();
                    if (xsparTerm instanceof XSModelGroup) {
                        XSModelGroup xsmodelgrp = (XSModelGroup)xspar.getTerm();
                        vars.addAll(this.createVARsforXSModelGroup(xsmodelgrp, schema, type));
                        continue;
                    }
                    if (!(xsparTerm instanceof XSElementDeclaration)) continue;
                    vars.addAll(this.createVARforXSElementDeclaration(xsparTerm, this.schemautils.isArrayType(xspar), schema, type));
                }
            } else if (xsterm instanceof XSElementDeclaration) {
                vars.addAll(this.createVARforXSElementDeclaration(xsterm, this.schemautils.isArrayType(xsparticle), schema, type));
            } else {
                throw new WSException("Unhandled Type");
            }
        }
    }

    private List handleAttributes(XSComplexTypeDefinition type, List vars) {
        XSObjectList xsobjlist = type.getAttributeUses();
        if (xsobjlist != null) {
            int len = xsobjlist.getLength();
            for (int i = 0; i < len; ++i) {
                XSAttributeUse obj = (XSAttributeUse)xsobjlist.item(i);
                XSAttributeDeclaration att = obj.getAttrDeclaration();
                XSSimpleTypeDefinition xstype = att.getTypeDefinition();
                QName q = new QName(xstype.getNamespace(), xstype.getName());
                QName qn = this.schemautils.patchXSDQName(q);
                VAR v = this.createVAR(qn, att.getName(), this.pkgname);
                if (vars == null) {
                    vars = new ArrayList<VAR>();
                }
                vars.add(v);
            }
        }
        return vars;
    }

    private List createVARsforXSParticle(XSComplexTypeDefinition type, XSModel schema) throws IOException {
        ArrayList list = new ArrayList();
        XSParticle xsparticle = type.getParticle();
        if (xsparticle != null) {
            short xsptype = xsparticle.getType();
            XSTerm xsterm = xsparticle.getTerm();
            if (xsptype != 2 && xsterm instanceof XSModelGroup) {
                XSModelGroup xsm = (XSModelGroup)xsterm;
                XSObjectList xparts = xsm.getParticles();
                list.addAll(this.createVARsForElements(xparts, schema, type));
            }
        }
        return list;
    }

    private List<VAR> createVARsforXSModelGroup(XSModelGroup xsm, XSModel schema, XSComplexTypeDefinition origType) throws IOException {
        ArrayList<VAR> vars = new ArrayList<VAR>();
        short compositor = xsm.getCompositor();
        if (1 == compositor) {
            XSObjectList xsobjlist = xsm.getParticles();
            int len = xsobjlist.getLength();
            for (int i = 0; i < len; ++i) {
                XSParticle xsparticle = (XSParticle)xsobjlist.item(i);
                XSTerm xselm = xsparticle.getTerm();
                if (!(xselm instanceof XSElementDeclaration)) continue;
                vars.addAll(this.createVARforXSElementDeclaration(xselm, this.schemautils.isArrayType(xsparticle), schema, origType));
            }
        }
        return vars;
    }

    private VAR createVAR(QName qn, String varstr, String pkgname) {
        String clname = "";
        Class cls = this.typeMapping.getJavaType(qn);
        VAR v = null;
        if (cls != null) {
            clname = cls.getName();
        } else if (qn != null) {
            if (!"http://www.w3.org/2001/XMLSchema".equals(qn.getNamespaceURI())) {
                clname = pkgname + ".";
            }
            clname = clname + qn.getLocalPart();
        }
        v = new VAR(varstr, clname, false);
        return v;
    }

    private List createVARsForElements(XSObjectList xsobjlist, XSModel schema, XSComplexTypeDefinition origType) throws IOException {
        ArrayList list = new ArrayList();
        int len = xsobjlist.getLength();
        for (int i = 0; i < len; ++i) {
            XSParticle xsparticle = (XSParticle)xsobjlist.item(i);
            XSTerm xsterm = xsparticle.getTerm();
            list.addAll(this.createVARforXSElementDeclaration(xsterm, this.schemautils.isArrayType(xsparticle), schema, origType));
        }
        return list;
    }

    private List createVARforXSElementDeclaration(XSTerm xsterm, boolean arrayType, XSModel schema, XSComplexTypeDefinition origType) throws IOException {
        XSWildcard xsw;
        ArrayList<VAR> vars = new ArrayList<VAR>();
        if (xsterm instanceof XSWildcard && (xsw = (XSWildcard)xsterm).getConstraintType() == 1) {
            VAR v = new VAR("_any", "javax.xml.soap.SOAPElement", arrayType);
            vars.add(v);
            return vars;
        }
        if (xsterm instanceof XSModelGroup) {
            vars.addAll(this.createVARsforXSModelGroup((XSModelGroup)xsterm, schema, origType));
            return vars;
        }
        XSElementDeclaration elem = (XSElementDeclaration)xsterm;
        String tname = elem.getName();
        XSTypeDefinition xstypedef = elem.getTypeDefinition();
        String xstypename = xstypedef.getName();
        if (xstypename != null && xstypedef.getName().equals(origType.getName()) && xstypedef.getNamespace().equals(origType.getNamespace())) {
            QName qn = new QName(origType.getNamespace(), origType.getName());
            VAR vr = this.createVAR(qn, elem, (XSTypeDefinition)((XSComplexTypeDefinition)xstypedef), tname, this.pkgname, arrayType);
            vars.add(vr);
            return vars;
        }
        if (xstypename == null && xstypedef instanceof XSComplexTypeDefinition) {
            String anonName;
            XSComplexTypeDefinition xsc = (XSComplexTypeDefinition)xstypedef;
            String subname = this.utils.firstLetterUpperCase(tname);
            String tempfname = this.fname;
            this.fname = anonName = this.fname + subname;
            this.createJavaFile((XSComplexTypeDefinition)xstypedef, schema, false);
            this.fname = tempfname;
            QName anonqn = new QName(anonName);
            VAR vr = this.createVAR(anonqn, elem, (XSTypeDefinition)xsc, tname, this.pkgname, arrayType);
            vars.add(vr);
            return vars;
        }
        if (this.schemautils.isWrapperArrayType(xstypedef)) {
            XSComplexTypeDefinition complex = (XSComplexTypeDefinition)xstypedef;
            XSModelGroup group = (XSModelGroup)complex.getParticle().getTerm();
            XSElementDeclaration element = (XSElementDeclaration)((XSParticle)group.getParticles().item(0)).getTerm();
            xstypedef = element.getTypeDefinition();
            xstypename = xstypedef.getName();
            arrayType = true;
        }
        QName qn = null;
        if (xstypename == null) {
            if (xstypedef instanceof XSSimpleTypeDefinition) {
                qn = this.schemautils.handleXSSimpleTypeDefinition((XSSimpleTypeDefinition)xstypedef);
            }
        } else {
            qn = new QName(xstypedef.getNamespace(), xstypename);
        }
        String temp = this.fname;
        if (xstypename != null && xstypedef instanceof XSComplexTypeDefinition) {
            this.fname = this.utils.firstLetterUpperCase(xstypename);
            if (!this.generatedFiles.contains(this.fname)) {
                this.generatedFiles.add(this.fname);
                this.createJavaFile((XSComplexTypeDefinition)xstypedef, schema, false);
            }
            this.fname = temp;
        }
        VAR v = this.createVAR(qn, elem, xstypedef, tname, this.pkgname, arrayType);
        vars.add(v);
        return vars;
    }

    private VAR createVAR(QName qn, XSElementDeclaration elem, XSTypeDefinition t, String varstr, String pkgname, boolean arrayType) {
        QName tempqn;
        if (t instanceof XSSimpleTypeDefinition && (tempqn = this.schemautils.handleXSSimpleTypeDefinition((XSSimpleTypeDefinition)t)) != null) {
            qn = tempqn;
        }
        String clname = "";
        Class cls = this.typeMapping.getJavaType(qn);
        VAR v = null;
        if (cls != null) {
            clname = cls.getName();
            String nl = this.utils.getNillableEquivalent(clname);
            boolean nillable = elem.getNillable();
            if (!nillable && nl != null) {
                clname = nl;
            }
        } else {
            QName typename = null;
            typename = t.getName() == null ? qn : new QName(t.getName());
            if (typename != null) {
                String nsuri = typename.getNamespaceURI();
                if (!nsuri.equals("http://www.w3.org/2001/XMLSchema")) {
                    clname = pkgname + ".";
                }
                clname = clname + typename.getLocalPart();
            } else if (qn != null) {
                clname = qn.getLocalPart();
            }
        }
        v = new VAR(Introspector.decapitalize(varstr), clname, arrayType);
        return v;
    }

    private String getBaseTypeName(XSComplexTypeDefinition type) {
        String baseName = null;
        XSTypeDefinition baseType = null;
        if (type instanceof XSComplexTypeDefinition) {
            XSComplexTypeDefinition t = type;
            baseType = t.getBaseType();
            if (baseType != null && baseType.getNamespace() == "http://www.w3.org/2001/XMLSchema" && baseType.getName().equals("anyType")) {
                baseType = null;
            }
            if (1 == t.getContentType()) {
                baseType = null;
            }
        }
        if (baseName == null && baseType != null) {
            baseName = baseType.getName();
        }
        return baseName;
    }

    public static class VAR {
        String varname;
        String vartype;
        boolean isArrayType = false;

        public VAR(String varname, String vartype, boolean arrayType) {
            this.varname = varname;
            this.vartype = vartype;
            this.isArrayType = arrayType;
        }

        public String getVarname() {
            return this.varname;
        }

        public void setVarname(String varname) {
            this.varname = varname;
        }

        public String getVartype() {
            return this.vartype;
        }

        public void setVartype(String vartype) {
            this.vartype = vartype;
        }

        public boolean isArrayType() {
            return this.isArrayType;
        }

        public void setArrayType(boolean arrayType) {
            this.isArrayType = arrayType;
        }
    }
}

