/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.metadata;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.holders.Holder;
import org.jboss.ws.WSException;
import org.jboss.ws.jaxrpc.ParameterWrapping;
import org.jboss.ws.metadata.FaultMetaData;
import org.jboss.ws.metadata.OperationMetaData;
import org.jboss.ws.metadata.ParameterMetaData;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.ws.tools.Configuration;
import org.jboss.ws.tools.ToolsUtils;
import org.jboss.ws.tools.metadata.ToolsEndpointMetaData;
import org.jboss.ws.utils.HolderUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectiveMetaDataBuilder {
    private Map<String, Configuration.OperationConfig> opMap = null;
    private Class seiClass = null;
    private ToolsEndpointMetaData tmd = null;
    private String targetNamespace = null;

    public ReflectiveMetaDataBuilder(ToolsEndpointMetaData tmd) {
        this.seiClass = tmd.getServiceEndpointInterface();
        this.checkServiceEndpointInterface();
        this.targetNamespace = tmd.getName().getNamespaceURI();
        this.tmd = tmd;
    }

    public void setOperationConfig(List<Configuration.OperationConfig> opCfgList) {
        if (opCfgList == null) {
            throw new IllegalArgumentException("Illegal null argument: opCfgList");
        }
        this.prepareOperationMap(opCfgList);
    }

    public ToolsEndpointMetaData generate() {
        this.generateOperationMetaData(this.seiClass.getDeclaredMethods());
        return this.tmd;
    }

    private void checkServiceEndpointInterface() {
        if (this.seiClass == null) {
            throw new IllegalArgumentException("Illegal Null Argument: seiClass");
        }
        if (!this.seiClass.isInterface()) {
            throw new IllegalArgumentException("Illegal seiClass : not an interface");
        }
        if (!Remote.class.isAssignableFrom(this.seiClass)) {
            throw new WSException("A service endpoint interface MUST extend java.rmi.Remote: " + this.seiClass.getName());
        }
    }

    private FaultMetaData getFaultMetaData(Class exType, OperationMetaData om) {
        String exname = WSDLUtils.getInstance().getJustClassName(exType);
        QName xmlName = new QName(this.tmd.typeNamespace, exname);
        FaultMetaData fm = new FaultMetaData(om, xmlName, xmlName, exType.getName());
        return fm;
    }

    private void generateOperationMetaData(Method[] marr) {
        if (marr == null) {
            throw new WSException("Number of methods in the seiClass is zero");
        }
        for (Method m : marr) {
            ParameterMetaData retMetaData;
            Configuration.OperationConfig opc;
            String methodname = m.getName();
            OperationMetaData om = this.getOperationMetaData(m);
            Configuration.OperationConfig operationConfig = opc = this.opMap != null ? this.opMap.get(methodname) : null;
            if (opc != null) {
                om.setOneWayOperation(opc.isOneWay);
            }
            Class<?>[] paramTypes = m.getParameterTypes();
            int len = 0;
            if (paramTypes != null) {
                len = Array.getLength(paramTypes);
            }
            ParameterMetaData wrappedParameter = null;
            ArrayList<String> wrappedVariables = null;
            ArrayList<String> wrappedTypes = null;
            ArrayList<QName> wrappedNames = null;
            if (om.isDocumentWrapped()) {
                QName xmlName;
                QName xmlType = xmlName = new QName(this.tmd.typeNamespace, m.getName());
                wrappedParameter = new ParameterMetaData(om, xmlName, xmlType, null);
                wrappedVariables = new ArrayList<String>(len);
                wrappedTypes = new ArrayList<String>(len);
                wrappedNames = new ArrayList<QName>(len);
                wrappedParameter.setWrappedVariables(wrappedVariables);
                wrappedParameter.setWrappedTypes(wrappedTypes);
                wrappedParameter.setWrappedElementNames(wrappedNames);
                om.addParameter(wrappedParameter);
                if (!om.isOneWayOperation()) {
                    xmlType = xmlName = new QName(this.tmd.typeNamespace, m.getName() + "Response");
                    retMetaData = new ParameterMetaData(om, xmlName, xmlType, null);
                    retMetaData.setWrappedVariables(new ArrayList<String>(0));
                    retMetaData.setWrappedTypes(new ArrayList<String>(0));
                    retMetaData.setWrappedElementNames(new ArrayList<QName>(0));
                    om.setReturnParameter(retMetaData);
                }
            }
            boolean hasParamConfig = opc != null && !opc.isOneWay ? opc.params != null : false;
            for (int i = 0; i < len; ++i) {
                Class<?> paramType = paramTypes[i];
                if (Remote.class.isAssignableFrom(paramType)) {
                    throw new WSException("Param Type " + paramType.getName() + " should not extend java.rmi.Remote");
                }
                if (om.isDocumentWrapped()) {
                    wrappedTypes.add(paramType.getName());
                    QName xmlName = this.getXmlName(paramType, i);
                    wrappedNames.add(xmlName);
                    wrappedVariables.add(this.convertToProperty(xmlName.getLocalPart()));
                    continue;
                }
                if (hasParamConfig) {
                    om.addParameter(this.getParameterMetaData(paramType, om, opc.params.get(i), i));
                    continue;
                }
                om.addParameter(this.getParameterMetaData(paramType, om, i));
            }
            Class<?> returnType = m.getReturnType();
            if (Void.TYPE != returnType) {
                if (Remote.class.isAssignableFrom(returnType)) {
                    throw new WSException("Return Type " + returnType.getName() + " should not extend java.rmi.Remote");
                }
                if (om.isDocumentWrapped()) {
                    retMetaData = om.getReturnParameter();
                    retMetaData.getWrappedVariables().add("result");
                    retMetaData.getWrappedTypes().add(returnType.getName());
                    retMetaData.getWrappedElementNames().add(new QName("result"));
                } else {
                    om.setReturnParameter(this.getParameterMetaDataForReturnType(returnType, om, 1));
                }
            }
            if (om.isDocumentWrapped()) {
                ParameterWrapping.generateWrapper(wrappedParameter, false);
                if (!om.isOneWayOperation()) {
                    ParameterWrapping.generateWrapper(om.getReturnParameter(), false);
                }
            }
            Class<?>[] exceptionTypes = m.getExceptionTypes();
            boolean remoteExceptionFound = false;
            if (exceptionTypes != null) {
                for (int i = 0; i < exceptionTypes.length; ++i) {
                    if (RemoteException.class.isAssignableFrom(exceptionTypes[i])) {
                        remoteExceptionFound = true;
                        continue;
                    }
                    om.addFault(this.getFaultMetaData(exceptionTypes[i], om));
                }
            }
            if (!remoteExceptionFound) {
                throw new WSException(m.getName() + " does not throw RemoteException.");
            }
            om.validate();
            this.tmd.addOperation(om);
        }
    }

    private OperationMetaData getOperationMetaData(Method m) {
        String methodname = m.getName();
        OperationMetaData om = new OperationMetaData(this.tmd, new QName(this.targetNamespace, methodname), methodname);
        om.setSOAPAction("");
        return om;
    }

    private ParameterMetaData getParameterMetaData(Class type, OperationMetaData om, Configuration.ParameterConfig pc, int index) {
        String xmlNameStr;
        String defaultName = this.getDefaultName(type);
        QName xmlType = ToolsUtils.getXMLType(type, this.tmd.typeNamespace);
        String string = xmlNameStr = pc.xmlName != null ? pc.xmlName : defaultName + "_" + (index + 1);
        if (pc.mimeType != null) {
            String mimeType = pc.mimeType;
            xmlType = ToolsUtils.getXMLTypeForAttachmentType(mimeType);
        }
        ParameterMetaData pm = new ParameterMetaData(om, new QName(this.tmd.typeNamespace, xmlNameStr), xmlType, defaultName);
        if (pc.mimeType != null) {
            pm.setSwA(true);
            pm.setMimeTypes(pc.mimeType);
        }
        return pm;
    }

    private ParameterMetaData getParameterMetaData(Class type, OperationMetaData om, int index) {
        boolean holder = false;
        if (Holder.class.isAssignableFrom(type)) {
            type = HolderUtils.getValueType(type);
            holder = true;
        }
        QName xmlType = ToolsUtils.getXMLType(type, this.tmd.typeNamespace);
        QName xmlName = this.getXmlName(type, index);
        ParameterMetaData pm = new ParameterMetaData(om, xmlName, xmlType, type.getName());
        if (holder) {
            pm.setMode(ParameterMode.INOUT);
        }
        return pm;
    }

    private QName getXmlName(Class type, int index) {
        String defaultName = this.getDefaultName(type);
        String xmlNameStr = defaultName + "_" + (index + 1);
        QName xmlName = new QName(this.tmd.typeNamespace, xmlNameStr);
        return xmlName;
    }

    private ParameterMetaData getParameterMetaDataForReturnType(Class type, OperationMetaData om, int index) {
        String typeNamespace = this.tmd.typeNamespace;
        if (Remote.class.isAssignableFrom(type)) {
            throw new WSException(om.getJavaName() + " has return type which " + "should not extend java.rmi.Remote");
        }
        String tns = this.targetNamespace;
        String name = "result";
        if (typeNamespace != null && !tns.equals(typeNamespace)) {
            tns = typeNamespace;
        }
        QName xmlType = ToolsUtils.getXMLType(type, tns);
        ParameterMetaData pm = new ParameterMetaData(om, new QName(tns, name), xmlType, type.getName());
        return pm;
    }

    private void prepareOperationMap(List<Configuration.OperationConfig> opCfgList) {
        this.opMap = new HashMap<String, Configuration.OperationConfig>();
        for (Configuration.OperationConfig oc : opCfgList) {
            String name = oc.name;
            if (this.opMap.get(name) != null) {
                throw new WSException("Overloaded operations not supported");
            }
            this.opMap.put(name, oc);
        }
    }

    private String getDefaultName(Class javaClass) {
        String name = "";
        WSDLUtils utils = WSDLUtils.getInstance();
        if (Holder.class.isAssignableFrom(javaClass)) {
            javaClass = utils.getJavaTypeForHolder(javaClass);
        }
        if (javaClass.isArray()) {
            int len = utils.getArrayDimension(javaClass);
            for (int i = 0; i < len; ++i) {
                javaClass = javaClass.getComponentType();
            }
            name = utils.getMessagePartForArray(utils.getJustClassName(javaClass));
        } else {
            name = utils.getJustClassName(javaClass);
        }
        return name;
    }

    private String convertToProperty(String variable) {
        if (Character.isUpperCase(variable.charAt(0))) {
            char c = Character.toLowerCase(variable.charAt(0));
            StringBuilder builder = new StringBuilder(variable);
            builder.setCharAt(0, c);
            variable = builder.toString();
        }
        return variable;
    }
}

