/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.wsse;

import javax.xml.namespace.QName;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.SOAPException;
import org.jboss.logging.Logger;
import org.jboss.ws.metadata.EndpointMetaData;
import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
import org.jboss.ws.soap.SOAPMessageContextImpl;
import org.jboss.ws.wsse.WSSecurityDispatcher;

public abstract class WSSecurityHandler
extends GenericHandler {
    private static Logger log = Logger.getLogger(WSSecurityHandler.class);

    public QName[] getHeaders() {
        return null;
    }

    protected boolean handleInboundSecurity(MessageContext msgContext) {
        try {
            if (this.getSecurityConfiguration(msgContext) != null) {
                WSSecurityDispatcher.handleInbound((SOAPMessageContextImpl)msgContext);
            }
        }
        catch (SOAPException ex) {
            log.error((Object)"Cannot handle inbound ws-security", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean handleOutboundSecurity(MessageContext msgContext) {
        try {
            if (this.getSecurityConfiguration(msgContext) != null) {
                WSSecurityDispatcher.handleOutbound((SOAPMessageContextImpl)msgContext);
            }
        }
        catch (SOAPException ex) {
            log.error((Object)"Cannot handle outbound ws-security", (Throwable)ex);
            return false;
        }
        return true;
    }

    private WSSecurityConfiguration getSecurityConfiguration(MessageContext msgContext) {
        EndpointMetaData epMetaData = ((SOAPMessageContextImpl)msgContext).getEndpointMetaData();
        WSSecurityConfiguration securityConfiguration = epMetaData.getServiceMetaData().getSecurityConfiguration();
        if (securityConfiguration == null) {
            log.warn((Object)"Cannot obtain security configuration");
        }
        return securityConfiguration;
    }
}

