/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.versioned;

import org.jboss.aspects.versioned.DistributedVersionManager;
import org.jboss.aspects.versioned.LocalSynchronizationManager;
import org.jboss.util.LRUCachePolicy;

public class TxCache
extends LRUCachePolicy {
    protected long lockTimeout;
    protected LocalSynchronizationManager synchManager;
    protected DistributedVersionManager versionManager;

    public TxCache(int maxSize, long lockTimeout) {
        super(2, maxSize);
        this.lockTimeout = lockTimeout;
        this.synchManager = new LocalSynchronizationManager(null);
        this.versionManager = new DistributedVersionManager(lockTimeout, this.synchManager);
        this.create();
        this.start();
    }

    public void insert(Object key, Object obj) {
        try {
            Object versioned = this.versionManager.makeVersioned(obj);
            super.insert(key, versioned);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

