/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.IsLastExpression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.MultiIterator;
import net.sf.saxon.expr.ParentNodeExpression;
import net.sf.saxon.expr.PathExpression;
import net.sf.saxon.expr.PositionRange;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.IntegerValue;

public final class LocationPathPattern
extends Pattern {
    public Pattern parentPattern = null;
    public Pattern ancestorPattern = null;
    public NodeTest nodeTest = AnyNodeTest.getInstance();
    protected Expression[] filters = null;
    protected int numberOfFilters = 0;
    protected Expression equivalentExpr = null;
    protected boolean firstElementPattern = false;
    protected boolean lastElementPattern = false;
    protected boolean specialFilter = false;
    private Expression variableBinding = null;
    private NodeTest refinedNodeTest = null;

    public void addFilter(Expression expression) {
        if (this.filters == null) {
            this.filters = new Expression[3];
        } else if (this.numberOfFilters == this.filters.length) {
            Expression[] expressionArray = new Expression[this.numberOfFilters * 2];
            System.arraycopy(this.filters, 0, expressionArray, 0, this.numberOfFilters);
            this.filters = expressionArray;
        }
        this.filters[this.numberOfFilters++] = expression;
        ExpressionTool.makeParentReferences(expression);
        if (expression instanceof ComputedExpression) {
            ((ComputedExpression)expression).setParentExpression(this);
        }
    }

    public Pattern simplify(StaticContext staticContext) throws XPathException {
        if (this.parentPattern == null && this.ancestorPattern == null && this.filters == null && !this.firstElementPattern && !this.lastElementPattern) {
            NodeTestPattern nodeTestPattern = new NodeTestPattern(this.nodeTest);
            nodeTestPattern.setSystemId(this.getSystemId());
            nodeTestPattern.setLineNumber(this.getLineNumber());
            return nodeTestPattern;
        }
        if (this.parentPattern != null) {
            this.parentPattern = this.parentPattern.simplify(staticContext);
        } else if (this.ancestorPattern != null) {
            this.ancestorPattern = this.ancestorPattern.simplify(staticContext);
        }
        if (this.filters != null) {
            for (int i = this.numberOfFilters - 1; i >= 0; --i) {
                Expression expression = this.filters[i];
                this.filters[i] = expression = expression.simplify(staticContext);
            }
        }
        return this;
    }

    public Pattern analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        Expression expression;
        TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
        if (this.parentPattern != null) {
            this.parentPattern = this.parentPattern.analyze(staticContext, itemType);
            AxisExpression axisExpression = this.nodeTest.getPrimitiveType() == 2 ? new AxisExpression(2, this.nodeTest) : new AxisExpression(3, this.nodeTest);
            axisExpression.setLocationId(staticContext.getLocationMap().allocateLocationId(staticContext.getSystemId(), this.getLineNumber()));
            axisExpression.setParentExpression(this);
            expression = axisExpression.typeCheck(staticContext, this.parentPattern.getNodeTest());
            this.refinedNodeTest = (NodeTest)expression.getItemType(typeHierarchy);
        } else if (this.ancestorPattern != null) {
            this.ancestorPattern = this.ancestorPattern.analyze(staticContext, itemType);
        }
        if (this.filters != null) {
            for (int i = this.numberOfFilters - 1; i >= 0; --i) {
                this.filters[i] = expression = this.filters[i].typeCheck(staticContext, this.getNodeTest());
                if (expression instanceof BooleanValue && ((BooleanValue)expression).getBooleanValue() && i == this.numberOfFilters - 1) {
                    --this.numberOfFilters;
                }
                if (!(staticContext instanceof ExpressionContext)) continue;
                ((ExpressionContext)staticContext).getStyleElement().allocateSlots(expression);
                this.filters[i] = expression;
            }
        }
        if (this.nodeTest.getPrimitiveType() == 1 && this.numberOfFilters == 1 && (this.filters[0] instanceof IntegerValue && ((IntegerValue)this.filters[0]).longValue() == 1L || this.filters[0] instanceof PositionRange && ((PositionRange)this.filters[0]).isFirstPositionOnly())) {
            this.firstElementPattern = true;
            this.specialFilter = true;
            this.numberOfFilters = 0;
            this.filters = null;
        }
        if (this.nodeTest.getPrimitiveType() == 1 && this.numberOfFilters == 1 && this.filters[0] instanceof IsLastExpression && ((IsLastExpression)this.filters[0]).getCondition()) {
            this.lastElementPattern = true;
            this.specialFilter = true;
            this.numberOfFilters = 0;
            this.filters = null;
        }
        if (this.isPositional(typeHierarchy)) {
            this.equivalentExpr = this.makeEquivalentExpression(staticContext);
            this.equivalentExpr = this.equivalentExpr.typeCheck(staticContext, itemType);
            ((ExpressionContext)staticContext).getStyleElement().allocateSlots(this.equivalentExpr);
            this.specialFilter = true;
        }
        return this;
    }

    public int getDependencies() {
        int n = 0;
        if (this.parentPattern != null) {
            n |= this.parentPattern.getDependencies();
        }
        if (this.ancestorPattern != null) {
            n |= this.ancestorPattern.getDependencies();
        }
        for (int i = 0; i < this.numberOfFilters; ++i) {
            n |= this.filters[i].getDependencies();
        }
        return n &= 0x80;
    }

    public Iterator iterateSubExpressions() {
        Iterator[] iteratorArray;
        Iterator iterator = this.numberOfFilters == 0 ? Collections.EMPTY_LIST.iterator() : Arrays.asList(this.filters).subList(0, this.numberOfFilters).iterator();
        if (this.variableBinding != null) {
            iteratorArray = new Iterator[]{iterator, new MonoIterator(this.variableBinding)};
            iterator = new MultiIterator(iteratorArray);
        }
        if (this.parentPattern != null) {
            iteratorArray = new Iterator[]{iterator, this.parentPattern.iterateSubExpressions()};
            iterator = new MultiIterator(iteratorArray);
        }
        if (this.ancestorPattern != null) {
            iteratorArray = new Iterator[]{iterator, this.ancestorPattern.iterateSubExpressions()};
            iterator = new MultiIterator(iteratorArray);
        }
        return iterator;
    }

    public void promote(PromotionOffer promotionOffer) throws XPathException {
        if (this.parentPattern != null) {
            this.parentPattern.promote(promotionOffer);
        }
        if (this.ancestorPattern != null) {
            this.ancestorPattern.promote(promotionOffer);
        }
        for (int i = 0; i < this.numberOfFilters; ++i) {
            this.filters[i] = this.filters[i].promote(promotionOffer);
        }
    }

    private ComputedExpression makeEquivalentExpression(StaticContext staticContext) throws XPathException {
        byte by = this.nodeTest.getPrimitiveType() == 2 ? (byte)2 : 3;
        ComputedExpression computedExpression = new AxisExpression(by, this.nodeTest);
        for (int i = 0; i < this.numberOfFilters; ++i) {
            computedExpression = new FilterExpression(computedExpression, this.filters[i]);
        }
        PathExpression pathExpression = new PathExpression(new ParentNodeExpression(), computedExpression);
        pathExpression.setParentExpression(this);
        return pathExpression;
    }

    public boolean matches(NodeInfo nodeInfo, XPathContext xPathContext) throws XPathException {
        if (this.variableBinding != null) {
            this.variableBinding.evaluateItem(xPathContext);
        }
        return this.internalMatches(nodeInfo, xPathContext);
    }

    protected boolean internalMatches(NodeInfo nodeInfo, XPathContext xPathContext) throws XPathException {
        Object object;
        if (!this.nodeTest.matches(nodeInfo)) {
            return false;
        }
        if (this.parentPattern != null) {
            object = nodeInfo.getParent();
            if (object == null) {
                return false;
            }
            if (!this.parentPattern.internalMatches((NodeInfo)object, xPathContext)) {
                return false;
            }
        }
        if (this.ancestorPattern != null) {
            object = nodeInfo.getParent();
            while (true) {
                if (object == null) {
                    return false;
                }
                if (this.ancestorPattern.internalMatches((NodeInfo)object, xPathContext)) break;
                object = object.getParent();
            }
        }
        if (this.specialFilter) {
            if (this.firstElementPattern) {
                object = nodeInfo.iterateAxis((byte)11, this.nodeTest);
                return object.next() == null;
            }
            if (this.lastElementPattern) {
                object = nodeInfo.iterateAxis((byte)7, this.nodeTest);
                return object.next() == null;
            }
            if (this.equivalentExpr != null) {
                object = xPathContext.newMinorContext();
                object.setOriginatingConstructType(2064);
                AxisIterator axisIterator = SingletonIterator.makeIterator(nodeInfo);
                axisIterator.next();
                object.setCurrentIterator(axisIterator);
                try {
                    NodeInfo nodeInfo2;
                    SequenceIterator sequenceIterator = this.equivalentExpr.iterate((XPathContext)object);
                    do {
                        if ((nodeInfo2 = (NodeInfo)sequenceIterator.next()) != null) continue;
                        return false;
                    } while (!nodeInfo2.isSameNodeInfo(nodeInfo));
                    return true;
                }
                catch (DynamicError dynamicError) {
                    DynamicError dynamicError2 = new DynamicError("An error occurred matching pattern {" + this.toString() + "}: ", dynamicError);
                    dynamicError2.setXPathContext((XPathContext)object);
                    dynamicError2.setErrorCode(dynamicError.getErrorCodeLocalPart());
                    dynamicError2.setLocator(this);
                    object.getController().recoverableError(dynamicError2);
                    return false;
                }
            }
        }
        if (this.filters != null) {
            object = xPathContext.newMinorContext();
            object.setOriginatingConstructType(2064);
            AxisIterator axisIterator = SingletonIterator.makeIterator(nodeInfo);
            axisIterator.next();
            object.setCurrentIterator(axisIterator);
            for (int i = 0; i < this.numberOfFilters; ++i) {
                try {
                    if (this.filters[i].effectiveBooleanValue((XPathContext)object)) continue;
                    return false;
                }
                catch (DynamicError dynamicError) {
                    DynamicError dynamicError3 = new DynamicError("An error occurred matching pattern {" + this.toString() + "}: ", dynamicError);
                    dynamicError3.setXPathContext((XPathContext)object);
                    dynamicError3.setErrorCode(dynamicError.getErrorCodeLocalPart());
                    dynamicError3.setLocator(this);
                    object.getController().recoverableError(dynamicError3);
                    return false;
                }
            }
        }
        return true;
    }

    public int getNodeKind() {
        return this.nodeTest.getPrimitiveType();
    }

    public int getFingerprint() {
        return this.nodeTest.getFingerprint();
    }

    public NodeTest getNodeTest() {
        if (this.refinedNodeTest != null) {
            return this.refinedNodeTest;
        }
        return this.nodeTest;
    }

    private boolean isPositional(TypeHierarchy typeHierarchy) {
        if (this.filters == null) {
            return false;
        }
        for (int i = 0; i < this.numberOfFilters; ++i) {
            int n = this.filters[i].getItemType(typeHierarchy).getPrimitiveType();
            if (n == 517 || n == 515 || n == 532 || n == 516 || n == 643) {
                return true;
            }
            if ((this.filters[i].getDependencies() & 0xC) == 0) continue;
            return true;
        }
        return false;
    }

    public void resolveCurrent(LetExpression letExpression, PromotionOffer promotionOffer) throws XPathException {
        for (int i = 0; i < this.numberOfFilters; ++i) {
            this.filters[i] = this.filters[i].promote(promotionOffer);
        }
        if (this.parentPattern instanceof LocationPathPattern) {
            ((LocationPathPattern)this.parentPattern).resolveCurrent(letExpression, promotionOffer);
        }
        if (this.ancestorPattern instanceof LocationPathPattern) {
            ((LocationPathPattern)this.ancestorPattern).resolveCurrent(letExpression, promotionOffer);
        }
        this.variableBinding = letExpression;
    }
}

